/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ktSignature;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.ktSignature.KotlinSignatureUtil;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;

class EditSignatureBalloon
implements Disposable {
    private final Editor editor;
    private final PsiModifierListOwner annotatedElement;
    private final Project project;
    private final String previousSignature;
    private final MyPanel panel;
    private final Balloon balloon;
    private final boolean editable;
    private final String kotlinSignatureAnnotationFqName;

    public EditSignatureBalloon(@NotNull PsiModifierListOwner annotatedElement, @NotNull String previousSignature, boolean editable, @NotNull String kotlinSignatureAnnotationFqName) {
        if (annotatedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotatedElement", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "<init>"));
        }
        if (previousSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousSignature", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "<init>"));
        }
        if (kotlinSignatureAnnotationFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinSignatureAnnotationFqName", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "<init>"));
        }
        this.annotatedElement = annotatedElement;
        this.previousSignature = previousSignature;
        this.editable = editable;
        this.kotlinSignatureAnnotationFqName = kotlinSignatureAnnotationFqName;
        this.project = annotatedElement.getProject();
        this.editor = this.createEditor();
        this.panel = new MyPanel();
        this.balloon = this.createBalloon();
    }

    private Balloon createBalloon() {
        Balloon balloon = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)this.panel, "Kotlin signature").setHideOnClickOutside(true).setHideOnKeyOutside(true).setBlockClicksThroughBalloon(true).createBalloon();
        balloon.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                Disposer.dispose((Disposable)EditSignatureBalloon.this);
            }
        });
        return balloon;
    }

    private Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        assert (editorFactory != null);
        LightVirtualFile virtualFile = new LightVirtualFile("signature.kt", (FileType)JetFileType.INSTANCE, (CharSequence)this.previousSignature);
        virtualFile.setWritable(this.editable);
        final Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        assert (document != null);
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                PsiDocumentManager psiDocManager = PsiDocumentManager.getInstance((Project)EditSignatureBalloon.this.project);
                final PsiFile psiFile = psiDocManager.getPsiFile(document);
                assert (psiFile instanceof JetFile);
                psiDocManager.performForCommittedDocument(document, new Runnable(){

                    @Override
                    public void run() {
                        EditSignatureBalloon.this.panel.setSaveButtonEnabled(EditSignatureBalloon.hasErrors((JetFile)psiFile));
                    }
                });
                psiDocManager.commitDocument(document);
            }
        }, (Disposable)this);
        Editor editor = editorFactory.createEditor(document, this.project, (FileType)JetFileType.INSTANCE, !this.editable);
        EditorSettings settings = editor.getSettings();
        settings.setVirtualSpace(false);
        settings.setLineMarkerAreaShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setRightMarginShown(false);
        settings.setAdditionalPageAtBottom(false);
        settings.setAdditionalLinesCount(2);
        settings.setAdditionalColumnsCount(12);
        assert (editor instanceof EditorEx);
        ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        editor.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, editor.getColorsScheme().getDefaultBackground());
        return editor;
    }

    private static int getLineY(@NotNull Editor editor, @NotNull PsiElement psiElementInEditor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "getLineY"));
        }
        if (psiElementInEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementInEditor", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "getLineY"));
        }
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(psiElementInEditor.getTextOffset());
        return editor.logicalPositionToXY((LogicalPosition)logicalPosition).y;
    }

    public void show(@Nullable Point point, final @NotNull Editor mainEditor, @NotNull PsiElement psiElementInEditor) {
        if (mainEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainEditor", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "show"));
        }
        if (psiElementInEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementInEditor", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "show"));
        }
        int lineY = EditSignatureBalloon.getLineY(mainEditor, psiElementInEditor);
        EditorGutterComponentEx gutter = (EditorGutterComponentEx)mainEditor.getGutter();
        Point adjustedPoint = point == null ? new Point(gutter.getIconsAreaWidth() + gutter.getLineMarkerAreaOffset(), lineY) : new Point(point.x, Math.min(lineY, point.y));
        this.balloon.show(new RelativePoint((Component)gutter, adjustedPoint), Balloon.Position.above);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeFocusManager.getInstance((Project)mainEditor.getProject()).requestFocus((Component)EditSignatureBalloon.this.editor.getContentComponent(), false);
            }
        });
    }

    public void dispose() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        assert (editorFactory != null);
        editorFactory.releaseEditor(this.editor);
    }

    private void saveAndHide() {
        this.balloon.hide();
        final String newSignature = this.editor.getDocument().getText();
        if (this.previousSignature.equals(newSignature)) {
            return;
        }
        new WriteCommandAction(this.project, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon$4", "run"));
                }
                ExternalAnnotationsManager.getInstance((Project)EditSignatureBalloon.this.project).editExternalAnnotation(EditSignatureBalloon.this.annotatedElement, EditSignatureBalloon.this.kotlinSignatureAnnotationFqName, KotlinSignatureUtil.signatureToNameValuePairs(EditSignatureBalloon.this.project, newSignature));
            }
        }.execute();
    }

    private static boolean hasErrors(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon", "hasErrors"));
        }
        return AnalyzingUtils.getSyntaxErrorRanges((PsiElement)file).isEmpty();
    }

    private class MyPanel
    extends JPanel {
        private final JButton saveButton;

        MyPanel() {
            super(new BorderLayout());
            this.add((Component)EditSignatureBalloon.this.editor.getComponent(), "Center");
            if (EditSignatureBalloon.this.editable) {
                JPanel toolbar = new JPanel(new FlowLayout(2));
                this.saveButton = new JButton("Save"){

                    @Override
                    public boolean isDefaultButton() {
                        return true;
                    }
                };
                toolbar.add(this.saveButton);
                this.add((Component)toolbar, "South");
                ActionListener saveAndHideListener = new ActionListener(){

                    @Override
                    public void actionPerformed(@NotNull ActionEvent e) {
                        if (e == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon$MyPanel$2", "actionPerformed"));
                        }
                        EditSignatureBalloon.this.saveAndHide();
                    }
                };
                this.saveButton.addActionListener(saveAndHideListener);
                this.registerKeyboardAction(saveAndHideListener, KeyStroke.getKeyStroke(10, 128), 2);
            } else {
                this.saveButton = null;
            }
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureBalloon$MyPanel$3", "actionPerformed"));
                    }
                    EditSignatureBalloon.this.balloon.hide();
                }
            }, KeyStroke.getKeyStroke(27, 0), 2);
        }

        void setSaveButtonEnabled(boolean enabled) {
            if (this.saveButton != null) {
                this.saveButton.setEnabled(enabled);
                this.saveButton.setToolTipText(enabled ? null : "Please fix errors in signature to save it.");
            }
        }
    }
}

