/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ktSignature;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.components.PsiBasedExternalAnnotationResolver;

class KotlinSignatureUtil {
    private KotlinSignatureUtil() {
    }

    @Nullable
    static PsiMember getAnalyzableAnnotationOwner(@NotNull PsiElement element) {
        PsiCompiledElement compiledElement;
        PsiMember annotationOwner;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "getAnalyzableAnnotationOwner"));
        }
        if (!(element instanceof PsiField) && !(element instanceof PsiMethod) || element instanceof PsiEnumConstant) {
            return null;
        }
        PsiMember member = (PsiMember)element;
        if (member.hasModifierProperty("private")) {
            return null;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass)) {
            return null;
        }
        PsiMember psiMember = annotationOwner = element.getOriginalElement() instanceof PsiMember ? (PsiMember)element.getOriginalElement() : (PsiMember)element;
        if (!annotationOwner.isPhysical() && (compiledElement = (PsiCompiledElement)element.getUserData(ClsElementImpl.COMPILED_ELEMENT)) instanceof PsiMember) {
            return (PsiMember)compiledElement;
        }
        return annotationOwner;
    }

    @NotNull
    static String getKotlinSignature(@NotNull PsiAnnotation kotlinSignatureAnnotation) {
        if (kotlinSignatureAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinSignatureAnnotation", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "getKotlinSignature"));
        }
        PsiNameValuePair pair2 = kotlinSignatureAnnotation.getParameterList().getAttributes()[0];
        PsiAnnotationMemberValue value2 = pair2.getValue();
        if (value2 == null) {
            if ("null" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "getKotlinSignature"));
            }
            return "null";
        }
        if (value2 instanceof PsiLiteralExpression) {
            Object valueObject = ((PsiLiteralExpression)value2).getValue();
            String string = valueObject == null ? "null" : StringUtil.unescapeStringCharacters((String)valueObject.toString());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "getKotlinSignature"));
            }
            return string;
        }
        String string = value2.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "getKotlinSignature"));
        }
        return string;
    }

    @NotNull
    static PsiNameValuePair[] signatureToNameValuePairs(@NotNull Project project, @NotNull String signature) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "signatureToNameValuePairs"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "signatureToNameValuePairs"));
        }
        PsiNameValuePair[] psiNameValuePairArray = JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@" + JvmAnnotationNames.KOTLIN_SIGNATURE + "(value=\"" + StringUtil.escapeStringCharacters((String)signature) + "\")", null).getParameterList().getAttributes();
        if (psiNameValuePairArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "signatureToNameValuePairs"));
        }
        return psiNameValuePairArray;
    }

    @Nullable
    static PsiAnnotation findKotlinSignatureAnnotation(@NotNull PsiElement element) {
        PsiAnnotation annotation2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "findKotlinSignatureAnnotation"));
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return null;
        }
        PsiMember annotationOwner = KotlinSignatureUtil.getAnalyzableAnnotationOwner(element);
        if (annotationOwner == null) {
            return null;
        }
        PsiModifierList list = annotationOwner.getModifierList();
        PsiAnnotation psiAnnotation = annotation2 = list == null ? null : list.findAnnotation(JvmAnnotationNames.KOTLIN_SIGNATURE.asString());
        if (annotation2 == null && (annotation2 = PsiBasedExternalAnnotationResolver.findExternalAnnotation((PsiModifierListOwner)annotationOwner, JvmAnnotationNames.KOTLIN_SIGNATURE)) == null) {
            PsiAnnotation psiAnnotation2 = annotation2 = list == null ? null : list.findAnnotation(JvmAnnotationNames.OLD_KOTLIN_SIGNATURE.asString());
            if (annotation2 == null) {
                annotation2 = PsiBasedExternalAnnotationResolver.findExternalAnnotation((PsiModifierListOwner)annotationOwner, JvmAnnotationNames.OLD_KOTLIN_SIGNATURE);
            }
        }
        if (annotation2 == null) {
            return null;
        }
        if (annotation2.getParameterList().getAttributes().length == 0) {
            return null;
        }
        return annotation2;
    }

    static void refreshMarkers(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "refreshMarkers"));
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    static boolean isAnnotationEditable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/ktSignature/KotlinSignatureUtil", "isAnnotationEditable"));
        }
        PsiMember annotationOwner = KotlinSignatureUtil.getAnalyzableAnnotationOwner(element);
        if (annotationOwner == null) {
            return false;
        }
        PsiAnnotation annotation2 = KotlinSignatureUtil.findKotlinSignatureAnnotation(element);
        assert (annotation2 != null) : "Annotation not found for " + element.getText();
        if (annotation2.getContainingFile() == annotationOwner.getContainingFile()) {
            return annotation2.isWritable();
        }
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)element.getProject());
        return annotationsManager.isExternalAnnotationWritable((PsiModifierListOwner)annotationOwner, annotation2.getQualifiedName());
    }
}

