/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.JetIcons;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.core.CorePackage;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class AddNameToArgumentFix
extends JetIntentionAction<JetValueArgument> {
    @NotNull
    private final List<String> possibleNames;

    public AddNameToArgumentFix(@NotNull JetValueArgument argument, @NotNull List<String> possibleNames) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "<init>"));
        }
        if (possibleNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleNames", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "<init>"));
        }
        super(argument);
        this.possibleNames = possibleNames;
    }

    @NotNull
    private static List<String> generatePossibleNames(@NotNull JetValueArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "generatePossibleNames"));
        }
        JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)argument, JetCallElement.class);
        assert (callElement2 != null) : "The argument has to be inside a function or constructor call";
        BindingContext context2 = ResolvePackage.analyzeFully(argument.getContainingJetFile());
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(callElement2, context2);
        if (resolvedCall == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "generatePossibleNames"));
            }
            return list;
        }
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        JetExpression argExpression = argument.getArgumentExpression();
        JetType type2 = argExpression != null ? context2.getType(argExpression) : null;
        Set usedParameters = KotlinPackage.toSet(CorePackage.mapArgumentsToParameters(resolvedCall.getCall(), callableDescriptor).values());
        ArrayList names = Lists.newArrayList();
        for (ValueParameterDescriptor parameter : callableDescriptor.getValueParameters()) {
            if (usedParameters.contains(parameter) || type2 != null && !JetTypeChecker.DEFAULT.isSubtypeOf(type2, parameter.getType())) continue;
            names.add(parameter.getName().asString());
        }
        ArrayList arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "generatePossibleNames"));
        }
        return arrayList;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor, JetFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "invoke"));
        }
        if (this.possibleNames.size() == 1 || editor == null || !editor.getComponent().isShowing()) {
            AddNameToArgumentFix.addName(project, (JetValueArgument)this.element, this.possibleNames.get(0));
        } else {
            this.chooseNameAndAdd(project, editor);
        }
    }

    private void chooseNameAndAdd(@NotNull Project project, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "chooseNameAndAdd"));
        }
        JBPopupFactory.getInstance().createListPopup(this.getNamePopup(project)).showInBestPositionFor(editor);
    }

    private ListPopupStep getNamePopup(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "getNamePopup"));
        }
        return new BaseListPopupStep<String>(JetBundle.message("add.name.to.parameter.name.chooser.title", new Object[0]), this.possibleNames){

            public PopupStep onChosen(String selectedName, boolean finalChoice) {
                if (finalChoice) {
                    AddNameToArgumentFix.addName(project, (JetValueArgument)AddNameToArgumentFix.this.element, selectedName);
                }
                return FINAL_CHOICE;
            }

            public Icon getIconFor(String name2) {
                return JetIcons.PARAMETER;
            }

            @NotNull
            public String getTextFor(String name2) {
                String string = AddNameToArgumentFix.getParsedArgumentWithName(name2, (JetValueArgument)AddNameToArgumentFix.this.element).getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix$1", "getTextFor"));
                }
                return string;
            }
        };
    }

    private static void addName(@NotNull Project project, final @NotNull JetValueArgument argument, final @NotNull String name2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "addName"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "addName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "addName"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        JetValueArgument newArgument = AddNameToArgumentFix.getParsedArgumentWithName(name2, argument);
                        argument.replace((PsiElement)newArgument);
                    }
                });
            }
        }, JetBundle.message("add.name.to.argument.action", new Object[0]), null);
    }

    @NotNull
    private static JetValueArgument getParsedArgumentWithName(@NotNull String name2, @NotNull JetValueArgument argument) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "getParsedArgumentWithName"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "getParsedArgumentWithName"));
        }
        JetExpression argumentExpression = argument.getArgumentExpression();
        assert (argumentExpression != null) : "Argument should be already parsed.";
        JetValueArgument jetValueArgument = PsiPackage.JetPsiFactory((PsiElement)argument).createArgument(argumentExpression, name2, false);
        if (jetValueArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "getParsedArgumentWithName"));
        }
        return jetValueArgument;
    }

    @NotNull
    public String getText() {
        if (this.possibleNames.size() == 1) {
            String string = JetBundle.message("add.name.to.argument.single", AddNameToArgumentFix.getParsedArgumentWithName(this.possibleNames.get(0), (JetValueArgument)this.element).getText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "getText"));
            }
            return string;
        }
        String string = JetBundle.message("add.name.to.argument.multiple", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.name.to.argument.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public static JetIntentionActionsFactory createFactory() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix$3", "createAction"));
                }
                JetValueArgument argument = QuickFixUtil.getParentElementOfType(diagnostic, JetValueArgument.class);
                if (argument == null) {
                    return null;
                }
                List possibleNames = AddNameToArgumentFix.generatePossibleNames(argument);
                return possibleNames.isEmpty() ? null : new AddNameToArgumentFix(argument, possibleNames);
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix", "createFactory"));
        }
        return jetSingleIntentionActionFactory;
    }
}

