/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberDependencyGraph;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsesMemberDependencyGraph;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MovePackage;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.DeferredJetFileKotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.JetFileKotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.MoveKotlinTopLevelDeclarationsOptions;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.MoveKotlinTopLevelDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.util.application.ApplicationPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;

public class MoveKotlinTopLevelDeclarationsDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = "MoveKotlinTopLevelDeclarationsDialog.RECENTS_KEY";
    private JCheckBox cbSearchInComments;
    private JCheckBox cbSearchTextOccurrences;
    private JPanel mainPanel;
    private ReferenceEditorComboWithBrowseButton classPackageChooser;
    private ComboboxWithBrowseButton destinationFolderCB;
    private JPanel targetPanel;
    private JRadioButton rbMoveToPackage;
    private JRadioButton rbMoveToFile;
    private TextFieldWithBrowseButton fileChooser;
    private JPanel memberInfoPanel;
    private JTextField tfFileNameInPackage;
    private JCheckBox cbSpecifyFileNameInPackage;
    private KotlinMemberSelectionTable memberTable;
    private final JetFile sourceFile;
    private final MoveCallback moveCallback;

    public MoveKotlinTopLevelDeclarationsDialog(@NotNull Project project, @NotNull JetFile sourceFile, @NotNull Set<JetNamedDeclaration> elementsToMove, @Nullable String targetPackageName, @Nullable PsiDirectory targetDirectory, @Nullable JetFile targetFile, boolean moveToPackage, boolean searchInComments, boolean searchForTextOccurences, @Nullable MoveCallback moveCallback) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "<init>"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "<init>"));
        }
        if (elementsToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToMove", "org/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "<init>"));
        }
        super(project, true);
        this.sourceFile = sourceFile;
        this.moveCallback = moveCallback;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.initSearchOptions(searchInComments, searchForTextOccurences);
        this.initPackageChooser(targetPackageName, targetDirectory);
        this.initFileChooser(targetFile);
        this.initMoveToButtons(moveToPackage);
        this.initMemberInfo(elementsToMove);
        this.updateControls();
        this.pack();
    }

    private void initMemberInfo(final @NotNull Set<JetNamedDeclaration> elementsToMove) {
        if (elementsToMove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsToMove", "org/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog", "initMemberInfo"));
        }
        final List memberInfos = KotlinPackage.map((Iterable)KotlinPackage.filterIsInstance(this.sourceFile.getDeclarations(), JetNamedDeclaration.class), (Function1)new Function1<JetNamedDeclaration, KotlinMemberInfo>(){

            public KotlinMemberInfo invoke(JetNamedDeclaration declaration) {
                KotlinMemberInfo memberInfo = new KotlinMemberInfo(declaration);
                memberInfo.setChecked(elementsToMove.contains(declaration));
                return memberInfo;
            }
        });
        KotlinMemberSelectionPanel selectionPanel = new KotlinMemberSelectionPanel(this.getTitle(), memberInfos, null);
        this.memberTable = selectionPanel.getTable();
        MemberInfoModelImpl memberInfoModel = new MemberInfoModelImpl();
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)memberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)new MemberInfoChangeListener<JetNamedDeclaration, KotlinMemberInfo>(){

            private boolean shouldUpdateFileNameField(final Collection<KotlinMemberInfo> changedMembers) {
                if (!MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.isEnabled()) {
                    return true;
                }
                List previousDeclarations = KotlinPackage.filterNotNull((Iterable)KotlinPackage.map((Iterable)memberInfos, (Function1)new Function1<KotlinMemberInfo, JetNamedDeclaration>(){

                    public JetNamedDeclaration invoke(KotlinMemberInfo info) {
                        return changedMembers.contains((Object)info) != info.isChecked() ? (JetNamedDeclaration)info.getMember() : null;
                    }
                }));
                String suggestedText = previousDeclarations.isEmpty() ? "" : MovePackage.guessNewFileName(MoveKotlinTopLevelDeclarationsDialog.this.sourceFile, previousDeclarations);
                return MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.getText().equals(suggestedText);
            }

            public void memberInfoChanged(MemberInfoChange<JetNamedDeclaration, KotlinMemberInfo> event) {
                if (this.shouldUpdateFileNameField(event.getChangedMembers())) {
                    MoveKotlinTopLevelDeclarationsDialog.this.updateSuggestedFileName();
                }
            }
        });
        this.memberInfoPanel.add((Component)((Object)selectionPanel), "Center");
    }

    private void updateSuggestedFileName() {
        this.tfFileNameInPackage.setText(MovePackage.guessNewFileName(this.sourceFile, this.getSelectedElementsToMove()));
    }

    private void initPackageChooser(String targetPackageName, PsiDirectory targetDirectory) {
        if (targetPackageName != null && targetPackageName.length() != 0) {
            this.classPackageChooser.prependItem(targetPackageName);
        }
        ((DestinationFolderComboBox)this.destinationFolderCB).setData(this.myProject, targetDirectory, (Pass)new Pass<String>(){

            public void pass(String s) {
                MoveKotlinTopLevelDeclarationsDialog.this.setErrorText(s);
            }
        }, (EditorComboBox)this.classPackageChooser.getChildComponent());
        this.cbSpecifyFileNameInPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$4", "actionPerformed"));
                }
                MoveKotlinTopLevelDeclarationsDialog.this.tfFileNameInPackage.setEnabled(MoveKotlinTopLevelDeclarationsDialog.this.cbSpecifyFileNameInPackage.isSelected());
            }
        });
    }

    private void initSearchOptions(boolean searchInComments, boolean searchForTextOccurences) {
        this.cbSearchInComments.setSelected(searchInComments);
        this.cbSearchTextOccurrences.setSelected(searchForTextOccurences);
    }

    private void initMoveToButtons(boolean moveToPackage) {
        if (moveToPackage) {
            this.rbMoveToPackage.setSelected(true);
        } else {
            this.rbMoveToFile.setSelected(true);
        }
        this.rbMoveToPackage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$5", "actionPerformed"));
                }
                MoveKotlinTopLevelDeclarationsDialog.this.classPackageChooser.requestFocus();
                MoveKotlinTopLevelDeclarationsDialog.this.updateControls();
            }
        });
        this.rbMoveToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/move/moveTopLevelDeclarations/ui/MoveKotlinTopLevelDeclarationsDialog$6", "actionPerformed"));
                }
                MoveKotlinTopLevelDeclarationsDialog.this.fileChooser.requestFocus();
                MoveKotlinTopLevelDeclarationsDialog.this.updateControls();
            }
        });
    }

    private void initFileChooser(JetFile targetFile) {
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withRoots(ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()).withTreeRootVisible(true);
        String title = JetRefactoringBundle.message("refactoring.move.top.level.declaration.file.title", new Object[0]);
        this.fileChooser.addBrowseFolderListener(title, null, this.myProject, descriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        if (targetFile != null) {
            this.fileChooser.setText(targetFile.getVirtualFile().getPath());
        }
    }

    private void createUIComponents() {
        this.classPackageChooser = this.createPackageChooser();
        this.destinationFolderCB = new DestinationFolderComboBox(){

            public String getTargetPackage() {
                return MoveKotlinTopLevelDeclarationsDialog.this.getTargetPackage();
            }
        };
    }

    private ReferenceEditorComboWithBrowseButton createPackageChooser() {
        PackageNameReferenceEditorCombo packageChooser = new PackageNameReferenceEditorCombo("", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
        Document document = ((EditorComboBox)packageChooser.getChildComponent()).getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                MoveKotlinTopLevelDeclarationsDialog.this.validateButtons();
            }
        });
        return packageChooser;
    }

    private void updateControls() {
        boolean moveToPackage = this.isMoveToPackage();
        this.classPackageChooser.setEnabled(moveToPackage);
        this.fileChooser.setEnabled(!moveToPackage);
        UIUtil.setEnabled((Component)this.targetPanel, (moveToPackage && this.hasAnySourceRoots() ? 1 : 0) != 0, (boolean)true);
        this.updateSuggestedFileName();
        this.validateButtons();
    }

    private boolean hasAnySourceRoots() {
        return !JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)this.myProject).isEmpty();
    }

    private void saveRefactoringSettings() {
        JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
        refactoringSettings.MOVE_SEARCH_IN_COMMENTS = this.isSearchInComments();
        refactoringSettings.MOVE_SEARCH_FOR_TEXT = this.isSearchInNonJavaFiles();
        refactoringSettings.MOVE_PREVIEW_USAGES = this.isPreviewUsages();
    }

    @Nullable
    private MoveDestination selectPackageBasedMoveDestination() {
        int ret;
        String packageName = this.getTargetPackage();
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, packageName);
        PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName);
        if (!targetPackage.exists() && (ret = Messages.showYesNoDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"package.does.not.exist", (Object[])new Object[]{packageName}), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon())) != 0) {
            return null;
        }
        return ((DestinationFolderComboBox)this.destinationFolderCB).selectDirectory(targetPackage, false);
    }

    @Nullable
    private KotlinMoveTarget selectMoveTarget() {
        String message = this.verifyBeforeRun();
        if (message != null) {
            this.setErrorText(message);
            return null;
        }
        this.setErrorText(null);
        if (this.isMoveToPackage()) {
            PsiFile targetFile;
            final MoveDestination moveDestination = this.selectPackageBasedMoveDestination();
            if (moveDestination == null) {
                return null;
            }
            final String targetFileName = this.tfFileNameInPackage.getText();
            PsiDirectory directory = moveDestination.getTargetIfExists((PsiFile)this.sourceFile);
            PsiFile psiFile = targetFile = directory != null ? directory.findFile(targetFileName) : null;
            if (targetFile != null) {
                if (targetFile == this.sourceFile) {
                    this.setErrorText("Can't move to the original file");
                    return null;
                }
                String question = "File '" + directory.getVirtualFile().getPath() + "/" + targetFileName + "' already exists. Do you want to move selected declarations to this file?";
                int ret = Messages.showYesNoDialog((Project)this.myProject, (String)question, (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon());
                if (ret != 0) {
                    return null;
                }
            }
            return new DeferredJetFileKotlinMoveTarget(this.myProject, new FqName(this.getTargetPackage()), (Function0<? extends JetFile>)new Function0<JetFile>(){

                public JetFile invoke() {
                    PsiDirectory directory = moveDestination.getTargetDirectory((PsiFile)MoveKotlinTopLevelDeclarationsDialog.this.sourceFile);
                    return RefactoringPackage.getOrCreateKotlinFile(targetFileName, directory);
                }
            });
        }
        final File targetFile = new File(this.getTargetFilePath());
        JetFile jetFile = (JetFile)RefactoringPackage.toPsiFile(targetFile, this.myProject);
        if (jetFile != null) {
            if (jetFile == this.sourceFile) {
                this.setErrorText("Can't move to the original file");
                return null;
            }
            return new JetFileKotlinMoveTarget(jetFile);
        }
        int ret = Messages.showYesNoDialog((Project)this.myProject, (String)JetRefactoringBundle.message("file.does.not.exist", targetFile.getName()), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return null;
        }
        File targetDir = targetFile.getParentFile();
        final PsiDirectory psiDirectory = RefactoringPackage.toPsiDirectory(targetDir, this.myProject);
        assert (psiDirectory != null) : "No directory found: " + targetDir.getPath();
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
        if (psiPackage == null) {
            this.setErrorText("Could not find package corresponding to " + targetDir.getPath());
            return null;
        }
        return new DeferredJetFileKotlinMoveTarget(this.myProject, new FqName(psiPackage.getQualifiedName()), (Function0<? extends JetFile>)new Function0<JetFile>(){

            public JetFile invoke() {
                return RefactoringPackage.getOrCreateKotlinFile(targetFile.getName(), psiDirectory);
            }
        });
    }

    @Nullable
    private String verifyBeforeRun() {
        if (this.memberTable.getSelectedMemberInfos().isEmpty()) {
            return "At least one member must be selected";
        }
        if (this.isMoveToPackage()) {
            String name2 = this.getTargetPackage();
            if (name2.length() != 0 && !PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(name2)) {
                return "'" + name2 + "' is invalid destination package name";
            }
        } else {
            PsiFile targetFile = RefactoringPackage.toPsiFile(new File(this.getTargetFilePath()), this.myProject);
            if (targetFile != null && !(targetFile instanceof JetFile)) {
                return JetRefactoringBundle.message("refactoring.move.non.kotlin.file", new Object[0]);
            }
        }
        if (this.tfFileNameInPackage.getText().isEmpty()) {
            return "File name may not be empty";
        }
        return null;
    }

    private List<JetNamedDeclaration> getSelectedElementsToMove() {
        return KotlinPackage.map((Iterable)this.memberTable.getSelectedMemberInfos(), (Function1)new Function1<KotlinMemberInfo, JetNamedDeclaration>(){

            public JetNamedDeclaration invoke(KotlinMemberInfo info) {
                return (JetNamedDeclaration)info.getMember();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    protected final String getTargetPackage() {
        return this.classPackageChooser.getText().trim();
    }

    protected final String getTargetFilePath() {
        return this.fileChooser.getText();
    }

    protected void canRun() throws ConfigurationException {
        String message = this.verifyBeforeRun();
        if (message != null) {
            throw new ConfigurationException(message);
        }
    }

    protected void doAction() {
        KotlinMoveTarget target = this.selectMoveTarget();
        if (target == null) {
            return;
        }
        this.saveRefactoringSettings();
        List<JetNamedDeclaration> elementsToMove = this.getSelectedElementsToMove();
        for (JetNamedDeclaration element : elementsToMove) {
            String message = target.verify(element.getContainingFile());
            if (message == null) continue;
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)message, null, (Project)this.myProject);
            return;
        }
        try {
            boolean deleteSourceFile = false;
            if (elementsToMove.size() == this.sourceFile.getDeclarations().size() && this.isMoveToPackage()) {
                final MoveDestination moveDestination = this.selectPackageBasedMoveDestination();
                PsiDirectory targetDir = moveDestination.getTargetIfExists((PsiFile)this.sourceFile);
                final String targetFileName = this.tfFileNameInPackage.getText();
                if (targetDir == null || targetDir.findFile(targetFileName) == null) {
                    final String temporaryName = UniqueNameGenerator.generateUniqueName((String)"temp", (String)"", (String)".kt", (Collection)KotlinPackage.map((Object[])this.sourceFile.getContainingDirectory().getFiles(), (Function1)new Function1<PsiFile, String>(){

                        public String invoke(PsiFile file) {
                            return file.getName();
                        }
                    }));
                    PsiDirectory targetDirectory = ApplicationPackage.runWriteAction(new Function0<PsiDirectory>(){

                        public PsiDirectory invoke() {
                            MoveKotlinTopLevelDeclarationsDialog.this.sourceFile.setName(temporaryName);
                            return moveDestination.getTargetDirectory((PsiFile)MoveKotlinTopLevelDeclarationsDialog.this.sourceFile);
                        }
                    });
                    this.invokeRefactoring((BaseRefactoringProcessor)new MoveFilesOrDirectoriesProcessor(this.myProject, new PsiElement[]{this.sourceFile}, targetDirectory, RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE, this.isSearchInComments(), this.isSearchInNonJavaFiles(), new MoveCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void refactoringCompleted() {
                            try {
                                MoveKotlinTopLevelDeclarationsDialog.this.sourceFile.setName(targetFileName);
                            }
                            finally {
                                if (MoveKotlinTopLevelDeclarationsDialog.this.moveCallback != null) {
                                    MoveKotlinTopLevelDeclarationsDialog.this.moveCallback.refactoringCompleted();
                                }
                            }
                        }
                    }, EmptyRunnable.INSTANCE));
                    return;
                }
                int ret = Messages.showYesNoCancelDialog((Project)this.myProject, (String)("You are going to move all declarations out of '" + this.sourceFile.getVirtualFile().getPath() + "'. Do you want to delete this file?"), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon());
                if (ret == 2) {
                    return;
                }
                deleteSourceFile = ret == 0;
            }
            MoveKotlinTopLevelDeclarationsOptions options = new MoveKotlinTopLevelDeclarationsOptions(this.sourceFile, elementsToMove, target, this.isSearchInComments(), this.isSearchInNonJavaFiles(), true, deleteSourceFile, this.moveCallback);
            this.invokeRefactoring(new MoveKotlinTopLevelDeclarationsProcessor(this.myProject, options, Mover.Default.INSTANCE$));
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
    }

    private boolean isSearchInNonJavaFiles() {
        return this.cbSearchTextOccurrences.isSelected();
    }

    private boolean isSearchInComments() {
        return this.cbSearchInComments.isSelected();
    }

    private boolean isMoveToPackage() {
        return this.rbMoveToPackage.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.classPackageChooser.getChildComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        this.memberInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "South");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(5, 2, new Insets(7, 0, 7, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.classPackageChooser;
        jPanel6.add((Component)referenceEditorComboWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToPackage = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("To package:");
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.fileChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.rbMoveToFile = jRadioButton = new JRadioButton();
        jRadioButton.setText("To file:");
        jRadioButton.setMnemonic('F');
        jRadioButton.setDisplayedMnemonicIndex(3);
        jPanel6.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.cbSearchInComments = nonFocusableCheckBox;
        nonFocusableCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.in.comments.and.strings"));
        jPanel6.add((Component)nonFocusableCheckBox, new GridConstraints(4, 0, 1, 1, 8, 3, 0, 0, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.cbSearchTextOccurrences = nonFocusableCheckBox2;
        nonFocusableCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("search.for.text.occurrences"));
        jPanel6.add((Component)nonFocusableCheckBox2, new GridConstraints(4, 1, 1, 1, 8, 3, 0, 0, null, null, null));
        this.tfFileNameInPackage = jTextField = new JTextField();
        ((Component)jTextField).setEnabled(false);
        jPanel6.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.cbSpecifyFileNameInPackage = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(2);
        jCheckBox.setText("File name:");
        jCheckBox.setMnemonic('N');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jCheckBox.setHorizontalTextPosition(11);
        jPanel6.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 0, null, null, null, 5));
        this.targetPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 5));
        JLabel jLabel = new JLabel();
        jLabel.setText("Destination directory:");
        jLabel.setDisplayedMnemonic('D');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.destinationFolderCB;
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MemberInfoModelImpl
    extends DependencyMemberInfoModel<JetNamedDeclaration, KotlinMemberInfo> {
        public MemberInfoModelImpl() {
            super((MemberDependencyGraph)new UsesMemberDependencyGraph((PsiElement)MoveKotlinTopLevelDeclarationsDialog.this.sourceFile, null, false), 1);
        }

        @Nullable
        public Boolean isFixedAbstract(KotlinMemberInfo member) {
            return null;
        }

        public boolean isCheckedWhenDisabled(KotlinMemberInfo member) {
            return false;
        }
    }
}

