/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.context.ContextPackage;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleParameters;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.di.InjectorForLazyResolve;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationPackage;
import org.jetbrains.kotlin.types.DynamicTypesSettings;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class BuiltInsReferenceResolver
extends AbstractProjectComponent {
    private static final File BUILT_INS_COMPILABLE_SRC_DIR = new File("core/builtins/src", KotlinBuiltIns.BUILT_INS_PACKAGE_NAME.asString());
    private volatile ModuleDescriptor moduleDescriptor;
    private volatile Set<JetFile> builtInsSources;
    private volatile PackageFragmentDescriptor builtinsPackageFragment;

    public BuiltInsReferenceResolver(Project project) {
        super(project);
    }

    public void initComponent() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                BuiltInsReferenceResolver.this.initialize();
            }
        });
    }

    public Set<JetFile> getBuiltInsSources() {
        return this.builtInsSources;
    }

    private void initialize() {
        assert (this.moduleDescriptor == null) : "Attempt to initialize twice";
        final Set<JetFile> jetBuiltInsFiles = this.getJetBuiltInsFiles();
        final Runnable initializeRunnable = new Runnable(){

            @Override
            public void run() {
                MutableModuleContext newModuleContext = ContextPackage.ContextForNewModule(BuiltInsReferenceResolver.this.myProject, Name.special("<built-ins resolver module>"), ModuleParameters.Empty.INSTANCE$);
                newModuleContext.setDependencies(newModuleContext.getModule());
                FileBasedDeclarationProviderFactory declarationFactory = new FileBasedDeclarationProviderFactory(newModuleContext.getStorageManager(), jetBuiltInsFiles);
                InjectorForLazyResolve injectorForLazyResolve = new InjectorForLazyResolve(newModuleContext, declarationFactory, new BindingTraceContext(), AdditionalCheckerProvider.DefaultProvider.INSTANCE$, new DynamicTypesSettings());
                newModuleContext.initializeModuleContents(injectorForLazyResolve.getResolveSession().getPackageFragmentProvider());
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    injectorForLazyResolve.getResolveSession().forceResolveAll();
                }
                PackageViewDescriptor packageView = newModuleContext.getModule().getPackage(KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME);
                assert (packageView != null) : "Should contain " + KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME + " package";
                List<PackageFragmentDescriptor> fragments = packageView.getFragments();
                BuiltInsReferenceResolver.this.moduleDescriptor = newModuleContext.getModule();
                BuiltInsReferenceResolver.this.builtinsPackageFragment = (PackageFragmentDescriptor)KotlinPackage.single(fragments);
                BuiltInsReferenceResolver.this.builtInsSources = Sets.newHashSet((Iterable)jetBuiltInsFiles);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            initializeRunnable.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runReadAction(initializeRunnable);
                }
            });
        }
    }

    @NotNull
    private Set<JetFile> getJetBuiltInsFiles() {
        Set<JetFile> builtIns = this.getBuiltInSourceFiles(LightClassUtil.getBuiltInsDirUrl());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                builtIns.addAll(this.getBuiltInSourceFiles(BUILT_INS_COMPILABLE_SRC_DIR.toURI().toURL()));
            }
            catch (MalformedURLException e) {
                throw UtilsPackage.rethrow(e);
            }
        }
        Set<JetFile> set = builtIns;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "getJetBuiltInsFiles"));
        }
        return set;
    }

    @NotNull
    private Set<JetFile> getBuiltInSourceFiles(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "getBuiltInSourceFiles"));
        }
        String fromUrl = VfsUtilCore.convertFromUrl((URL)url);
        VirtualFile vf = VirtualFileManager.getInstance().findFileByUrl(fromUrl);
        assert (vf != null) : "Virtual file not found by URL: " + url;
        vf.getChildren();
        vf.refresh(false, true);
        PathUtil.getLocalFile((VirtualFile)vf).refresh(false, true);
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(vf);
        assert (psiDirectory != null) : "No PsiDirectory for " + vf;
        HashSet<JetFile> hashSet = new HashSet<JetFile>(ContainerUtil.mapNotNull((Object[])psiDirectory.getFiles(), (Function)new Function<PsiFile, JetFile>(){

            public JetFile fun(PsiFile file) {
                return file instanceof JetFile ? (JetFile)file : null;
            }
        }));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "getBuiltInSourceFiles"));
        }
        return hashSet;
    }

    @Nullable
    private DeclarationDescriptor findCurrentDescriptorForMember(@NotNull MemberDescriptor originalDescriptor) {
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "findCurrentDescriptorForMember"));
        }
        if (!BuiltInsReferenceResolver.isFromBuiltinModule(originalDescriptor)) {
            return null;
        }
        DeclarationDescriptor containingDeclaration = this.findCurrentDescriptor(originalDescriptor.getContainingDeclaration());
        JetScope memberScope2 = BuiltInsReferenceResolver.getMemberScope(containingDeclaration);
        if (memberScope2 == null) {
            return null;
        }
        String renderedOriginal = DescriptorRenderer.FQ_NAMES_IN_TYPES.render(originalDescriptor);
        Collection<DeclarationDescriptor> descriptors = originalDescriptor instanceof ConstructorDescriptor && containingDeclaration instanceof ClassDescriptor ? ((ClassDescriptor)containingDeclaration).getConstructors() : memberScope2.getAllDescriptors();
        for (DeclarationDescriptor member : descriptors) {
            if (!renderedOriginal.equals(DescriptorRenderer.FQ_NAMES_IN_TYPES.render(member))) continue;
            return member;
        }
        return null;
    }

    @Nullable
    private DeclarationDescriptor findCurrentDescriptor(@NotNull DeclarationDescriptor originalDescriptor) {
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "findCurrentDescriptor"));
        }
        if (originalDescriptor instanceof ClassDescriptor) {
            return BuiltInsReferenceResolver.isFromBuiltinModule(originalDescriptor) ? DeserializationPackage.findClassAcrossModuleDependencies(this.moduleDescriptor, DescriptorUtilPackage.getClassId((ClassDescriptor)originalDescriptor)) : null;
        }
        if (originalDescriptor instanceof PackageFragmentDescriptor) {
            return BuiltInsReferenceResolver.isFromBuiltinModule(originalDescriptor) && KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.equals(((PackageFragmentDescriptor)originalDescriptor).getFqName()) ? this.builtinsPackageFragment : null;
        }
        if (originalDescriptor instanceof MemberDescriptor) {
            return this.findCurrentDescriptorForMember((MemberDescriptor)originalDescriptor);
        }
        return null;
    }

    private static boolean isFromBuiltinModule(@NotNull DeclarationDescriptor originalDescriptor) {
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "isFromBuiltinModule"));
        }
        return KotlinBuiltIns.getInstance().getBuiltInsModule() == DescriptorUtils.getContainingModule(originalDescriptor);
    }

    @Nullable
    public PsiElement resolveBuiltInSymbol(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "resolveBuiltInSymbol"));
        }
        if (this.moduleDescriptor == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = this.findCurrentDescriptor(declarationDescriptor);
        if (descriptor2 != null) {
            return DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
        }
        return null;
    }

    public static boolean isFromBuiltIns(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/references/BuiltInsReferenceResolver", "isFromBuiltIns"));
        }
        return ((BuiltInsReferenceResolver)((Object)element.getProject().getComponent(BuiltInsReferenceResolver.class))).builtInsSources.contains(element.getContainingFile());
    }

    @Nullable
    private static JetScope getMemberScope(@Nullable DeclarationDescriptor parent) {
        if (parent instanceof ClassDescriptor) {
            return ((ClassDescriptor)parent).getDefaultType().getMemberScope();
        }
        if (parent instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)parent).getMemberScope();
        }
        return null;
    }
}

