/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.org.objectweb.asm.Type;

public class PackagePartClassUtils {
    public static int getPathHashCode(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPathHashCode"));
        }
        return FileUtil.toSystemDependentName((String)file.getPath()).hashCode();
    }

    @NotNull
    private static String replaceSpecialSymbols(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "replaceSpecialSymbols"));
        }
        String string = str.replace('.', '_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "replaceSpecialSymbols"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackagePartFqName(@NotNull FqName facadeFqName, @NotNull VirtualFile file) {
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        String fileName = FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)file.getName()));
        String srcName = String.format("%s$%s$%08x", facadeFqName.shortName().asString(), PackagePartClassUtils.replaceSpecialSymbols(fileName), PackagePartClassUtils.getPathHashCode(file));
        FqName fqName2 = facadeFqName.parent().child(Name.identifier(srcName));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static Type getPackagePartType(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartType"));
        }
        Type type2 = Type.getObjectType((String)PackagePartClassUtils.getPackagePartInternalName(file));
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartType"));
        }
        return type2;
    }

    @NotNull
    public static String getPackagePartInternalName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartInternalName"));
        }
        FqName fqName2 = PackagePartClassUtils.getPackagePartFqName(file);
        String string = JvmClassName.byFqNameWithoutInnerClasses(fqName2).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartInternalName"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackagePartFqName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        FqName fqName2 = PackagePartClassUtils.getPackagePartFqName(PackageClassUtils.getPackageClassFqName(file.getPackageFqName()), file.getVirtualFile());
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static FqName getPackagePartFqName(@NotNull DeserializedCallableMemberDescriptor callable) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        FqName packageFqName = ((PackageFragmentDescriptor)callable.getContainingDeclaration()).getFqName();
        FqName fqName2 = packageFqName.child(callable.getNameResolver().getName((Integer)callable.getProto().getExtension(JvmProtoBuf.implClassName)));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackagePartFqName"));
        }
        return fqName2;
    }

    @NotNull
    public static List<JetFile> getPackageFilesWithCallables(@NotNull Collection<JetFile> packageFiles) {
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackageFilesWithCallables"));
        }
        List list = ContainerUtil.filter(packageFiles, (Condition)new Condition<JetFile>(){

            public boolean value(JetFile packageFile) {
                return PackagePartClassUtils.fileHasCallables(packageFile);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "getPackageFilesWithCallables"));
        }
        return list;
    }

    public static boolean fileHasCallables(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/load/kotlin/PackagePartClassUtils", "fileHasCallables"));
        }
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (!(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction)) continue;
            return true;
        }
        return false;
    }
}

