/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclarationStub;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedDeclarationUtil;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;

abstract class JetNamedDeclarationStub<T extends KotlinStubWithFqName>
extends JetDeclarationStub<T>
implements JetNamedDeclaration {
    public JetNamedDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "<init>"));
        }
        super(stub, nodeType);
    }

    public JetNamedDeclarationStub(@NotNull ASTNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "<init>"));
        }
        super(node2);
    }

    public String getName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text = identifier.getText();
            return text != null ? JetPsiUtil.unquoteIdentifier(text) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name2 = this.getName();
        return name2 != null ? Name.identifier(name2) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        Name name2 = JetPsiUtil.safeName(this.getName());
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "getNameAsSafeName"));
        }
        return name2;
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "setName"));
        }
        return this.getNameIdentifier().replace(PsiPackage.JetPsiFactory(this).createNameIdentifier(name2));
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @NotNull
    public SearchScope getUseScope() {
        JetElement enclosingBlock = JetPsiUtil.getEnclosingElementForLocalDeclaration(this, false);
        if (enclosingBlock != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)enclosingBlock);
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "getUseScope"));
            }
            return localSearchScope;
        }
        if (this.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            JetElement companionObjectClass;
            JetElement containingClass = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)this, JetClassOrObject.class);
            if (containingClass instanceof JetObjectDeclaration && ((JetObjectDeclaration)containingClass).isCompanion() && (companionObjectClass = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)containingClass, JetClassOrObject.class)) != null) {
                containingClass = companionObjectClass;
            }
            if (containingClass != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)containingClass);
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "getUseScope"));
                }
                return localSearchScope;
            }
        }
        SearchScope searchScope2 = super.getUseScope();
        if (searchScope2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetNamedDeclarationStub", "getUseScope"));
        }
        return searchScope2;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getStub();
        if (stub != null) {
            return stub.getFqName();
        }
        return JetNamedDeclarationUtil.getFQName(this);
    }
}

