/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetNameReferenceExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTreeVisitor;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;

class PreliminaryLoopVisitor
extends JetTreeVisitor<Void> {
    private final JetLoopExpression loopExpression;
    private final Set<Name> assignedNames;

    private PreliminaryLoopVisitor(@NotNull JetLoopExpression loopExpression) {
        if (loopExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExpression", "org/jetbrains/kotlin/types/expressions/PreliminaryLoopVisitor", "<init>"));
        }
        this.assignedNames = new LinkedHashSet<Name>();
        this.loopExpression = loopExpression;
    }

    @NotNull
    public static PreliminaryLoopVisitor visitLoop(@NotNull JetLoopExpression loopExpression) {
        if (loopExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopExpression", "org/jetbrains/kotlin/types/expressions/PreliminaryLoopVisitor", "visitLoop"));
        }
        PreliminaryLoopVisitor visitor2 = new PreliminaryLoopVisitor(loopExpression);
        loopExpression.accept(visitor2, null);
        PreliminaryLoopVisitor preliminaryLoopVisitor = visitor2;
        if (preliminaryLoopVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PreliminaryLoopVisitor", "visitLoop"));
        }
        return preliminaryLoopVisitor;
    }

    @NotNull
    public DataFlowInfo clearDataFlowInfoForAssignedLocalVariables(@NotNull DataFlowInfo dataFlowInfo) {
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/types/expressions/PreliminaryLoopVisitor", "clearDataFlowInfoForAssignedLocalVariables"));
        }
        Map<DataFlowValue, Nullability> nullabilityMap = dataFlowInfo.getCompleteNullabilityInfo();
        LinkedHashSet<DataFlowValue> valueSetToClear = new LinkedHashSet<DataFlowValue>();
        for (DataFlowValue value2 : nullabilityMap.keySet()) {
            LocalVariableDescriptor descriptor2;
            if (!value2.isUncapturedLocalVariable() || !(value2.getId() instanceof LocalVariableDescriptor) || !this.assignedNames.contains((descriptor2 = (LocalVariableDescriptor)value2.getId()).getName())) continue;
            valueSetToClear.add(value2);
        }
        for (DataFlowValue valueToClear : valueSetToClear) {
            dataFlowInfo = dataFlowInfo.clearValueInfo(valueToClear);
        }
        DataFlowInfo dataFlowInfo2 = dataFlowInfo;
        if (dataFlowInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/PreliminaryLoopVisitor", "clearDataFlowInfoForAssignedLocalVariables"));
        }
        return dataFlowInfo2;
    }

    @Override
    public Void visitBinaryExpression(@NotNull JetBinaryExpression binaryExpression, Void arg) {
        JetExpression left;
        if (binaryExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/kotlin/types/expressions/PreliminaryLoopVisitor", "visitBinaryExpression"));
        }
        if (binaryExpression.getOperationToken() == JetTokens.EQ && (left = JetPsiUtil.deparenthesize(binaryExpression.getLeft())) instanceof JetNameReferenceExpression) {
            this.assignedNames.add(((JetNameReferenceExpression)left).getReferencedNameAsName());
        }
        return null;
    }
}

