/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jetbrains.kotlin.preloading.ClassHandler;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.preloading.instrumentation.Instrumenter;

public class Preloader {
    public static final int PRELOADER_ARG_COUNT = 4;
    private static final String INSTRUMENT_PREFIX = "instrument=";

    public static void main(String[] args) throws Exception {
        int classNumber;
        if (args.length < 4) {
            Preloader.printUsageAndExit();
        }
        List<File> files = Preloader.parseClassPath(args[0]);
        String mainClassCanonicalName = args[1];
        try {
            classNumber = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            System.out.println(e.getMessage());
            Preloader.printUsageAndExit();
            return;
        }
        String modeStr = args[3];
        final Mode mode = Preloader.parseMode(modeStr);
        URL[] instrumentersClasspath = Preloader.parseInstrumentersClasspath(mode, modeStr);
        final long startTime = System.nanoTime();
        ClassLoader parent = Preloader.class.getClassLoader();
        ClassLoader withInstrumenter = instrumentersClasspath.length > 0 ? new URLClassLoader(instrumentersClasspath, parent) : parent;
        final Handler handler = Preloader.getHandler(mode, withInstrumenter);
        ClassLoader preloaded = ClassPreloadingUtils.preloadClasses(files, classNumber, withInstrumenter, null, handler);
        Class<?> mainClass = preloaded.loadClass(mainClassCanonicalName);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (mode != Mode.NO_TIME) {
                    System.out.println();
                    System.out.println("=== Preloader's measurements: ");
                    long dt = System.nanoTime() - startTime;
                    System.out.format("Total time: %.3fs\n", (double)dt / 1.0E9);
                }
                handler.done();
            }
        }));
        mainMethod.invoke((Object)0, new Object[]{Arrays.copyOfRange(args, 4, args.length)});
    }

    private static URL[] parseInstrumentersClasspath(Mode mode, String modeStr) throws MalformedURLException {
        URL[] instrumentersClasspath;
        if (mode == Mode.INSTRUMENT) {
            List<File> instrumentersClassPathFiles = Preloader.parseClassPath(Preloader.getClassPath(modeStr));
            instrumentersClasspath = new URL[instrumentersClassPathFiles.size()];
            for (int i = 0; i < instrumentersClassPathFiles.size(); ++i) {
                File file = instrumentersClassPathFiles.get(i);
                instrumentersClasspath[i] = file.toURI().toURL();
            }
        } else {
            instrumentersClasspath = new URL[]{};
        }
        return instrumentersClasspath;
    }

    private static String getClassPath(String modeStr) {
        return modeStr.substring(INSTRUMENT_PREFIX.length());
    }

    private static List<File> parseClassPath(String classpath) {
        String[] paths = classpath.split("\\" + File.pathSeparator);
        ArrayList<File> files = new ArrayList<File>(paths.length);
        for (String path : paths) {
            File file = new File(path);
            if (!file.exists()) {
                System.out.println("File does not exist: " + file);
                Preloader.printUsageAndExit();
            }
            files.add(file);
        }
        return files;
    }

    private static Handler getHandler(Mode mode, ClassLoader withInstrumenter) {
        if (mode == Mode.NO_TIME) {
            return new Handler();
        }
        final Instrumenter instrumenter = mode == Mode.INSTRUMENT ? Preloader.loadInstrumenter(withInstrumenter) : Instrumenter.DO_NOTHING;
        final int[] counter = new int[1];
        final int[] size = new int[1];
        return new Handler(){

            @Override
            public void beforeDefineClass(String name, int sizeInBytes) {
                counter[0] = counter[0] + 1;
                size[0] = size[0] + sizeInBytes;
            }

            @Override
            public void done() {
                System.out.println();
                System.out.println("Loaded classes: " + counter[0]);
                System.out.println("Loaded classes size: " + size[0]);
                System.out.println();
                instrumenter.dump(System.out);
            }

            @Override
            public byte[] instrument(String resourceName, byte[] data) {
                return instrumenter.instrument(resourceName, data);
            }
        };
    }

    private static Instrumenter loadInstrumenter(ClassLoader withInstrumenter) {
        ServiceLoader<Instrumenter> loader = ServiceLoader.load(Instrumenter.class, withInstrumenter);
        Iterator<Instrumenter> instrumenters = loader.iterator();
        if (instrumenters.hasNext()) {
            Instrumenter instrumenter = instrumenters.next();
            if (instrumenters.hasNext()) {
                System.err.println("PRELOADER WARNING: Only the first instrumenter is used: " + instrumenter.getClass());
            }
            return instrumenter;
        }
        System.err.println("PRELOADER WARNING: No instrumenters found");
        return Instrumenter.DO_NOTHING;
    }

    private static Mode parseMode(String arg) {
        if ("time".equals(arg)) {
            return Mode.TIME;
        }
        if ("notime".equals(arg)) {
            return Mode.NO_TIME;
        }
        if (arg.startsWith(INSTRUMENT_PREFIX)) {
            return Mode.INSTRUMENT;
        }
        System.out.println("Unrecognized argument: " + arg);
        Preloader.printUsageAndExit();
        return Mode.NO_TIME;
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: Preloader <paths to jars> <main class> <class number estimate> <notime|time|instrument=<instrumenters class path>> <parameters to pass to the main class>");
        System.exit(1);
    }

    private static class Handler
    extends ClassHandler {
        private Handler() {
        }

        public void done() {
        }
    }

    private static enum Mode {
        NO_TIME,
        TIME,
        INSTRUMENT;

    }
}

