/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.testme.instrumentation;

public class InstrumentedMethodsFilter {
    private final String myClassName;
    private boolean myEnum;

    public InstrumentedMethodsFilter(String className) {
        this.myClassName = className;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myEnum = (access & 0x4000) != 0;
    }

    public boolean shouldVisitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 0x40) != 0) {
            return false;
        }
        if ((access & 0x400) != 0) {
            return false;
        }
        if ("<clinit>".equals(name) || (access & 0x1000) != 0 && name.startsWith("access$") || name.equals("<init>")) {
            return false;
        }
        return !this.myEnum || !InstrumentedMethodsFilter.isDefaultEnumMethod(name, desc, signature, this.myClassName);
    }

    private static boolean isDefaultEnumMethod(String name, String desc, String signature, String className) {
        return name.equals("values") && desc.equals("()[L" + className + ";") || name.equals("valueOf") && desc.equals("(Ljava/lang/String;)L" + className + ";") || name.equals("<init>") && signature != null && signature.equals("()V");
    }
}

