/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.testme.instrumentation;

import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.testme.instrumentation.InstrumentedMethodsFilter;

public class Instrumenter
extends ClassVisitor {
    protected final ClassVisitor myClassVisitor;
    private final String myClassName;
    private final String myInternalClassName;
    private final InstrumentedMethodsFilter myMethodFilter;
    private final String[] myMethodNames;
    private int myCurrentMethodCount;
    private boolean myVisitedStaticBlock;
    private static final String METHODS_VISITED = "__$methodsVisited$__";
    private static final String METHODS_VISITED_CLASS = "[Z";

    public Instrumenter(ClassVisitor classVisitor, String className, String[] methodNames) {
        super(327680, classVisitor);
        this.myClassVisitor = classVisitor;
        this.myMethodFilter = new InstrumentedMethodsFilter(className);
        this.myClassName = className.replace('$', '.');
        this.myInternalClassName = className.replace('.', '/');
        this.myMethodNames = methodNames;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myMethodFilter.visit(version, access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return mv;
        }
        if ("<clinit>".equals(name)) {
            this.myVisitedStaticBlock = true;
            return new StaticBlockMethodVisitor(mv);
        }
        if (!this.myMethodFilter.shouldVisitMethod(access, name, desc, signature, exceptions)) {
            return mv;
        }
        assert (this.myCurrentMethodCount < this.myMethodNames.length);
        return new MethodVisitor(327680, mv){
            final int myMethodId;
            {
                this.myMethodId = Instrumenter.this.myCurrentMethodCount++;
            }

            public void visitCode() {
                this.visitFieldInsn(178, Instrumenter.this.myInternalClassName, Instrumenter.METHODS_VISITED, Instrumenter.METHODS_VISITED_CLASS);
                Instrumenter.pushInstruction(this, this.myMethodId);
                this.visitInsn(4);
                this.visitInsn(84);
                super.visitCode();
            }
        };
    }

    public void visitEnd() {
        this.visitField(25, METHODS_VISITED, METHODS_VISITED_CLASS, null, null);
        if (!this.myVisitedStaticBlock) {
            MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
            mv = new StaticBlockMethodVisitor(mv);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(this.myMethodNames.length + 2, 1);
            mv.visitEnd();
        }
        super.visitEnd();
    }

    private static void pushInstruction(MethodVisitor mv, int operand) {
        if (operand < 127) {
            mv.visitIntInsn(16, operand);
        } else {
            mv.visitIntInsn(17, operand);
        }
    }

    private class StaticBlockMethodVisitor
    extends MethodVisitor {
        public StaticBlockMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
            super.visitCode();
            Instrumenter.pushInstruction(this, Instrumenter.this.myMethodNames.length);
            this.visitIntInsn(188, 4);
            this.visitFieldInsn(179, Instrumenter.this.myInternalClassName, Instrumenter.METHODS_VISITED, Instrumenter.METHODS_VISITED_CLASS);
            Instrumenter.pushInstruction(this, Instrumenter.this.myMethodNames.length);
            this.visitTypeInsn(189, "java/lang/String");
            for (int i = 0; i < Instrumenter.this.myMethodNames.length; ++i) {
                this.visitInsn(89);
                Instrumenter.pushInstruction(this, i);
                this.visitLdcInsn(Instrumenter.this.myMethodNames[i]);
                this.visitInsn(83);
            }
            this.visitVarInsn(58, 0);
            Label startLabel = new Label();
            this.visitLabel(startLabel);
            this.visitLdcInsn(Instrumenter.this.myClassName);
            this.visitFieldInsn(178, Instrumenter.this.myInternalClassName, Instrumenter.METHODS_VISITED, Instrumenter.METHODS_VISITED_CLASS);
            this.visitVarInsn(25, 0);
            this.visitMethodInsn(184, "org/jetbrains/testme/instrumentation/ProjectData", "trace", "(Ljava/lang/String;[Z[Ljava/lang/String;)V", false);
            Label endLabel = new Label();
            this.visitLabel(endLabel);
            this.visitLocalVariable("methodNames", "[Ljava/lang/String;", null, startLabel, endLabel, 0);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            int ourMaxStack = Instrumenter.this.myMethodNames.length + 2;
            boolean ourMaxLocals = true;
            super.visitMaxs(Math.max(ourMaxStack, maxStack), Math.max(1, maxLocals));
        }
    }
}

