/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.testme.instrumentation;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.testme.instrumentation.TestDiscoveryInstrumentator;

public class ProjectData {
    public static final String PROJECT_DATA_OWNER = "org/jetbrains/testme/instrumentation/ProjectData";
    public static final String TRACE_DIR = "org.jetbrains.testme.instrumentation.trace.dir";
    protected static final ProjectData ourData = new ProjectData();
    private String myTraceDir = System.getProperty("org.jetbrains.testme.instrumentation.trace.dir", "");
    private ConcurrentMap<String, Set<String>> myTrace;
    private final ConcurrentMap<String, boolean[]> myTrace2 = new ConcurrentHashMap<String, boolean[]>();
    private final ConcurrentMap<String, String[]> myTrace3 = new ConcurrentHashMap<String, String[]>();
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final int STRING_HEADER_SIZE = 1;
    private static volatile boolean traceDirDumped;

    public void setTraceDir(String traceDir) {
        this.myTraceDir = traceDir;
    }

    public static ProjectData getProjectData() {
        return ourData;
    }

    public static void trace(String className, String methodSignature) {
        ourData.traceLines(className, methodSignature);
    }

    public static void trace(String className, boolean[] methodFlags, String[] methodNames) {
        ourData.traceLines(className, methodFlags, methodNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceLines(String className, String methodSignature) {
        if (this.myTrace != null) {
            Set previousMethods;
            Set<String> methods = (HashSet<String>)this.myTrace.get(className);
            if (methods == null && (previousMethods = (Set)this.myTrace.putIfAbsent(className, methods = new HashSet<String>())) != null) {
                methods = previousMethods;
            }
            HashSet<String> hashSet = methods;
            synchronized (hashSet) {
                methods.add(methodSignature);
            }
        }
    }

    public synchronized void traceLines(String className, boolean[] methodFlags, String[] methodNames) {
        assert (methodFlags.length == methodNames.length);
        this.myTrace2.put(className, methodFlags);
        this.myTrace3.put(className, methodNames);
    }

    private static void writeUTF(DataOutput storage, byte[] buffer, String value) throws IOException {
        int len = value.length();
        if (len < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        storage.writeUTF(value);
    }

    private static void writeINT(DataOutput record, int val) throws IOException {
        if (0 <= val && val < 192) {
            record.writeByte(val);
        } else {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
            record.writeByte(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void testEnded(String name) {
        if (!traceDirDumped) {
            ClassLoader classLoader = TestDiscoveryInstrumentator.class.getClassLoader();
            System.out.println(ourData + "; cl: " + classLoader + "," + classLoader.getParent());
            System.out.println("Trace dir:" + this.myTraceDir);
            traceDirDumped = true;
        }
        new File(this.myTraceDir).mkdirs();
        File traceFile = new File(this.myTraceDir, name + ".tr");
        try {
            if (!traceFile.exists()) {
                traceFile.createNewFile();
            }
            FilterOutputStream os = null;
            try {
                boolean[] used;
                os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(traceFile), 65536));
                byte[] buffer = new byte[256];
                HashMap classToUsedMethods = new HashMap();
                for (Map.Entry e : this.myTrace2.entrySet()) {
                    used = (boolean[])e.getValue();
                    int usedMethodsCount = 0;
                    for (boolean anUsed : used) {
                        if (!anUsed) continue;
                        ++usedMethodsCount;
                    }
                    if (usedMethodsCount <= 0) continue;
                    classToUsedMethods.put(e.getKey(), usedMethodsCount);
                }
                ProjectData.writeINT((DataOutput)((Object)os), classToUsedMethods.size());
                for (Map.Entry e : this.myTrace2.entrySet()) {
                    used = (boolean[])e.getValue();
                    String className = (String)e.getKey();
                    Integer integer = (Integer)classToUsedMethods.get(className);
                    if (integer == null) continue;
                    int usedMethodsCount = integer;
                    ProjectData.writeUTF((DataOutput)((Object)os), buffer, className);
                    ProjectData.writeINT((DataOutput)((Object)os), usedMethodsCount);
                    String[] methodNames = (String[])this.myTrace3.get(className);
                    int len = used.length;
                    for (int i = 0; i < len; ++i) {
                        if (!used[i] || usedMethodsCount-- <= 0) continue;
                        ProjectData.writeUTF((DataOutput)((Object)os), buffer, methodNames[i]);
                    }
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.myTrace = null;
        }
    }

    private void saveOldTrace(DataOutputStream os) throws IOException {
        os.writeInt(this.myTrace.size());
        for (String classData : this.myTrace.keySet()) {
            os.writeUTF(classData);
            Set methods = (Set)this.myTrace.get(classData);
            os.writeInt(methods.size());
            Iterator iterator = methods.iterator();
            while (iterator.hasNext()) {
                os.writeUTF((String)iterator.next());
            }
        }
    }

    public synchronized void testStarted(String name) {
        for (Map.Entry e : this.myTrace2.entrySet()) {
            boolean[] used = (boolean[])e.getValue();
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i]) continue;
                used[i] = false;
            }
        }
    }

    private void clearOldTrace() {
        this.myTrace = new ConcurrentHashMap<String, Set<String>>();
    }
}

