/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.sources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.prefs.AndroidLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;

public class SdkSourceProperties {
    private static final String KEY_VERSION = "@version@";
    public static final String KEY_NAME = "@name@";
    public static final String KEY_DISABLED = "@disabled@";
    private static final Properties sSourcesProperties = new Properties();
    private static final String SRC_FILENAME = "sites-settings.cfg";
    private static boolean sModified = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            if (sModified && !sSourcesProperties.isEmpty()) {
                this.saveLocked();
                sModified = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getProperty(@NonNull String key, @NonNull String sourceUrl, @Nullable String defaultValue) {
        String value = defaultValue;
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            if (sSourcesProperties.isEmpty()) {
                this.loadLocked();
            }
            value = sSourcesProperties.getProperty(key + sourceUrl, defaultValue);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String key, String sourceUrl, String value) {
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            if (sSourcesProperties.isEmpty()) {
                this.loadLocked();
            }
            key = key + sourceUrl;
            String old = sSourcesProperties.getProperty(key);
            if (value == null) {
                if (old != null) {
                    sSourcesProperties.remove(key);
                    sModified = true;
                }
            } else if (old == null || !old.equals(value)) {
                sSourcesProperties.setProperty(key, value);
                sModified = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("<SdkSourceProperties");
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            ArrayList<Object> keys = Collections.list(sSourcesProperties.keys());
            Collections.sort(keys, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            for (Object e : keys) {
                sb.append('\n').append(e).append(" = ").append(sSourcesProperties.get(e));
            }
        }
        sb.append('>');
        return sb.toString();
    }

    private void loadLocked() {
        if (this.loadProperties()) {
            if (sSourcesProperties.getProperty(KEY_VERSION) == null) {
                sSourcesProperties.clear();
            }
            sModified = false;
        }
        if (sSourcesProperties.isEmpty()) {
            sSourcesProperties.setProperty(KEY_VERSION, "1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadProperties() {
        block14: {
            try {
                String folder = AndroidLocation.getFolder();
                File f = new File(folder, SRC_FILENAME);
                if (!f.exists()) break block14;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(f);
                    sSourcesProperties.load(fis);
                }
                catch (IOException iOException) {
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return true;
            }
            catch (AndroidLocation.AndroidLocationException androidLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveLocked() {
        FileOutputStream fos = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SRC_FILENAME);
            fos = new FileOutputStream(f);
            sSourcesProperties.store(fos, "## Sites Settings for Android SDK Manager");
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Properties properties = sSourcesProperties;
        synchronized (properties) {
            sSourcesProperties.clear();
            sModified = false;
        }
    }
}

