/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LexerBasedTokensCache;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.MyBuilder;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.TokensCache;
import org.jetbrains.annotations.NotNull;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"q\u0004)qQ*\u0019:lI><h\u000eU1sg\u0016\u0014(bA8sO*A\u0011N\u001c;fY2L'N\u0003\u0005nCJ\\Gm\\<o\u0015\u0019\u0001\u0018M]:fe*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0019a\u0014N\\5u})1R.\u0019:lKJ\u0004&o\\2fgN|'OR1di>\u0014\u0018P\u0003\fNCJ\\WM\u001d)s_\u000e,7o]8s\r\u0006\u001cGo\u001c:z\u0015m\u0011W/\u001b7e\u001b\u0006\u00148\u000eZ8x]R\u0013X-\u001a$s_6\u001cFO]5oO*!A/\u001a=u\u0015\u0019\u0019FO]5oO*9\u0011i\u0015+O_\u0012,'bA1ti*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u000bA\f'o]3\u000b\tI|w\u000e\u001e\u0006\r\u0013\u0016cW-\\3oiRK\b/\u001a\u0006\fi>\\WM\\:DC\u000eDWMC\u0006U_.,gn]\"bG\",\u00071\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0019\u0001#\u0003\u0006\u0007\u0011\u0015\u0001B\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0004\u0006\u0007\u0011)\u0001R\u0002\u0007\u0001\u000b\t!Q\u0001#\u0004\u0006\u0003!=QA\u0001C\u0007\u0011!)!\u0001B\u0004\t\r\u0015\u0019A!\u0001E\n\u0019\u0001)1\u0001b\u0001\t\u00161\u0001QA\u0001\u0003\u0002\u0011')!\u0001b\u0001\t\u0016\u0011\u0019ABA\r\u0003\u000b\u0005A1!L\u0006\u0005C\u0012AB!\t\u0002\u0006\u0003!\u001dQk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001\u0005\u0005[M!1\u0001G\u0003\u001e\u000e\u0011\u0001\u00012B\u0007\u0003\u000b\u0005AI\u0001U\u0002\u0001C\t)\u0011\u0001c\u0003R\u0007\u0015!Q!C\u0001\t\r5\t\u0001rBW\u001d\t\rA\n\"(\u0004\u0005\u0001!IQBA\u0003\u0002\u0011!\u00016\u0001AO\u0007\t\u0001A!\"\u0004\u0002\u0006\u0003!E\u0001k!\u0001\"\u0005\u0015\t\u00012B)\u0004\u000f\u0011E\u0011\"\u0001\u0005\u0007\u001b\u0005A\u0011\"D\u0001\t\u0014U&Rq\u0005\u0003d\u0002a\u001dQT\u0002\u0003\u0001\u0011\u0011i!!B\u0001\t\bA\u001b\u0001!\t\u0002\u0006\u0003!\u0011\u0011kA\u0003\u0005\b%\tA\u0001A\u0007\u0002\u0011\u0011\u0001"})
public final class MarkdownParser {
    public static final /* synthetic */ KClass $kotlinClass;
    private final MarkerProcessorFactory markerProcessorFactory;

    static {
        $kotlinClass = Reflection.createKotlinClass(MarkdownParser.class);
    }

    @NotNull
    public final ASTNode buildMarkdownTreeFromString(@JetValueParameter(name="text") @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        LexerBasedTokensCache cache = new LexerBasedTokensCache(new MarkdownLexer(text));
        return this.parse(MarkdownElementTypes.Companion.getMARKDOWN_FILE(), cache);
    }

    @NotNull
    public final ASTNode parse(@JetValueParameter(name="root") @NotNull IElementType root, @JetValueParameter(name="tokensCache") @NotNull TokensCache tokensCache) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)tokensCache, (String)"tokensCache");
        ProductionHolder productionHolder = new ProductionHolder();
        MarkerProcessor markerProcessor = this.markerProcessorFactory.createMarkerProcessor(productionHolder, tokensCache);
        ProductionHolder.Marker rootMarker = productionHolder.mark();
        TokensCache.Iterator iterator = new TokensCache.Iterator(tokensCache, 0);
        productionHolder.updatePosition(iterator.getIndex());
        while (iterator.getType() != null) {
            IElementType tokenType;
            if (iterator.getType() == null) {
                Intrinsics.throwNpe();
            }
            iterator = markerProcessor.processToken(tokenType, iterator);
            iterator = iterator.advance();
            productionHolder.updatePosition(iterator.getIndex());
        }
        markerProcessor.flushMarkers();
        rootMarker.done(root);
        MyBuilder builder = new MyBuilder();
        return builder.buildTree(productionHolder.getProduction(), tokensCache);
    }

    public MarkdownParser(@JetValueParameter(name="markerProcessorFactory") @NotNull MarkerProcessorFactory markerProcessorFactory) {
        Intrinsics.checkParameterIsNotNull((Object)markerProcessorFactory, (String)"markerProcessorFactory");
        this.markerProcessorFactory = markerProcessorFactory;
    }
}

