/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation;

import com.android.tools.idea.actions.AndroidShowNavigationEditor;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.Event;
import com.android.tools.idea.editors.navigation.EventDispatcher;
import com.android.tools.idea.editors.navigation.Inspector;
import com.android.tools.idea.editors.navigation.Listener;
import com.android.tools.idea.editors.navigation.NavigationView;
import com.android.tools.idea.editors.navigation.RenderingParameters;
import com.android.tools.idea.editors.navigation.SelectionModel;
import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.Analyser;
import com.android.tools.idea.editors.navigation.macros.CodeGenerator;
import com.android.tools.idea.editors.navigation.model.Locator;
import com.android.tools.idea.editors.navigation.model.ModelDimension;
import com.android.tools.idea.editors.navigation.model.ModelPoint;
import com.android.tools.idea.editors.navigation.model.NavigationModel;
import com.android.tools.idea.editors.navigation.model.State;
import com.android.tools.idea.editors.navigation.model.Transition;
import com.android.tools.idea.editors.navigation.model.XMLReader;
import com.android.tools.idea.editors.navigation.model.XMLWriter;
import com.android.tools.idea.rendering.ModuleResourceRepository;
import com.intellij.AppTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationEditor
implements FileEditor {
    public static final String NAVIGATION_DIRECTORY = ".navigation";
    public static final String DEFAULT_RESOURCE_FOLDER = "raw";
    public static final String LAYOUT_DIR_NAME = "layout";
    public static final String NAVIGATION_FILE_NAME = "main.nvg.xml";
    private static final String TOOLBAR = "NavigationEditorToolbar";
    private static final Logger LOG = Logger.getInstance((String)NavigationEditor.class.getName());
    private static final boolean DEBUG = false;
    private static final String NAME = "Navigation";
    private static final int INITIAL_FILE_BUFFER_SIZE = 1000;
    private static final int SCROLL_UNIT_INCREMENT = 20;
    public static final Event PROJECT_READ = new Event(Event.Operation.UPDATE, Object.class);
    private static final ModelDimension UNATTACHED_STRIDE = new ModelDimension(50, 50);
    private static final boolean RUN_ANALYSIS_ON_BACKGROUND_THREAD = false;
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private RenderingParameters myRenderingParams;
    private NavigationModel myNavigationModel;
    private final VirtualFile myFile;
    private JComponent myComponent;
    private boolean myModified;
    private boolean myPendingFileSystemChanges;
    private Analyser myAnalyser;
    private Listener<Event> myNavigationModelListener;
    private ResourceFolderManager.ResourceFolderListener myResourceFolderListener;
    private VirtualFileAdapter myVirtualFileListener;
    private FileDocumentManagerListener mySaveListener;
    private static final String[] EXCLUDED_PATH_SEGMENTS = new String[]{"/.idea/", "/idea/config/options/"};

    @Nullable
    private static VirtualFile findLayoutFile(List<VirtualFile> resourceDirectories, String navigationDirectoryName) {
        String qualifier = NavigationEditor.removePrefixIfPresent(DEFAULT_RESOURCE_FOLDER, navigationDirectoryName);
        String layoutDirName = LAYOUT_DIR_NAME + qualifier;
        for (VirtualFile root : resourceDirectories) {
            for (VirtualFile dir : root.getChildren()) {
                if (!dir.isDirectory() || !dir.getName().equals(layoutDirName)) continue;
                for (VirtualFile file : dir.getChildren()) {
                    String fileName = file.getName();
                    if (fileName.startsWith(".") || !fileName.endsWith(".xml")) continue;
                    return file;
                }
            }
        }
        return null;
    }

    @Nullable
    public static RenderingParameters getRenderingParams(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/navigation/NavigationEditor", "getRenderingParams"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/navigation/NavigationEditor", "getRenderingParams"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        List<VirtualFile> resourceDirectories = facet.getAllResourceDirectories();
        VirtualFile layoutFile = NavigationEditor.findLayoutFile(resourceDirectories, file.getParent().getName());
        if (layoutFile == null) {
            return null;
        }
        Configuration configuration = facet.getConfigurationManager().getConfiguration(layoutFile);
        return new RenderingParameters(facet, configuration);
    }

    public NavigationEditor(Project project, VirtualFile file) {
        this.myFile = file;
        Module[] androidModules = Utilities.getAndroidModules(project);
        String moduleName = file.getParent().getParent().getName();
        Module module = Utilities.findModule(androidModules, moduleName);
        if (module == null) {
            String errorMessage = NAVIGATION_DIRECTORY.equals(moduleName) ? "Legacy navigation editor file: please remove the file and/or close this editor" : "Android module \"" + moduleName + "\" not found";
            this.myComponent = NavigationEditor.createErrorComponent("", errorMessage);
            return;
        }
        RenderingParameters renderingParams = NavigationEditor.getRenderingParams(file, module);
        if (renderingParams == null) {
            this.myComponent = NavigationEditor.createErrorComponent("", "Invalid file name: please remove the file and/or close this editor");
            return;
        }
        this.myRenderingParams = renderingParams;
        this.myAnalyser = new Analyser(module);
        this.myNavigationModel = NavigationEditor.read(file);
        CodeGenerator codeGenerator = new CodeGenerator(this.myNavigationModel, module, new Listener<String>(){

            @Override
            public void notify(@NotNull String event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/navigation/NavigationEditor$1", "notify"));
                }
                NavigationEditor.this.postDelayedRefresh();
            }
        });
        this.myComponent = NavigationEditor.createUI(renderingParams, this.myNavigationModel, codeGenerator, this.myFile.getParent().getName());
        this.createListeners();
        project.getMessageBus().connect((Disposable)this).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)this.mySaveListener);
    }

    @NotNull
    private static JPanel createUI(RenderingParameters renderingParams, NavigationModel navigationModel, CodeGenerator codeGenerator, String dirName) {
        SelectionModel selectionModel = new SelectionModel();
        NavigationView editor = new NavigationView(renderingParams, navigationModel, selectionModel, codeGenerator);
        JPanel panel = new JPanel(new BorderLayout());
        JComponent toolBar = NavigationEditor.createToolbar(NavigationEditor.getActions(editor), renderingParams, dirName);
        panel.add((Component)toolBar, "North");
        Splitter splitPane = new Splitter();
        splitPane.setDividerWidth(1);
        splitPane.setShowDividerIcon(false);
        splitPane.setProportion(0.8f);
        JBScrollPane scrollPane = new JBScrollPane((Component)editor);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        splitPane.setFirstComponent((JComponent)scrollPane);
        Inspector inspector = new Inspector(selectionModel);
        splitPane.setSecondComponent((JComponent)new JBScrollPane((Component)inspector.container));
        panel.add((Component)splitPane);
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditor", "createUI"));
        }
        return jPanel;
    }

    private void createListeners() {
        this.myNavigationModelListener = new Listener<Event>(){

            @Override
            public void notify(@NotNull Event event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/navigation/NavigationEditor$2", "notify"));
                }
                if (event != PROJECT_READ) {
                    NavigationEditor.this.myModified = true;
                }
            }
        };
        this.mySaveListener = new FileDocumentManagerAdapter(){

            public void beforeAllDocumentsSaving() {
                try {
                    NavigationEditor.this.saveFile();
                }
                catch (IOException e) {
                    LOG.error("Unexpected exception while saving navigation file", (Throwable)e);
                }
            }
        };
        this.myVirtualFileListener = new VirtualFileAdapter(){

            private void somethingChanged(String changeType, @NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "somethingChanged"));
                }
                if (!NavigationEditor.shouldIgnore(event)) {
                    NavigationEditor.this.postDelayedRefresh();
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "contentsChanged"));
                }
                this.somethingChanged("contentsChanged", event);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "fileCreated"));
                }
                this.somethingChanged("fileCreated", event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/navigation/NavigationEditor$4", "fileDeleted"));
                }
                this.somethingChanged("fileDeleted", event);
            }
        };
        this.myResourceFolderListener = new ResourceFolderManager.ResourceFolderListener(){

            @Override
            public void resourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<VirtualFile> folders, @NotNull Collection<VirtualFile> added, @NotNull Collection<VirtualFile> removed) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/navigation/NavigationEditor$5", "resourceFoldersChanged"));
                }
                if (folders == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folders", "com/android/tools/idea/editors/navigation/NavigationEditor$5", "resourceFoldersChanged"));
                }
                if (added == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "added", "com/android/tools/idea/editors/navigation/NavigationEditor$5", "resourceFoldersChanged"));
                }
                if (removed == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removed", "com/android/tools/idea/editors/navigation/NavigationEditor$5", "resourceFoldersChanged"));
                }
                NavigationEditor.this.postDelayedRefresh();
            }
        };
    }

    private static boolean shouldIgnore(VirtualFileEvent event) {
        String fileName = event.getFileName();
        if (NAVIGATION_FILE_NAME.equals(fileName)) {
            return true;
        }
        String pathName = event.getFile().getCanonicalPath();
        if (pathName == null) {
            return false;
        }
        for (String segment : EXCLUDED_PATH_SEGMENTS) {
            if (!pathName.contains(segment)) continue;
            return true;
        }
        return false;
    }

    private static JComponent createErrorComponent(String title, String errorMessage) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(title);
        label.setFont(label.getFont().deriveFont(30.0f));
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "North");
        label = new JLabel(errorMessage);
        label.setFont(label.getFont().deriveFont(20.0f));
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "Center");
        return new JBScrollPane((Component)panel);
    }

    private static ResourceFolderManager getResourceFolderManager(AndroidFacet facet) {
        ModuleResourceRepository.getModuleResources(facet, true);
        return facet.getResourceFolderManager();
    }

    private void postDelayedRefresh() {
        if (!this.myPendingFileSystemChanges) {
            this.myPendingFileSystemChanges = true;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigationEditor.this.myPendingFileSystemChanges = false;
                    long l = System.currentTimeMillis();
                    NavigationEditor.this.updateNavigationModelFromProject();
                }
            });
        }
    }

    private static String[] getModuleNames(Module[] modules) {
        String[] result = new String[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            result[i] = modules[i].getName();
        }
        return result;
    }

    private static String removePrefixIfPresent(String prefix, String s) {
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    private static String[] resourceDirectoryNames(AndroidFacet facet, String type) {
        List<VirtualFile> resourceDirectories = facet.getAllResourceDirectories();
        ArrayList<String> qualifiers = new ArrayList<String>();
        for (VirtualFile root : resourceDirectories) {
            for (VirtualFile dir : root.getChildren()) {
                String name = dir.getName();
                if (!name.startsWith(type) || !dir.isDirectory() || dir.getChildren().length == 0) continue;
                qualifiers.add(name);
            }
        }
        return ArrayUtil.toStringArray(qualifiers);
    }

    private static String[] getDisplayNames(String[] dirNames) {
        return Utilities.map(dirNames, new Function<String, String>(){

            public String fun(String s) {
                return NavigationEditor.DEFAULT_RESOURCE_FOLDER + s.substring(NavigationEditor.LAYOUT_DIR_NAME.length());
            }
        });
    }

    private static JComponent createToolbar(ActionGroup actions, final RenderingParameters renderingParams, String dirName) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(IdeBorderFactory.createBorder((int)8));
        final Module module = renderingParams.facet.getModule();
        JPanel combos = new JPanel(new FlowLayout());
        final Module[] androidModules = Utilities.getAndroidModules(renderingParams.project);
        if (androidModules.length > 1) {
            final ComboBox moduleSelector = new ComboBox((Object[])NavigationEditor.getModuleNames(androidModules));
            final String originalSelection = module.getName();
            moduleSelector.setSelectedItem((Object)originalSelection);
            moduleSelector.addActionListener(new ActionListener(){
                boolean disabled = false;

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.disabled) {
                        return;
                    }
                    int selectedIndex = moduleSelector.getSelectedIndex();
                    Module newModule = androidModules[selectedIndex];
                    AndroidShowNavigationEditor newEditor = new AndroidShowNavigationEditor();
                    newEditor.showNavigationEditor(renderingParams.project, newModule, NavigationEditor.DEFAULT_RESOURCE_FOLDER, NavigationEditor.NAVIGATION_FILE_NAME);
                    this.disabled = true;
                    moduleSelector.setSelectedItem((Object)originalSelection);
                    this.disabled = false;
                }
            });
            combos.add((Component)moduleSelector);
        }
        String[] dirNames = NavigationEditor.resourceDirectoryNames(renderingParams.facet, LAYOUT_DIR_NAME);
        Object[] navDirNames = NavigationEditor.getDisplayNames(dirNames);
        if (dirNames.length > 1) {
            final ComboBox deviceSelector = new ComboBox(navDirNames);
            final String originalSelection = dirName;
            deviceSelector.setSelectedItem((Object)originalSelection);
            deviceSelector.addActionListener(new ActionListener(){
                boolean disabled = false;

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.disabled) {
                        return;
                    }
                    String dirName = (String)deviceSelector.getSelectedItem();
                    AndroidShowNavigationEditor newEditor = new AndroidShowNavigationEditor();
                    newEditor.showNavigationEditor(renderingParams.project, module, dirName, NavigationEditor.NAVIGATION_FILE_NAME);
                    this.disabled = true;
                    deviceSelector.setSelectedItem((Object)originalSelection);
                    this.disabled = false;
                }
            });
            combos.add((Component)deviceSelector);
        }
        panel.add((Component)combos, "Center");
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar zoomToolBar = actionManager.createActionToolbar(TOOLBAR, actions, true);
        panel.add((Component)zoomToolBar.getComponent(), "East");
        HyperlinkLabel label = new HyperlinkLabel();
        label.setHyperlinkTarget("http://tools.android.com/navigation-editor");
        label.setHyperlinkText("   ", "What's this?", "");
        panel.add((Component)label, "West");
        return panel;
    }

    private static ActionGroup getActions(final NavigationView myDesigner) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(null, "Zoom Out (-)", AndroidIcons.ZoomOut){

            public void actionPerformed(AnActionEvent e) {
                myDesigner.zoom(-1);
            }
        });
        group.add(new AnAction(null, "Fit to screen", AndroidIcons.ZoomActual){

            public void actionPerformed(AnActionEvent e) {
                Dimension pref = myDesigner.getPreferredSize();
                Container parent = myDesigner.getParent();
                float ratio = Math.max((float)pref.width / (float)parent.getWidth(), (float)pref.height / (float)parent.getHeight());
                double power = Math.log(1.0f / ratio) / Math.log(1.1f);
                myDesigner.zoom((int)Math.floor(power));
            }
        });
        group.add(new AnAction(null, "Zoom In (+)", AndroidIcons.ZoomIn){

            public void actionPerformed(AnActionEvent e) {
                myDesigner.zoom(1);
            }
        });
        return group;
    }

    private static NavigationModel read(VirtualFile file) {
        try {
            InputStream inputStream = file.getInputStream();
            if (inputStream.available() == 0) {
                return new NavigationModel();
            }
            return (NavigationModel)new XMLReader(inputStream).read();
        }
        catch (Exception e) {
            return new NavigationModel();
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditor", "getComponent"));
        }
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditor", "getName"));
        }
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/navigation/NavigationEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/navigation/NavigationEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/navigation/NavigationEditor", "setState"));
        }
    }

    public boolean isModified() {
        return this.myModified;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    private static void modifyCount(Map<State, Integer> m, Locator l, int delta) {
        State s = l.getState();
        m.put(s, m.get(s) + delta);
    }

    private static List<State> getStatesInOrder(NavigationModel navigationModel) {
        ArrayList<State> states = navigationModel.getStates();
        final HashMap<State, Integer> ioCounts = new HashMap<State, Integer>();
        for (State s : states) {
            ioCounts.put(s, 0);
        }
        for (Transition t : navigationModel.getTransitions()) {
            NavigationEditor.modifyCount(ioCounts, t.getSource(), -1);
            NavigationEditor.modifyCount(ioCounts, t.getDestination(), 1);
        }
        Collections.sort(states, new Comparator<State>(){

            @Override
            public int compare(State s1, State s2) {
                return (Integer)ioCounts.get(s1) - (Integer)ioCounts.get(s2);
            }
        });
        return states;
    }

    private static void layoutStatesWithUnsetLocations(final NavigationModel navigationModel, ModelDimension size) {
        List<State> states = NavigationEditor.getStatesInOrder(navigationModel);
        final Map<State, ModelPoint> stateToLocation = navigationModel.getStateToLocation();
        final HashSet<State> visited = new HashSet<State>();
        ModelDimension gridSize = new ModelDimension(size.width + NavigationView.GAP.width, size.height + NavigationView.GAP.height);
        final Point location = new Point(NavigationView.GAP.width, NavigationView.GAP.height);
        final int gridWidth = gridSize.width;
        final int gridHeight = gridSize.height;
        Set<State> transitionStates = NavigationEditor.getTransitionStates(navigationModel);
        Collection<State> unattached = NavigationEditor.getNonTransitionStates(states, transitionStates);
        visited.addAll(unattached);
        for (State state : states) {
            new Object(){

                public void addChildrenFor(State source) {
                    if (visited.contains(source)) {
                        return;
                    }
                    visited.add(source);
                    if (!stateToLocation.containsKey(source)) {
                        stateToLocation.put(source, new ModelPoint(location.x, location.y));
                    }
                    List<State> children = navigationModel.findDestinationsFor(source);
                    children.removeAll(visited);
                    location.x += gridWidth;
                    if (children.isEmpty()) {
                        location.y += gridHeight;
                    } else {
                        for (State child : children) {
                            this.addChildrenFor(child);
                        }
                    }
                    location.x -= gridWidth;
                }
            }.addChildrenFor(state);
        }
        for (State root : unattached) {
            if (stateToLocation.containsKey(root)) continue;
            stateToLocation.put(root, new ModelPoint(location.x, location.y));
            location.x += NavigationEditor.UNATTACHED_STRIDE.width;
            location.y += NavigationEditor.UNATTACHED_STRIDE.height;
        }
    }

    private static Set<State> getTransitionStates(NavigationModel navigationModel) {
        HashSet<State> result = new HashSet<State>();
        for (Transition transition : navigationModel.getTransitions()) {
            State source = transition.getSource().getState();
            State destination = transition.getDestination().getState();
            result.add(source);
            result.add(destination);
        }
        return result;
    }

    private static Collection<State> getNonTransitionStates(Collection<State> states, Set<State> transitionStates) {
        ArrayList<State> unattached = new ArrayList<State>(states);
        unattached.removeAll(transitionStates);
        return unattached;
    }

    private static void conditionallyExecuteOnBackgroundThread(Runnable action) {
        action.run();
    }

    private void updateNavigationModelFromProject() {
        final Application app = ApplicationManager.getApplication();
        NavigationEditor.conditionallyExecuteOnBackgroundThread(new Runnable(){

            @Override
            public void run() {
                app.runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (NavigationEditor.this.myRenderingParams == null || ((NavigationEditor)NavigationEditor.this).myRenderingParams.project.isDisposed()) {
                            return;
                        }
                        final NavigationModel newModel = NavigationEditor.this.myAnalyser.getNavigationModel(((NavigationEditor)NavigationEditor.this).myRenderingParams.configuration);
                        app.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EventDispatcher<Event> listeners = NavigationEditor.this.myNavigationModel.getListeners();
                                NavigationEditor.this.myNavigationModel.clear();
                                NavigationEditor.this.myNavigationModel.copyAllStatesAndTransitionsFrom(newModel);
                                NavigationEditor.layoutStatesWithUnsetLocations(NavigationEditor.this.myNavigationModel, NavigationEditor.this.myRenderingParams.getDeviceScreenSize());
                                NavigationEditor.this.myModified = false;
                                listeners.notify(PROJECT_READ);
                            }
                        });
                    }
                });
            }
        });
    }

    public void selectNotify() {
        if (this.myRenderingParams != null) {
            AndroidFacet facet = this.myRenderingParams.facet;
            this.postDelayedRefresh();
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
            NavigationEditor.getResourceFolderManager(facet).addListener(this.myResourceFolderListener);
            this.myNavigationModel.getListeners().add(this.myNavigationModelListener);
        }
    }

    public void deselectNotify() {
        if (this.myRenderingParams != null) {
            AndroidFacet facet = this.myRenderingParams.facet;
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
            NavigationEditor.getResourceFolderManager(facet).removeListener(this.myResourceFolderListener);
            this.myNavigationModel.getListeners().remove(this.myNavigationModelListener);
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/navigation/NavigationEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/navigation/NavigationEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    private void saveFile() throws IOException {
        if (this.myModified && this.myFile.isWritable()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1000);
            new XMLWriter(stream).write(this.myNavigationModel);
            this.myFile.setBinaryContent(stream.toByteArray());
            this.myModified = false;
        }
    }

    public void dispose() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    NavigationEditor.this.saveFile();
                }
                catch (IOException e) {
                    LOG.error("Unexpected exception while saving navigation file", (Throwable)e);
                }
            }
        });
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/navigation/NavigationEditor", "getUserData"));
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/navigation/NavigationEditor", "putUserData"));
        }
        this.myUserDataHolder.putUserData(key, value);
    }
}

