/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.compiler;

import com.android.ide.common.blame.output.GradleMessage;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.AndroidGradleNotification;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleBuildListener;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class PostProjectBuildTasksExecutor {
    public static final Topic<GradleBuildListener> GRADLE_BUILD_TOPIC = new Topic("Gradle project build", GradleBuildListener.class);
    private static final Key<Boolean> UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD = Key.create((String)"android.gradle.project.update.java.lang");
    private static final Key<Long> PROJECT_LAST_BUILD_TIMESTAMP_KEY = Key.create((String)"android.gradle.project.last.build.timestamp");
    @NotNull
    private final Project myProject;

    @NotNull
    public static PostProjectBuildTasksExecutor getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "getInstance"));
        }
        PostProjectBuildTasksExecutor postProjectBuildTasksExecutor = (PostProjectBuildTasksExecutor)ServiceManager.getService((Project)project, PostProjectBuildTasksExecutor.class);
        if (postProjectBuildTasksExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "getInstance"));
        }
        return postProjectBuildTasksExecutor;
    }

    public PostProjectBuildTasksExecutor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "<init>"));
        }
        this.myProject = project;
    }

    public void onBuildCompletion(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "onBuildCompletion"));
        }
        Object errors = Iterators.emptyIterator();
        CompilerMessage[] errorMessages = context.getMessages(CompilerMessageCategory.ERROR);
        if (errorMessages.length > 0) {
            errors = new CompilerMessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors, errorMessages.length);
    }

    public long getLastBuildTimestamp() {
        Long timestamp = (Long)this.myProject.getUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY);
        return timestamp != null ? timestamp : -1L;
    }

    public void onBuildCompletion(@NotNull GradleInvocationResult result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "onBuildCompletion"));
        }
        Object errors = Iterators.emptyIterator();
        List<GradleMessage> errorMessages = result.getCompilerMessages(GradleMessage.Kind.ERROR);
        if (!errorMessages.isEmpty()) {
            errors = new GradleMessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors, errorMessages.size());
    }

    @VisibleForTesting
    void onBuildCompletion(Iterator<String> errorMessages, int errorCount) {
        if (Projects.isGradleProject(this.myProject)) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PostProjectBuildTasksExecutor.this.excludeOutputFolders();
                        }
                    });
                }
            }, ModalityState.defaultModalityState());
            if (Projects.isOfflineBuildModeEnabled(this.myProject)) {
                while (errorMessages.hasNext()) {
                    String error = errorMessages.next();
                    if (error == null || !PostProjectBuildTasksExecutor.unresolvedDependenciesFound(error)) continue;
                    this.notifyUnresolvedDependenciesInOfflineMode();
                    break;
                }
            }
            this.refreshProject();
            BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
            BuildMode buildMode = buildSettings.getBuildMode();
            buildSettings.removeAll();
            this.myProject.putUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            this.notifyBuildFinished(buildMode);
            this.syncJavaLangLevel();
            if (BuildMode.DEFAULT_BUILD_MODE.equals((Object)buildMode) && Projects.lastGradleSyncFailed(this.myProject) && errorCount == 0 || !BuildMode.SOURCE_GEN.equals((Object)buildMode) && GradleSyncState.getInstance(this.myProject).isSyncNeeded().equals((Object)ThreeState.YES)) {
                GradleProjectImporter.getInstance().requestProjectSync(this.myProject, false, null);
            }
        }
    }

    private void excludeOutputFolders() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        if (this.myProject.isDisposed()) {
            return;
        }
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.isGradleProject()) continue;
            PostProjectBuildTasksExecutor.excludeOutputFolders(facet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void excludeOutputFolders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "excludeOutputFolders"));
        }
        IdeaAndroidProject androidProject = facet.getIdeaAndroidProject();
        if (androidProject == null) {
            return;
        }
        File buildFolderPath = androidProject.getDelegate().getBuildFolder();
        if (!buildFolderPath.isDirectory()) {
            return;
        }
        Module module = facet.getModule();
        if (module.getProject().isDisposed()) {
            return;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        try {
            ContentEntry[] contentEntries = rootModel.getContentEntries();
            ContentEntry parent = FilePaths.findParentContentEntry(buildFolderPath, contentEntries);
            if (parent == null) {
                rootModel.dispose();
                return;
            }
            File[] outputFolderPaths = FileUtil.notNullize((File[])buildFolderPath.listFiles());
            if (outputFolderPaths.length == 0) {
                rootModel.dispose();
                return;
            }
            for (File outputFolderPath : outputFolderPaths) {
                if (!androidProject.shouldManuallyExclude(outputFolderPath)) continue;
                boolean alreadyExcluded = false;
                for (VirtualFile excluded : parent.getExcludeFolderFiles()) {
                    if (!FileUtil.filesEqual((File)outputFolderPath, (File)VfsUtilCore.virtualToIoFile((VirtualFile)excluded))) continue;
                    alreadyExcluded = true;
                    break;
                }
                if (alreadyExcluded) continue;
                parent.addExcludeFolder(FilePaths.pathToIdeaUrl(outputFolderPath));
            }
        }
        finally {
            if (!rootModel.isDisposed()) {
                rootModel.commit();
            }
        }
    }

    private static boolean unresolvedDependenciesFound(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "unresolvedDependenciesFound"));
        }
        return errorMessage.contains("Could not resolve all dependencies");
    }

    private void notifyUnresolvedDependenciesInOfflineMode() {
        NotificationHyperlink disableOfflineModeHyperlink = new NotificationHyperlink("disable.gradle.offline.mode", "Disable offline mode"){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor$2", "execute"));
                }
                GradleSettings.getInstance((Project)PostProjectBuildTasksExecutor.this.myProject).setOfflineWork(false);
            }
        };
        String title = "Unresolved Dependencies";
        String text = "Unresolved dependencies detected while building project in offline mode. Please disable offline mode and try again.";
        AndroidGradleNotification.getInstance(this.myProject).showBalloon(title, text, NotificationType.ERROR, disableOfflineModeHyperlink);
    }

    private void refreshProject() {
        String projectPath = this.myProject.getBasePath();
        VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(projectPath);
        if (rootDir != null && rootDir.isDirectory()) {
            rootDir.refresh(true, true);
        }
    }

    private void notifyBuildFinished(final @Nullable BuildMode buildMode) {
        this.syncPublisher(new Runnable(){

            @Override
            public void run() {
                ((GradleBuildListener)PostProjectBuildTasksExecutor.this.myProject.getMessageBus().syncPublisher(GRADLE_BUILD_TOPIC)).buildFinished(PostProjectBuildTasksExecutor.this.myProject, buildMode);
            }
        });
    }

    private void syncPublisher(@NotNull Runnable publishingTask) {
        if (publishingTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishingTask", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor", "syncPublisher"));
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, (Runnable)publishingTask);
    }

    public void updateJavaLangLevelAfterBuild() {
        this.myProject.putUserData(UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD, (Object)true);
    }

    private void syncJavaLangLevel() {
        Boolean updateJavaLangLevel = (Boolean)this.myProject.getUserData(UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD);
        if (updateJavaLangLevel == null || !updateJavaLangLevel.booleanValue()) {
            return;
        }
        this.myProject.putUserData(UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD, null);
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

            public void execute() {
                LanguageLevelProjectExtension ext;
                LanguageLevel langLevel;
                if (PostProjectBuildTasksExecutor.this.myProject.isOpen() && (langLevel = PostProjectBuildTasksExecutor.this.getMaxJavaLangLevel()) != null && langLevel != (ext = LanguageLevelProjectExtension.getInstance((Project)PostProjectBuildTasksExecutor.this.myProject)).getLanguageLevel()) {
                    ext.setLanguageLevel(langLevel);
                }
            }
        });
    }

    @VisibleForTesting
    @Nullable
    LanguageLevel getMaxJavaLangLevel() {
        Module[] modules;
        LanguageLevel maxLangLevel = null;
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            LanguageLevel langLevel;
            IdeaAndroidProject androidProject;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (androidProject = facet.getIdeaAndroidProject()) == null || (langLevel = androidProject.getJavaLanguageLevel()) == null || maxLangLevel != null && maxLangLevel.compareTo((Enum)langLevel) >= 0) continue;
            maxLangLevel = langLevel;
        }
        return maxLangLevel;
    }

    private static class GradleMessageIterator
    extends AbstractIterator<String> {
        private final Iterator<GradleMessage> myIterator;

        GradleMessageIterator(@NotNull Collection<GradleMessage> compilerMessages) {
            if (compilerMessages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerMessages", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor$GradleMessageIterator", "<init>"));
            }
            this.myIterator = compilerMessages.iterator();
        }

        @Nullable
        protected String computeNext() {
            if (!this.myIterator.hasNext()) {
                return (String)this.endOfData();
            }
            GradleMessage msg = this.myIterator.next();
            return msg != null ? msg.getText() : null;
        }
    }

    private static class CompilerMessageIterator
    extends AbstractIterator<String> {
        @NotNull
        private final CompilerMessage[] myErrors;
        private int counter;

        CompilerMessageIterator(@NotNull CompilerMessage[] errors) {
            if (errors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/android/tools/idea/gradle/compiler/PostProjectBuildTasksExecutor$CompilerMessageIterator", "<init>"));
            }
            this.myErrors = errors;
        }

        @Nullable
        protected String computeNext() {
            if (this.counter >= this.myErrors.length) {
                return (String)this.endOfData();
            }
            return this.myErrors[this.counter++].getMessage();
        }
    }
}

