/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.ModulesToImportDialog;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    private static final Logger LOG = Logger.getInstance(ProjectSetUpTask.class);
    @NonNls
    private static final String SELECTED_MODULES_PROPERTY_NAME = "com.android.studio.selected.modules.on.import";
    @NotNull
    private final Project myProject;
    private final boolean myProjectIsNew;
    private final boolean mySelectModulesToImport;
    @Nullable
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(@NotNull Project project, boolean projectIsNew, boolean selectModulesToImport, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "<init>"));
        }
        this.myProject = project;
        this.myProjectIsNew = projectIsNew;
        this.mySelectModulesToImport = selectModulesToImport;
        this.mySyncListener = syncListener;
    }

    public void onSuccess(@Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        this.populateProject(projectInfo);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
                if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                    if (ProjectSetUpTask.this.myProjectIsNew) {
                        Projects.open(ProjectSetUpTask.this.myProject);
                    }
                    if (!isTest) {
                        ProjectSetUpTask.this.myProject.save();
                    }
                }
                if (ProjectSetUpTask.this.myProjectIsNew) {
                    AndroidGradleProjectComponent projectComponent = (AndroidGradleProjectComponent)((Object)ServiceManager.getService((Project)ProjectSetUpTask.this.myProject, AndroidGradleProjectComponent.class));
                    projectComponent.configureGradleProject(false);
                }
                if (ProjectSetUpTask.this.mySyncListener != null) {
                    ProjectSetUpTask.this.mySyncListener.syncSucceeded(ProjectSetUpTask.this.myProject);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    private void populateProject(final @NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "populateProject"));
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                final Collection modules = ProjectSetUpTask.this.getModulesToImport((DataNode<ProjectData>)projectInfo);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ProjectRootManagerEx.getInstanceEx((Project)ProjectSetUpTask.this.myProject).mergeRootsChangesDuring(new Runnable(){

                            @Override
                            public void run() {
                                ProjectDataManager dataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
                                dataManager.importData(ProjectKeys.MODULE, modules, ProjectSetUpTask.this.myProject, true);
                            }
                        });
                    }
                });
                PostProjectSetupTasksExecutor.getInstance(ProjectSetUpTask.this.myProject).onProjectSyncCompletion();
            }
        });
    }

    @NotNull
    private Collection<DataNode<ModuleData>> getModulesToImport(DataNode<ProjectData> projectInfo) {
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        if (modules.size() > 1 && ProjectSetUpTask.isModuleSelectionEnabled()) {
            if (this.mySelectModulesToImport) {
                ModulesToImportDialog dialog = new ModulesToImportDialog(modules, this.myProject);
                if (dialog.showAndGet()) {
                    Collection<DataNode<ModuleData>> selectedModules = dialog.getSelectedModules();
                    ArrayList moduleNames = Lists.newArrayListWithExpectedSize((int)selectedModules.size());
                    for (DataNode<ModuleData> module : selectedModules) {
                        moduleNames.add(((ModuleData)module.getData()).getExternalName());
                    }
                    PropertiesComponent.getInstance((Project)this.myProject).setValues(SELECTED_MODULES_PROPERTY_NAME, ArrayUtil.toStringArray((Collection)moduleNames));
                    Collection<DataNode<ModuleData>> collection = selectedModules;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "getModulesToImport"));
                    }
                    return collection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = PropertiesComponent.getInstance((Project)this.myProject).getValues(SELECTED_MODULES_PROPERTY_NAME);
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    ArrayList arrayList = selectedModules;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "getModulesToImport"));
                    }
                    return arrayList;
                }
            }
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValues(SELECTED_MODULES_PROPERTY_NAME, null);
        Collection collection = modules;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "getModulesToImport"));
        }
        return collection;
    }

    private static boolean isModuleSelectionEnabled() {
        return GradleExperimentalSettings.getInstance().SELECT_MODULES_ON_PROJECT_IMPORT;
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "onFailure"));
        }
        if (errorDetails != null) {
            LOG.warn(errorDetails);
        }
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        LOG.info(newMessage);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
    }
}

