/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.mvc.projectView.ClassNode;
import org.jetbrains.plugins.groovy.mvc.projectView.MethodNode;
import org.jetbrains.plugins.groovy.mvc.projectView.NodeId;
import org.jetbrains.plugins.groovy.mvc.projectView.TestMethodNode;

public class TestClassNode
extends ClassNode {
    private final Icon myMethodIcon;

    public TestClassNode(@NotNull Module module, @NotNull GrTypeDefinition controllerClass, @Nullable ViewSettings viewSettings, Icon methodIcon) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/mvc/projectView/TestClassNode", "<init>"));
        }
        if (controllerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/groovy/mvc/projectView/TestClassNode", "<init>"));
        }
        super(module, controllerClass, "TEST_INTESTS", viewSettings);
        this.myMethodIcon = methodIcon;
    }

    @Override
    @Nullable
    protected MethodNode createNodeForMethod(Module module, GrMethod method, String parentLocationRootMark) {
        if (method == null) {
            return null;
        }
        boolean isTestMethod = JUnitUtil.isTestMethod((Location)new PsiLocation(this.getProject(), (PsiElement)method));
        if (isTestMethod) {
            return new TestMethodNode(module, method, "TEST_INTESTS", this.getSettings(), this.myMethodIcon);
        }
        return new MethodNode(module, method, "TEST_INTESTS", this.getSettings());
    }

    @Override
    protected String getTestPresentationImpl(@NotNull NodeId nodeId, @NotNull PsiElement psiElement) {
        if (nodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeId", "org/jetbrains/plugins/groovy/mvc/projectView/TestClassNode", "getTestPresentationImpl"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/groovy/mvc/projectView/TestClassNode", "getTestPresentationImpl"));
        }
        return "Test class: " + ((GrTypeDefinition)psiElement).getName();
    }
}

