/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactModel;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.ManifestFileProvider;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.DefaultManifestFileProvider;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.ArtifactExternalDependenciesImporter;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;

public abstract class MavenBaseModifiableModelsProvider
implements MavenModifiableModelsProvider {
    protected ModifiableModuleModel myModuleModel;
    protected Map<Module, ModifiableRootModel> myRootModels = new THashMap();
    protected Map<Module, ModifiableFacetModel> myFacetModels = new THashMap();
    protected Map<Library, Library.ModifiableModel> myLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
    protected ModifiableArtifactModel myArtifactModel;
    protected final Project myProject;
    private MyPackagingElementResolvingContext myPackagingElementResolvingContext;
    private final ArtifactExternalDependenciesImporter myArtifactExternalDependenciesImporter;

    public MavenBaseModifiableModelsProvider(Project project) {
        this.myProject = project;
        this.myArtifactExternalDependenciesImporter = new ArtifactExternalDependenciesImporter();
    }

    @Override
    public ModifiableModuleModel getModuleModel() {
        if (this.myModuleModel == null) {
            this.myModuleModel = this.doGetModuleModel();
        }
        return this.myModuleModel;
    }

    @Override
    public ModifiableRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider", "getRootModel"));
        }
        ModifiableRootModel result = this.myRootModels.get(module);
        if (result == null) {
            result = this.doGetRootModel(module);
            this.myRootModels.put(module, result);
        }
        return result;
    }

    @Override
    public ModifiableFacetModel getFacetModel(Module module) {
        ModifiableFacetModel result = this.myFacetModels.get(module);
        if (result == null) {
            result = this.doGetFacetModel(module);
            this.myFacetModels.put(module, result);
        }
        return result;
    }

    @Override
    public ModifiableArtifactModel getArtifactModel() {
        if (this.myArtifactModel == null) {
            this.myArtifactModel = this.doGetArtifactModel();
        }
        return this.myArtifactModel;
    }

    @Override
    public PackagingElementResolvingContext getPackagingElementResolvingContext() {
        if (this.myPackagingElementResolvingContext == null) {
            this.myPackagingElementResolvingContext = new MyPackagingElementResolvingContext();
        }
        return this.myPackagingElementResolvingContext;
    }

    @Override
    public ArtifactExternalDependenciesImporter getArtifactExternalDependenciesImporter() {
        return this.myArtifactExternalDependenciesImporter;
    }

    @Override
    public Library.ModifiableModel getLibraryModel(Library library) {
        Library.ModifiableModel result = this.myLibraryModels.get(library);
        if (result == null) {
            result = this.doGetLibraryModel(library);
            this.myLibraryModels.put(library, result);
        }
        return result;
    }

    @Override
    @NotNull
    public String[] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider", "getLibraryUrls"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider", "getLibraryUrls"));
        }
        Library.ModifiableModel model = this.myLibraryModels.get(library);
        if (model != null) {
            String[] stringArray = model.getUrls(type);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider", "getLibraryUrls"));
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider", "getLibraryUrls"));
        }
        return stringArray;
    }

    protected abstract ModifiableArtifactModel doGetArtifactModel();

    protected abstract ModifiableModuleModel doGetModuleModel();

    protected abstract ModifiableRootModel doGetRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetLibraryModel(Library var1);

    @Override
    public Module[] getModules() {
        return this.getModuleModel().getModules();
    }

    protected void processExternalArtifactDependencies() {
        this.myArtifactExternalDependenciesImporter.applyChanges(this.getArtifactModel(), this.getPackagingElementResolvingContext());
    }

    @Override
    public VirtualFile[] getContentRoots(Module module) {
        return this.getRootModel(module).getContentRoots();
    }

    private class MavenFacetsProvider
    implements FacetsProvider {
        private MavenFacetsProvider() {
        }

        @NotNull
        public Facet[] getAllFacets(Module module) {
            Facet[] facetArray = MavenBaseModifiableModelsProvider.this.getFacetModel(module).getAllFacets();
            if (facetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MavenFacetsProvider", "getAllFacets"));
            }
            return facetArray;
        }

        @NotNull
        public <F extends Facet> Collection<F> getFacetsByType(Module module, FacetTypeId<F> type) {
            Collection collection = MavenBaseModifiableModelsProvider.this.getFacetModel(module).getFacetsByType(type);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MavenFacetsProvider", "getFacetsByType"));
            }
            return collection;
        }

        public <F extends Facet> F findFacet(Module module, FacetTypeId<F> type, String name) {
            return (F)MavenBaseModifiableModelsProvider.this.getFacetModel(module).findFacet(type, name);
        }
    }

    private class MavenModulesProvider
    implements ModulesProvider {
        private MavenModulesProvider() {
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = MavenBaseModifiableModelsProvider.this.getModuleModel().getModules();
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MavenModulesProvider", "getModules"));
            }
            return moduleArray;
        }

        public Module getModule(String name) {
            return MavenBaseModifiableModelsProvider.this.getModuleModel().findModuleByName(name);
        }

        public ModuleRootModel getRootModel(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MavenModulesProvider", "getRootModel"));
            }
            return MavenBaseModifiableModelsProvider.this.getRootModel(module);
        }

        public FacetModel getFacetModel(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MavenModulesProvider", "getFacetModel"));
            }
            return MavenBaseModifiableModelsProvider.this.getFacetModel(module);
        }
    }

    private class MyPackagingElementResolvingContext
    implements PackagingElementResolvingContext {
        private final ModulesProvider myModulesProvider;
        private final MavenFacetsProvider myFacetsProvider;
        private final DefaultManifestFileProvider myManifestFileProvider;

        private MyPackagingElementResolvingContext() {
            this.myModulesProvider = new MavenModulesProvider();
            this.myFacetsProvider = new MavenFacetsProvider();
            this.myManifestFileProvider = new DefaultManifestFileProvider((PackagingElementResolvingContext)this);
        }

        @NotNull
        public Project getProject() {
            Project project = MavenBaseModifiableModelsProvider.this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MyPackagingElementResolvingContext", "getProject"));
            }
            return project;
        }

        @NotNull
        public ArtifactModel getArtifactModel() {
            ModifiableArtifactModel modifiableArtifactModel = MavenBaseModifiableModelsProvider.this.getArtifactModel();
            if (modifiableArtifactModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MyPackagingElementResolvingContext", "getArtifactModel"));
            }
            return modifiableArtifactModel;
        }

        @NotNull
        public ModulesProvider getModulesProvider() {
            ModulesProvider modulesProvider = this.myModulesProvider;
            if (modulesProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MyPackagingElementResolvingContext", "getModulesProvider"));
            }
            return modulesProvider;
        }

        @NotNull
        public FacetsProvider getFacetsProvider() {
            MavenFacetsProvider mavenFacetsProvider = this.myFacetsProvider;
            if (mavenFacetsProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MyPackagingElementResolvingContext", "getFacetsProvider"));
            }
            return mavenFacetsProvider;
        }

        public Library findLibrary(@NotNull String level, @NotNull String libraryName) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (libraryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MyPackagingElementResolvingContext", "findLibrary"));
            }
            if (level.equals("project")) {
                return MavenBaseModifiableModelsProvider.this.getLibraryByName(libraryName);
            }
            LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, MavenBaseModifiableModelsProvider.this.myProject);
            return table != null ? table.getLibraryByName(libraryName) : null;
        }

        @NotNull
        public ManifestFileProvider getManifestFileProvider() {
            DefaultManifestFileProvider defaultManifestFileProvider = this.myManifestFileProvider;
            if (defaultManifestFileProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenBaseModifiableModelsProvider$MyPackagingElementResolvingContext", "getManifestFileProvider"));
            }
            return defaultManifestFileProvider;
        }
    }
}

