/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenSourceFoldersModuleExtension;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.Path;
import org.jetbrains.idea.maven.utils.Url;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenRootModelAdapter {
    private final MavenProject myMavenProject;
    private final ModifiableModuleModel myModuleModel;
    private final ModifiableRootModel myRootModel;
    private final MavenSourceFoldersModuleExtension myRootModelModuleExtension;
    private final Set<String> myOrderEntriesBeforeJdk;

    public MavenRootModelAdapter(@NotNull MavenProject p, @NotNull Module module, MavenModifiableModelsProvider rootModelsProvider) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "<init>"));
        }
        this.myOrderEntriesBeforeJdk = new THashSet();
        this.myMavenProject = p;
        this.myModuleModel = rootModelsProvider.getModuleModel();
        this.myRootModel = rootModelsProvider.getRootModel(module);
        this.myRootModelModuleExtension = (MavenSourceFoldersModuleExtension)((Object)this.myRootModel.getModuleExtension(MavenSourceFoldersModuleExtension.class));
        this.myRootModelModuleExtension.init(module, this.myRootModel);
    }

    public void init(boolean isNewlyCreatedModule) {
        this.setupInitialValues(isNewlyCreatedModule);
        this.initContentRoots();
        this.initOrderEntries();
    }

    private void setupInitialValues(boolean newlyCreatedModule) {
        if (newlyCreatedModule || this.myRootModel.getSdk() == null) {
            this.myRootModel.inheritSdk();
        }
        if (newlyCreatedModule) {
            this.getCompilerExtension().setExcludeOutput(true);
        }
    }

    private void initContentRoots() {
        Url url = this.toUrl(this.myMavenProject.getDirectory());
        if (this.getContentRootFor(url) != null) {
            return;
        }
        this.myRootModel.addContentEntry(url.getUrl());
    }

    private ContentEntry getContentRootFor(Url url) {
        for (ContentEntry e : this.myRootModel.getContentEntries()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)e.getUrl(), (String)url.getUrl())) continue;
            return e;
        }
        return null;
    }

    private void initOrderEntries() {
        boolean jdkProcessed = false;
        for (OrderEntry e : this.myRootModel.getOrderEntries()) {
            Module m;
            if (e instanceof ModuleSourceOrderEntry || e instanceof JdkOrderEntry) {
                jdkProcessed = true;
                continue;
            }
            if (e instanceof LibraryOrderEntry && !MavenRootModelAdapter.isMavenLibrary(((LibraryOrderEntry)e).getLibrary()) || e instanceof ModuleOrderEntry && (m = ((ModuleOrderEntry)e).getModule()) != null && !MavenProjectsManager.getInstance(this.myRootModel.getProject()).isMavenizedModule(m)) continue;
            if (!jdkProcessed) {
                if (e instanceof ModuleOrderEntry) {
                    this.myOrderEntriesBeforeJdk.add(((ModuleOrderEntry)e).getModuleName());
                } else if (e instanceof LibraryOrderEntry) {
                    this.myOrderEntriesBeforeJdk.add(((LibraryOrderEntry)e).getLibraryName());
                }
            }
            this.myRootModel.removeOrderEntry(e);
        }
    }

    public ModifiableRootModel getRootModel() {
        return this.myRootModel;
    }

    @NotNull
    public String[] getSourceRootUrls(boolean includingTests) {
        String[] stringArray = this.myRootModelModuleExtension.getSourceRootUrls(includingTests);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "getSourceRootUrls"));
        }
        return stringArray;
    }

    public Module getModule() {
        return this.myRootModel.getModule();
    }

    public void clearSourceFolders() {
        this.myRootModelModuleExtension.clearSourceFolders();
    }

    public <P extends JpsElement> void addSourceFolder(String path, JpsModuleSourceRootType<P> rootType) {
        this.addSourceFolder(path, rootType, false, (JpsElement)rootType.createDefaultProperties());
    }

    public void addGeneratedJavaSourceFolder(String path, JavaSourceRootType rootType) {
        this.addSourceFolder(path, (JpsModuleSourceRootType)rootType, true, (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties("", true));
    }

    private <P extends JpsElement> void addSourceFolder(@NotNull String path, @NotNull JpsModuleSourceRootType<P> rootType, boolean ifNotEmpty, @NotNull P properties) {
        String[] childs;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "addSourceFolder"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "addSourceFolder"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "addSourceFolder"));
        }
        if (ifNotEmpty ? (childs = new File(this.toPath(path).getPath()).list()) == null || childs.length == 0 : !this.exists(path)) {
            return;
        }
        Url url = this.toUrl(path);
        this.myRootModelModuleExtension.addSourceFolder(url, rootType, properties);
    }

    public boolean hasRegisteredSourceSubfolder(@NotNull File f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "hasRegisteredSourceSubfolder"));
        }
        String url = this.toUrl(f.getPath()).getUrl();
        return this.myRootModelModuleExtension.hasRegisteredSourceSubfolder(url);
    }

    @Nullable
    public SourceFolder getSourceFolder(File folder) {
        String url = this.toUrl(folder.getPath()).getUrl();
        return this.myRootModelModuleExtension.getSourceFolder(url);
    }

    public boolean isAlreadyExcluded(File f) {
        String url = this.toUrl(f.getPath()).getUrl();
        return VfsUtilCore.isUnder((String)url, Arrays.asList(this.myRootModel.getExcludeRootUrls()));
    }

    private boolean exists(String path) {
        return new File(this.toPath(path).getPath()).exists();
    }

    public void addExcludedFolder(String path) {
        this.unregisterAll(path, true, false);
        Url url = this.toUrl(path);
        ContentEntry e = this.getContentRootFor(url);
        if (e == null) {
            return;
        }
        if (e.getUrl().equals(url.getUrl())) {
            return;
        }
        e.addExcludeFolder(url.getUrl());
        if (!Registry.is((String)"ide.hide.excluded.files")) {
            Project project = this.myRootModel.getProject();
            ChangeListManager.getInstance((Project)project).addDirectoryToIgnoreImplicitly(this.toPath(path).getPath());
        }
    }

    public void unregisterAll(String path, boolean under, boolean unregisterSources) {
        Url url = this.toUrl(path);
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            if (unregisterSources) {
                this.myRootModelModuleExtension.unregisterAll(url, under);
            }
            for (String excludedUrl : eachEntry.getExcludeFolderUrls()) {
                String child;
                String ancestor = under ? url.getUrl() : excludedUrl;
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = under ? excludedUrl : url.getUrl()))) continue;
                eachEntry.removeExcludeFolder(excludedUrl);
            }
            for (String outputUrl : this.getCompilerExtension().getOutputRootUrls(true)) {
                String child;
                String ancestor = under ? url.getUrl() : outputUrl;
                String string = child = under ? outputUrl : url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)child)) continue;
                this.getCompilerExtension().setExcludeOutput(false);
            }
        }
    }

    public boolean hasCollision(String sourceRootPath) {
        Url url = this.toUrl(sourceRootPath);
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                String child;
                String ancestor = url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = eachFolder.getUrl())) && !VfsUtilCore.isEqualOrAncestor((String)child, (String)ancestor)) continue;
                return true;
            }
            for (String excludeUrl : eachEntry.getExcludeFolderUrls()) {
                String ancestor = url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)excludeUrl) && !VfsUtilCore.isEqualOrAncestor((String)excludeUrl, (String)ancestor)) continue;
                return true;
            }
        }
        return false;
    }

    public void useModuleOutput(String production, String test) {
        this.getCompilerExtension().inheritCompilerOutputPath(false);
        this.getCompilerExtension().setCompilerOutputPath(this.toUrl(production).getUrl());
        this.getCompilerExtension().setCompilerOutputPathForTests(this.toUrl(test).getUrl());
    }

    private CompilerModuleExtension getCompilerExtension() {
        return (CompilerModuleExtension)this.myRootModel.getModuleExtension(CompilerModuleExtension.class);
    }

    private Url toUrl(String path) {
        return this.toPath(path).toUrl();
    }

    public Path toPath(String path) {
        if (!FileUtil.isAbsolute((String)path)) {
            path = new File(this.myMavenProject.getDirectory(), path).getPath();
        }
        return new Path(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModuleDependency(@NotNull String moduleName, @NotNull DependencyScope scope, boolean testJar) {
        ModuleOrderEntry e;
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "addModuleDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "addModuleDependency"));
        }
        Module m = this.findModuleByName(moduleName);
        if (m != null) {
            e = this.myRootModel.addModuleOrderEntry(m);
        } else {
            AccessToken accessToken = ReadAction.start();
            try {
                e = this.myRootModel.addInvalidModuleEntry(moduleName);
            }
            finally {
                accessToken.finish();
            }
        }
        e.setScope(scope);
        if (testJar) {
            ((ModuleOrderEntryImpl)e).setProductionOnTestDependency(true);
        }
        if (this.myOrderEntriesBeforeJdk.contains(moduleName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
    }

    @Nullable
    public Module findModuleByName(String moduleName) {
        return this.myModuleModel.findModuleByName(moduleName);
    }

    public void addSystemDependency(MavenArtifact artifact, DependencyScope scope) {
        assert ("system".equals(artifact.getScope()));
        String libraryName = artifact.getLibraryName();
        Library library = this.myRootModel.getModuleLibraryTable().getLibraryByName(libraryName);
        if (library == null) {
            library = this.myRootModel.getModuleLibraryTable().createLibrary(libraryName);
        }
        LibraryOrderEntry orderEntry = this.myRootModel.findLibraryOrderEntry(library);
        assert (orderEntry != null);
        orderEntry.setScope(scope);
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        MavenRootModelAdapter.updateUrl(modifiableModel, OrderRootType.CLASSES, artifact, null, null, true);
        modifiableModel.commit();
        if (this.myOrderEntriesBeforeJdk.contains(libraryName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
    }

    public void addLibraryDependency(MavenArtifact artifact, DependencyScope scope, MavenModifiableModelsProvider provider, MavenProject project) {
        assert (!"system".equals(artifact.getScope()));
        String libraryName = artifact.getLibraryName();
        Library library = provider.getLibraryByName(libraryName);
        if (library == null) {
            library = provider.createLibrary(libraryName);
        }
        Library.ModifiableModel libraryModel = provider.getLibraryModel(library);
        MavenRootModelAdapter.updateUrl(libraryModel, OrderRootType.CLASSES, artifact, null, null, true);
        MavenRootModelAdapter.updateUrl(libraryModel, OrderRootType.SOURCES, artifact, MavenExtraArtifactType.SOURCES, project, false);
        MavenRootModelAdapter.updateUrl(libraryModel, JavadocOrderRootType.getInstance(), artifact, MavenExtraArtifactType.DOCS, project, false);
        LibraryOrderEntry e = this.myRootModel.addLibraryEntry(library);
        e.setScope(scope);
        if (this.myOrderEntriesBeforeJdk.contains(libraryName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
    }

    private void moveLastOrderEntryBeforeJdk() {
        int i;
        OrderEntry[] entries = (OrderEntry[])this.myRootModel.getOrderEntries().clone();
        for (i = entries.length - 1; i > 0 && (entries[i - 1] instanceof ModuleSourceOrderEntry || entries[i - 1] instanceof JdkOrderEntry); --i) {
            OrderEntry e = entries[i - 1];
            entries[i - 1] = entries[i];
            entries[i] = e;
        }
        if (i < entries.length) {
            this.myRootModel.rearrangeOrderEntries(entries);
        }
    }

    private static void updateUrl(Library.ModifiableModel library, OrderRootType type, MavenArtifact artifact, MavenExtraArtifactType artifactType, MavenProject project, boolean clearAll) {
        String classifier = null;
        String extension = null;
        if (artifactType != null) {
            Pair<String, String> result = project.getClassifierAndExtension(artifact, artifactType);
            classifier = (String)result.first;
            extension = (String)result.second;
        }
        String newPath = artifact.getPathForExtraArtifact(classifier, extension);
        String newUrl = VirtualFileManager.constructUrl((String)"jar", (String)newPath) + "!/";
        boolean urlExists = false;
        for (String url : library.getUrls(type)) {
            if (newUrl.equals(url)) {
                urlExists = true;
                continue;
            }
            if (!clearAll && (!MavenRootModelAdapter.isRepositoryUrl(artifact, url) || url.startsWith(newUrl))) continue;
            library.removeRoot(url, type);
        }
        if (!urlExists) {
            library.addRoot(newUrl, type);
        }
    }

    private static boolean isRepositoryUrl(MavenArtifact artifact, String url) {
        return url.contains(artifact.getGroupId().replace('.', '/') + '/' + artifact.getArtifactId() + '/' + artifact.getBaseVersion() + '/' + artifact.getArtifactId() + '-');
    }

    public static boolean isChangedByUser(Library library) {
        String[] classRoots = library.getUrls(OrderRootType.CLASSES);
        if (classRoots.length != 1) {
            return true;
        }
        String classes = classRoots[0];
        if (!classes.endsWith("!/")) {
            return true;
        }
        int dotPos = classes.lastIndexOf("/", classes.length() - 2);
        if (dotPos == -1) {
            return true;
        }
        String pathToJar = classes.substring(0, dotPos);
        if (MavenRootModelAdapter.hasUserPaths(OrderRootType.SOURCES, library, pathToJar)) {
            return true;
        }
        return MavenRootModelAdapter.hasUserPaths(JavadocOrderRootType.getInstance(), library, pathToJar);
    }

    private static boolean hasUserPaths(OrderRootType rootType, Library library, String pathToJar) {
        String[] sources;
        for (String each : sources = library.getUrls(rootType)) {
            if (FileUtil.startsWith((String)each, (String)pathToJar)) continue;
            return true;
        }
        return false;
    }

    public Library findLibrary(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "findLibrary"));
        }
        final String name = artifact.getLibraryName();
        final Ref result = Ref.create(null);
        this.myRootModel.orderEntries().forEachLibrary((Processor)new Processor<Library>(){

            public boolean process(Library library) {
                if (name.equals(library.getName())) {
                    result.set((Object)library);
                }
                return true;
            }
        });
        return (Library)result.get();
    }

    @Deprecated
    public static String makeLibraryName(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "makeLibraryName"));
        }
        return artifact.getLibraryName();
    }

    public static boolean isMavenLibrary(@Nullable Library library) {
        return library != null && MavenArtifact.isMavenLibrary((String)library.getName());
    }

    @Nullable
    public static OrderEntry findLibraryEntry(@NotNull Module m, @NotNull MavenArtifact artifact) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "findLibraryEntry"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "findLibraryEntry"));
        }
        String name = artifact.getLibraryName();
        for (OrderEntry each : ModuleRootManager.getInstance((Module)m).getOrderEntries()) {
            if (!(each instanceof LibraryOrderEntry) || !name.equals(((LibraryOrderEntry)each).getLibraryName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public static MavenArtifact findArtifact(@NotNull MavenProject project, @Nullable Library library) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/importing/MavenRootModelAdapter", "findArtifact"));
        }
        if (library == null) {
            return null;
        }
        String name = library.getName();
        if (!MavenArtifact.isMavenLibrary((String)name)) {
            return null;
        }
        for (MavenArtifact each : project.getDependencies()) {
            if (!each.getLibraryName().equals(name)) continue;
            return each;
        }
        return null;
    }

    public void setLanguageLevel(LanguageLevel level) {
        try {
            ((LanguageLevelModuleExtension)this.myRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

