/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import com.intellij.util.text.StringFactory;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil
extends FileUtilRt {
    public static final int REGEX_PATTERN_FLAGS = SystemInfo.isFileSystemCaseSensitive ? 0 : 2;
    public static final TObjectHashingStrategy<String> PATH_HASHING_STRATEGY = FilePathHashingStrategy.create();
    public static final TObjectHashingStrategy<File> FILE_HASHING_STRATEGY = SystemInfo.isFileSystemCaseSensitive ? ContainerUtil.canonicalStrategy() : new TObjectHashingStrategy<File>(){

        @Override
        public int computeHashCode(File object) {
            return FileUtil.fileHashCode(object);
        }

        @Override
        public boolean equals(File o1, File o2) {
            return FileUtil.filesEqual(o1, o2);
        }
    };
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.FileUtil");

    @Nullable
    public static String getRelativePath(File base, File file) {
        return FileUtilRt.getRelativePath(base, file);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/util/io/FileUtil", "getRelativePath"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/io/FileUtil", "getRelativePath"));
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator);
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/util/io/FileUtil", "isAncestor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "isAncestor"));
        }
        return FileUtil.isAncestor(ancestor.getPath(), file.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull String ancestor, @NotNull String file, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/util/io/FileUtil", "isAncestor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "isAncestor"));
        }
        return !ThreeState.NO.equals((Object)FileUtil.isAncestorThreeState(ancestor, file, strict));
    }

    @NotNull
    public static ThreeState isAncestorThreeState(@NotNull String ancestor, @NotNull String file, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/openapi/util/io/FileUtil", "isAncestorThreeState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "isAncestorThreeState"));
        }
        String ancestorPath = FileUtil.toCanonicalPath(ancestor);
        String filePath = FileUtil.toCanonicalPath(file);
        ThreeState threeState = FileUtil.startsWith(filePath, ancestorPath, strict, SystemInfo.isFileSystemCaseSensitive, true);
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "isAncestorThreeState"));
        }
        return threeState;
    }

    @NotNull
    private static ThreeState startsWith(@NotNull String path, @NotNull String prefix, boolean strict, boolean caseSensitive, boolean checkImmediateParent) {
        char next1;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
        }
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            ThreeState threeState = pathLength == 0 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
            }
            return threeState;
        }
        if (prefixLength > pathLength) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
            }
            return threeState;
        }
        if (!path.regionMatches(!caseSensitive, 0, prefix, 0, prefixLength)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
            }
            return threeState;
        }
        if (pathLength == prefixLength) {
            ThreeState threeState = strict ? ThreeState.NO : ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
            }
            return threeState;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == File.separatorChar) {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        if ((next1 = path.charAt(slashOrSeparatorIdx)) == '/' || next1 == File.separatorChar) {
            if (!checkImmediateParent) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
                }
                return threeState;
            }
            if (slashOrSeparatorIdx == pathLength - 1) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
                }
                return threeState;
            }
            int idxNext = path.indexOf(next1, slashOrSeparatorIdx + 1);
            idxNext = idxNext == -1 ? path.indexOf(next1 == '/' ? 92 : 47, slashOrSeparatorIdx + 1) : idxNext;
            ThreeState threeState = idxNext == -1 ? ThreeState.YES : ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "startsWith"));
        }
        return threeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] loadFileBytes(@NotNull File file) throws IOException {
        byte[] bytes;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "loadFileBytes"));
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            long len = file.length();
            if (len < 0L) {
                throw new IOException("File length reported negative, probably doesn't exist");
            }
            if (FileUtil.isTooLarge(len)) {
                throw new FileTooBigException("Attempt to load '" + file + "' in memory buffer, file length is " + len + " bytes.");
            }
            bytes = FileUtil.loadBytes(stream, (int)len);
        }
        finally {
            ((InputStream)stream).close();
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadFileBytes"));
        }
        return bytes;
    }

    @NotNull
    public static String loadTextAndClose(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtil", "loadTextAndClose"));
        }
        String string = FileUtil.loadTextAndClose(new InputStreamReader(stream));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadTextAndClose"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadTextAndClose(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/FileUtil", "loadTextAndClose"));
        }
        String string = StringFactory.createShared(FileUtil.adaptiveLoadText(reader));
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadTextAndClose"));
        }
        return string2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static char[] adaptiveLoadText(@NotNull Reader reader) throws IOException {
        int n;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/FileUtil", "adaptiveLoadText"));
        }
        char[] chars = new char[4096];
        ArrayList<char[]> buffers = null;
        int count = 0;
        int total = 0;
        while ((n = reader.read(chars, count, chars.length - count)) > 0) {
            count += n;
            if (total > 0xA00000) {
                throw new FileTooBigException("File too big " + reader);
            }
            total += n;
            if (count != chars.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<char[]>();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        char[] result2 = new char[total];
        if (buffers != null) {
            for (char[] buffer : buffers) {
                System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
                total -= buffer.length;
            }
        }
        System.arraycopy(chars, 0, result2, result2.length - total, total);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "adaptiveLoadText"));
        }
        return result2;
    }

    public static boolean createParentDirs(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "createParentDirs"));
        }
        return FileUtilRt.createParentDirs(file);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "ensureCanCreateFile"));
        }
        return FileUtilRt.ensureCanCreateFile(file);
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/FileUtil", "copy"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/intellij/openapi/util/io/FileUtil", "copy"));
        }
        FileUtilRt.copy(inputStream, outputStream);
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "getNameWithoutExtension"));
        }
        String string = FileUtil.getNameWithoutExtension(file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "getNameWithoutExtension"));
        }
        return string;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/io/FileUtil", "getNameWithoutExtension"));
        }
        String string = FileUtilRt.getNameWithoutExtension(name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "getNameWithoutExtension"));
        }
        return string;
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aFileName", "com/intellij/openapi/util/io/FileUtil", "toSystemDependentName"));
        }
        String string = FileUtilRt.toSystemDependentName(aFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aFileName", "com/intellij/openapi/util/io/FileUtil", "toSystemIndependentName"));
        }
        String string = FileUtilRt.toSystemIndependentName(aFileName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "toSystemIndependentName"));
        }
        return string;
    }

    @Contract(value="null -> null")
    public static String toCanonicalPath(@Nullable String path) {
        return FileUtil.toCanonicalPath(path, File.separatorChar, true);
    }

    @Contract(value="null, _, _ -> null")
    private static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (".".equals(path)) {
            return "";
        }
        if ((path = path.replace(separatorChar, '/')).indexOf(47) == -1) {
            return path;
        }
        StringBuilder result2 = new StringBuilder(path.length());
        int start = FileUtil.processRoot(path, result2);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    FileUtil.processDots(result2, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            if (dots > 0) {
                StringUtil.repeatSymbol(result2, '.', dots);
                dots = 0;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0) {
            FileUtil.processDots(result2, dots, start);
        }
        int lastChar = result2.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result2.charAt(lastChar) == '/' && lastChar > start) {
            result2.deleteCharAt(lastChar);
        }
        return result2.toString();
    }

    private static int processRoot(String path, StringBuilder result2) {
        if (SystemInfo.isWindows && path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) == '/') {
            int shareStart;
            int hostStart;
            result2.append("//");
            for (hostStart = 2; hostStart < path.length() && path.charAt(hostStart) == '/'; ++hostStart) {
            }
            if (hostStart == path.length()) {
                return hostStart;
            }
            int hostEnd = path.indexOf(47, hostStart);
            if (hostEnd < 0) {
                hostEnd = path.length();
            }
            result2.append(path, hostStart, hostEnd);
            result2.append('/');
            for (shareStart = hostEnd; shareStart < path.length() && path.charAt(shareStart) == '/'; ++shareStart) {
            }
            if (shareStart == path.length()) {
                return shareStart;
            }
            int shareEnd = path.indexOf(47, shareStart);
            if (shareEnd < 0) {
                shareEnd = path.length();
            }
            result2.append(path, shareStart, shareEnd);
            result2.append('/');
            return shareEnd;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result2.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result2.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private static void processDots(StringBuilder result2, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!StringUtil.endsWith(result2, "/../") && !StringUtil.equals(result2, "../")) {
                pos = StringUtil.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            StringUtil.repeatSymbol(result2, '.', dots);
            result2.append('/');
        }
    }

    @NotNull
    public static String unquote(@NotNull String urlString) {
        if (urlString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlString", "com/intellij/openapi/util/io/FileUtil", "unquote"));
        }
        urlString = urlString.replace('/', File.separatorChar);
        String string = URLUtil.unescapePercentSequences(urlString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "unquote"));
        }
        return string;
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtil.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtil.toCanonicalPath(path1);
        path2 = FileUtil.toCanonicalPath(path2);
        return PATH_HASHING_STRATEGY.equals(path1, path2);
    }

    public static int fileHashCode(@Nullable File file) {
        return FileUtil.pathHashCode(file == null ? null : file.getPath());
    }

    public static int pathHashCode(@Nullable String path) {
        return StringUtil.isEmpty(path) ? 0 : PATH_HASHING_STRATEGY.computeHashCode(FileUtil.toCanonicalPath(path));
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        FileUtil.writeToFile(file, text, false);
    }

    public static void writeToFile(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        FileUtil.writeToFile(file, text.getBytes(CharsetToolkit.UTF8_CHARSET), false);
    }

    public static void writeToFile(@NotNull File file, @NotNull byte[] text, boolean append) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        FileUtil.writeToFile(file, text, 0, text.length, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(@NotNull File file, @NotNull byte[] text, int off, int len, boolean append) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/io/FileUtil", "writeToFile"));
        }
        FileUtil.createParentDirs(file);
        FileOutputStream stream = new FileOutputStream(file, append);
        try {
            ((OutputStream)stream).write(text, off, len);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<File> processor) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/util/io/FileUtil", "processFilesRecursively"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/util/io/FileUtil", "processFilesRecursively"));
        }
        return FileUtil.processFilesRecursively(root, processor, null);
    }

    public static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<File> processor, @Nullable Processor<File> directoryFilter) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/util/io/FileUtil", "processFilesRecursively"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/util/io/FileUtil", "processFilesRecursively"));
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            File[] children;
            File file = (File)queue.removeFirst();
            if (!processor.process(file)) {
                return false;
            }
            if (directoryFilter != null && (!file.isDirectory() || !directoryFilter.process(file)) || (children = file.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, children);
        }
        return true;
    }

    @Nullable
    public static File findFirstThatExist(String ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/openapi/util/io/FileUtil", "findFirstThatExist"));
        }
        for (String path : paths) {
            File file;
            if (StringUtil.isEmptyOrSpaces(path) || !(file = new File(FileUtil.toSystemDependentName(path))).exists()) continue;
            return file;
        }
        return null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String getLocationRelativeToUserHome(@Nullable String path) {
        return FileUtil.getLocationRelativeToUserHome(path, true);
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    public static String getLocationRelativeToUserHome(@Nullable String path, boolean unixOnly) {
        if (path == null) {
            return null;
        }
        if (SystemInfo.isUnix || !unixOnly) {
            File projectDir = new File(path);
            File userHomeDir = new File(SystemProperties.getUserHome());
            if (FileUtil.isAncestor(userHomeDir, projectDir, true)) {
                return '~' + File.separator + FileUtil.getRelativePath(userHomeDir, projectDir);
            }
        }
        return path;
    }

    @NotNull
    public static String expandUserHome(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtil", "expandUserHome"));
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "expandUserHome"));
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtil", "loadFile"));
        }
        String string = FileUtilRt.loadFile(file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtil", "loadLines"));
        }
        List<String> list = FileUtilRt.loadLines(path);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadLines"));
        }
        return list;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtil", "loadBytes"));
        }
        byte[] byArray = FileUtilRt.loadBytes(stream, length);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtil", "loadBytes"));
        }
        return byArray;
    }

    public static boolean isJarOrZip(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String name = file.getName();
        return StringUtil.endsWithIgnoreCase(name, ".jar") || StringUtil.endsWithIgnoreCase(name, ".zip");
    }
}

