/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntIterator;
import gnu.trove.TObjectIntProcedure;
import gnu.trove.TObjectProcedure;

public class TObjectIntHashMap<K>
extends TObjectHash<K> {
    protected transient int[] _values;

    public TObjectIntHashMap() {
    }

    public TObjectIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectIntHashMap(TObjectHashingStrategy<K> strategy) {
        super(strategy);
    }

    public TObjectIntHashMap(int initialCapacity, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectIntHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy<K> strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectIntIterator<K> iterator() {
        return new TObjectIntIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return capacity;
    }

    public int put(K key, int value) {
        int previous = 0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        Object oldKey = this._set[index2];
        this._set[index2] = key;
        this._values[index2] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        int[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new int[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            if (index2 < 0) {
                this.throwObjectContractViolation(this._set[-index2 - 1], o);
            }
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public int get(K key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0 : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            values[i] = 0;
        }
    }

    public int remove(K key) {
        int prev = 0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectIntHashMap)) {
            return false;
        }
        TObjectIntHashMap that = (TObjectIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = 0;
        super.removeAt(index2);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == null || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(int val) {
        Object[] keys = this._set;
        int[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure<K> procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectIntProcedure<K> procedure) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TObjectIntProcedure<K> procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        int[] values = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(K key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(K key, int amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private static final class EqProcedure<K>
    implements TObjectIntProcedure<K> {
        private final TObjectIntHashMap<K> _otherMap;

        EqProcedure(TObjectIntHashMap<K> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(K key, int value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }
}

