/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetDeclarationStub;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeConstraintList;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetSecondaryConstructor
extends JetDeclarationStub<KotlinPlaceHolderStub<JetSecondaryConstructor>>
implements JetFunction {
    public JetSecondaryConstructor(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "<init>"));
        }
        super(node);
    }

    public JetSecondaryConstructor(@NotNull KotlinPlaceHolderStub<JetSecondaryConstructor> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "<init>"));
        }
        super(stub, JetStubElementTypes.SECONDARY_CONSTRUCTOR);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "accept"));
        }
        return visitor2.visitSecondaryConstructor(this, data2);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return (JetParameterList)this.getStubOrPsiChild(JetStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        JetParameterList list = this.getValueParameterList();
        List<JetParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getValueParameters"));
        }
        return list2;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeReference() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getTypeReference() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference setTypeReference(@Nullable JetTypeReference typeRef) {
        return null;
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    @Override
    @Nullable
    public JetBlockExpression getBodyExpression() {
        return this.findChildByClass(JetBlockExpression.class);
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return null;
    }

    @Override
    public boolean hasBlockBody() {
        return true;
    }

    @Override
    public boolean hasBody() {
        return this.getBodyExpression() != null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getClassOrObject().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public JetTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    @Nullable
    public JetTypeConstraintList getTypeConstraintList() {
        return null;
    }

    @Override
    @NotNull
    public List<JetTypeConstraint> getTypeConstraints() {
        List<JetTypeConstraint> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getTypeConstraints"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<JetTypeParameter> getTypeParameters() {
        List<JetTypeParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getTypeParameters"));
        }
        return list;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        Name name = Name.identifier(this.getName());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getNameAsSafeName"));
        }
        return name;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        return null;
    }

    @Override
    @Nullable
    public Name getNameAsName() {
        return this.getNameAsSafeName();
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        return null;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "setName"));
        }
        throw new IncorrectOperationException("setName to constructor");
    }

    @NotNull
    public JetConstructorDelegationCall getDelegationCall() {
        JetConstructorDelegationCall jetConstructorDelegationCall = this.findChildByClass(JetConstructorDelegationCall.class);
        if (jetConstructorDelegationCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getDelegationCall"));
        }
        return jetConstructorDelegationCall;
    }

    public boolean hasImplicitDelegationCall() {
        return this.getDelegationCall().isImplicit();
    }

    @NotNull
    public JetClassOrObject getClassOrObject() {
        JetClassOrObject jetClassOrObject = (JetClassOrObject)this.getParent().getParent();
        if (jetClassOrObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getClassOrObject"));
        }
        return jetClassOrObject;
    }

    @NotNull
    public JetConstructorDelegationCall replaceImplicitDelegationCallWithExplicit(boolean isThis) {
        JetPsiFactory psiFactory = new JetPsiFactory(this.getProject());
        JetConstructorDelegationCall current = this.getDelegationCall();
        assert (current.isImplicit()) : "Method should not be called with explicit delegation call: " + this.getText();
        current.delete();
        PsiElement colon = this.addAfter(psiFactory.createColon(), this.getValueParameterList());
        String delegationName = isThis ? "this" : "super";
        JetConstructorDelegationCall jetConstructorDelegationCall = (JetConstructorDelegationCall)this.addAfter(psiFactory.createConstructorDelegationCall(delegationName + "()"), colon);
        if (jetConstructorDelegationCall == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "replaceImplicitDelegationCallWithExplicit"));
        }
        return jetConstructorDelegationCall;
    }

    @NotNull
    public PsiElement getConstructorKeyword() {
        Object t = this.findNotNullChildByType(JetTokens.CONSTRUCTOR_KEYWORD);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetSecondaryConstructor", "getConstructorKeyword"));
        }
        return t;
    }

    @Override
    public int getTextOffset() {
        return this.getConstructorKeyword().getTextRange().getStartOffset();
    }
}

