/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.parsing.JetScriptDefinition;
import org.jetbrains.kotlin.parsing.JetScriptDefinitionProvider;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetScript;

public class ScriptNameUtil {
    private ScriptNameUtil() {
    }

    @NotNull
    public static FqName classNameForScript(JetScript script) {
        JetFile file = script.getContainingJetFile();
        JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition(file);
        String name = file.getName();
        int index2 = name.lastIndexOf(47);
        if (index2 != -1) {
            name = name.substring(index2 + 1);
        }
        if (name.endsWith(scriptDefinition.getExtension())) {
            name = name.substring(0, name.length() - scriptDefinition.getExtension().length());
        } else {
            index2 = name.indexOf(46);
            if (index2 != -1) {
                name = name.substring(0, index2);
            }
        }
        name = Character.toUpperCase(name.charAt(0)) + (name.length() == 0 ? "" : name.substring(1));
        name = name.replace('.', '_');
        JetPackageDirective directive = file.getPackageDirective();
        if (directive != null && directive.getQualifiedName().length() > 0) {
            name = directive.getQualifiedName() + "." + name;
        }
        FqName fqName2 = new FqName(name);
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ScriptNameUtil", "classNameForScript"));
        }
        return fqName2;
    }
}

