/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.components.TypeUsage;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.JavaResolverUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmPackage;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmSignaturePackage;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.KotlinToJvmSignatureMapper;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.PropagationHeuristics;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

public class SignaturesPropagationData {
    private static final KotlinToJvmSignatureMapper SIGNATURE_MAPPER = ServiceLoader.load(KotlinToJvmSignatureMapper.class, KotlinToJvmSignatureMapper.class.getClassLoader()).iterator().next();
    private final JavaMethodDescriptor autoMethodDescriptor;
    private final List<TypeParameterDescriptor> modifiedTypeParameters;
    private final ValueParameters modifiedValueParameters;
    private final JetType modifiedReturnType;
    private final List<String> signatureErrors;
    private final List<FunctionDescriptor> superFunctions;
    private final Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> autoTypeParameterToModified;
    final ClassDescriptor containingClass;

    public SignaturesPropagationData(@NotNull ClassDescriptor containingClass, @NotNull JetType autoReturnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters, @NotNull JavaMethod method) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (autoReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoReturnType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (autoValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoValueParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (autoTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "<init>"));
        }
        this.signatureErrors = Lists.newArrayList();
        this.containingClass = containingClass;
        this.autoMethodDescriptor = SignaturesPropagationData.createAutoMethodDescriptor(containingClass, method, autoReturnType, receiverType, autoValueParameters, autoTypeParameters);
        this.superFunctions = SignaturesPropagationData.getSuperFunctionsForMethod(method, this.autoMethodDescriptor, containingClass);
        this.autoTypeParameterToModified = JavaResolverUtils.recreateTypeParametersAndReturnMapping(autoTypeParameters, null);
        this.modifiedTypeParameters = this.modifyTypeParametersAccordingToSuperMethods(autoTypeParameters);
        this.modifiedReturnType = this.modifyReturnTypeAccordingToSuperMethods(autoReturnType);
        this.modifiedValueParameters = this.modifyValueParametersAccordingToSuperMethods(receiverType, autoValueParameters);
    }

    @NotNull
    private static JavaMethodDescriptor createAutoMethodDescriptor(@NotNull ClassDescriptor containingClass, @NotNull JavaMethod method, JetType autoReturnType, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> autoValueParameters, @NotNull List<TypeParameterDescriptor> autoTypeParameters) {
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        if (autoValueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoValueParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        if (autoTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoTypeParameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        JavaMethodDescriptor autoMethodDescriptor = JavaMethodDescriptor.createJavaMethod(containingClass, Annotations.EMPTY, method.getName(), SourceElement.NO_SOURCE);
        autoMethodDescriptor.initialize(receiverType, containingClass.getThisAsReceiverParameter(), autoTypeParameters, (List)autoValueParameters, autoReturnType, Modality.OPEN, Visibilities.PUBLIC);
        JavaMethodDescriptor javaMethodDescriptor = autoMethodDescriptor;
        if (javaMethodDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "createAutoMethodDescriptor"));
        }
        return javaMethodDescriptor;
    }

    public List<TypeParameterDescriptor> getModifiedTypeParameters() {
        return this.modifiedTypeParameters;
    }

    public JetType getModifiedReceiverType() {
        return this.modifiedValueParameters.receiverType;
    }

    public List<ValueParameterDescriptor> getModifiedValueParameters() {
        return this.modifiedValueParameters.descriptors;
    }

    public boolean getModifiedHasStableParameterNames() {
        return this.modifiedValueParameters.hasStableParameterNames;
    }

    public JetType getModifiedReturnType() {
        return this.modifiedReturnType;
    }

    public List<String> getSignatureErrors() {
        return this.signatureErrors;
    }

    public List<FunctionDescriptor> getSuperFunctions() {
        return this.superFunctions;
    }

    void reportError(String error) {
        this.signatureErrors.add(error);
    }

    private JetType modifyReturnTypeAccordingToSuperMethods(@NotNull JetType autoType) {
        if (autoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyReturnTypeAccordingToSuperMethods"));
        }
        if (JvmPackage.getPLATFORM_TYPES()) {
            return autoType;
        }
        List<TypeAndVariance> typesFromSuperMethods = ContainerUtil.map(this.superFunctions, new Function<FunctionDescriptor, TypeAndVariance>(){

            @Override
            public TypeAndVariance fun(FunctionDescriptor superFunction) {
                return new TypeAndVariance(superFunction.getReturnType(), Variance.OUT_VARIANCE);
            }
        });
        return this.modifyTypeAccordingToSuperMethods(autoType, typesFromSuperMethods, TypeUsage.MEMBER_SIGNATURE_COVARIANT);
    }

    private List<TypeParameterDescriptor> modifyTypeParametersAccordingToSuperMethods(List<TypeParameterDescriptor> autoTypeParameters) {
        if (JvmPackage.getPLATFORM_TYPES()) {
            return autoTypeParameters;
        }
        ArrayList<TypeParameterDescriptor> result2 = Lists.newArrayList();
        for (TypeParameterDescriptor autoParameter : autoTypeParameters) {
            int index2 = autoParameter.getIndex();
            TypeParameterDescriptorImpl modifiedTypeParameter = this.autoTypeParameterToModified.get(autoParameter);
            ArrayList<Iterator<JetType>> upperBoundFromSuperFunctionsIterators = Lists.newArrayList();
            for (FunctionDescriptor functionDescriptor : this.superFunctions) {
                upperBoundFromSuperFunctionsIterators.add(functionDescriptor.getTypeParameters().get(index2).getUpperBounds().iterator());
            }
            for (JetType jetType : autoParameter.getUpperBounds()) {
                ArrayList<TypeAndVariance> upperBoundsFromSuperFunctions = Lists.newArrayList();
                for (Iterator iterator2 : upperBoundFromSuperFunctionsIterators) {
                    assert (iterator2.hasNext());
                    upperBoundsFromSuperFunctions.add(new TypeAndVariance((JetType)iterator2.next(), Variance.INVARIANT));
                }
                JetType modifiedUpperBound = this.modifyTypeAccordingToSuperMethods(jetType, upperBoundsFromSuperFunctions, TypeUsage.UPPER_BOUND);
                modifiedTypeParameter.addUpperBound(modifiedUpperBound);
            }
            for (Iterator iterator3 : upperBoundFromSuperFunctionsIterators) {
                assert (!iterator3.hasNext());
            }
            modifiedTypeParameter.setInitialized();
            result2.add(modifiedTypeParameter);
        }
        return result2;
    }

    private ValueParameters modifyValueParametersAccordingToSuperMethods(@Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyValueParametersAccordingToSuperMethods"));
        }
        assert (receiverType == null) : "Parameters before propagation have receiver type, but propagation should be disabled for functions compiled from Kotlin in class: " + DescriptorUtils.getFqName(this.containingClass);
        JetType resultReceiverType = null;
        ArrayList<ValueParameterDescriptor> resultParameters = Lists.newArrayList();
        boolean shouldBeExtension = this.checkIfShouldBeExtension();
        for (final ValueParameterDescriptor originalParam : parameters2) {
            final int originalIndex = originalParam.getIndex();
            List<TypeAndName> typesFromSuperMethods = ContainerUtil.map(this.superFunctions, new Function<FunctionDescriptor, TypeAndName>(){

                @Override
                public TypeAndName fun(FunctionDescriptor superFunction) {
                    int index2;
                    ReceiverParameterDescriptor receiver = superFunction.getExtensionReceiverParameter();
                    int n = index2 = receiver != null ? originalIndex - 1 : originalIndex;
                    if (index2 == -1) {
                        assert (receiver != null) : "can't happen: index is -1, while function is not extension";
                        return new TypeAndName(receiver.getType(), originalParam.getName());
                    }
                    ValueParameterDescriptor parameter = superFunction.getValueParameters().get(index2);
                    return new TypeAndName(parameter.getType(), parameter.getName());
                }
            });
            VarargCheckResult varargCheckResult = this.checkVarargInSuperFunctions(originalParam);
            JetType altType = this.modifyTypeAccordingToSuperMethods(varargCheckResult.parameterType, SignaturesPropagationData.convertToTypeVarianceList(typesFromSuperMethods), TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
            if (shouldBeExtension && originalIndex == 0) {
                resultReceiverType = altType;
                continue;
            }
            Name stableName = null;
            for (int i = 0; i < this.superFunctions.size(); ++i) {
                if (!this.superFunctions.get(i).hasStableParameterNames()) continue;
                stableName = typesFromSuperMethods.get((int)i).name;
                break;
            }
            resultParameters.add(new ValueParameterDescriptorImpl(originalParam.getContainingDeclaration(), null, shouldBeExtension ? originalIndex - 1 : originalIndex, originalParam.getAnnotations(), stableName != null ? stableName : originalParam.getName(), altType, originalParam.declaresDefaultValue(), varargCheckResult.isVararg ? DescriptorUtilPackage.getBuiltIns(originalParam).getArrayElementType(altType) : null, SourceElement.NO_SOURCE));
        }
        boolean hasStableParameterNames = KotlinPackage.any(this.superFunctions, new Function1<FunctionDescriptor, Boolean>(){

            @Override
            public Boolean invoke(FunctionDescriptor descriptor) {
                return descriptor.hasStableParameterNames();
            }
        });
        return new ValueParameters(resultReceiverType, resultParameters, hasStableParameterNames);
    }

    @NotNull
    private static List<TypeAndVariance> convertToTypeVarianceList(@NotNull List<TypeAndName> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "convertToTypeVarianceList"));
        }
        List<TypeAndVariance> list2 = KotlinPackage.map(list, new Function1<TypeAndName, TypeAndVariance>(){

            @Override
            public TypeAndVariance invoke(TypeAndName tvn) {
                return new TypeAndVariance(tvn.type, Variance.INVARIANT);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "convertToTypeVarianceList"));
        }
        return list2;
    }

    private static List<FunctionDescriptor> getSuperFunctionsForMethod(@NotNull JavaMethod method, @NotNull JavaMethodDescriptor autoMethodDescriptor, @NotNull ClassDescriptor containingClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getSuperFunctionsForMethod"));
        }
        if (autoMethodDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoMethodDescriptor", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getSuperFunctionsForMethod"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getSuperFunctionsForMethod"));
        }
        ArrayList<FunctionDescriptor> superFunctions = Lists.newArrayList();
        Name name = method.getName();
        JvmMethodSignature autoSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(autoMethodDescriptor);
        for (JetType supertype : containingClass.getTypeConstructor().getSupertypes()) {
            Collection<FunctionDescriptor> superFunctionCandidates = supertype.getMemberScope().getFunctions(name);
            for (FunctionDescriptor candidate : superFunctionCandidates) {
                JvmMethodSignature candidateSignature = SIGNATURE_MAPPER.mapToJvmMethodSignature(candidate);
                if (!JvmSignaturePackage.erasedSignaturesEqualIgnoringReturnTypes(autoSignature, candidateSignature)) continue;
                superFunctions.add(candidate);
            }
        }
        Collections.sort(superFunctions, new Comparator<FunctionDescriptor>(){

            @Override
            public int compare(@NotNull FunctionDescriptor fun1, @NotNull FunctionDescriptor fun2) {
                if (fun1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun1", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$5", "compare"));
                }
                if (fun2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun2", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$5", "compare"));
                }
                FqNameUnsafe fqName1 = DescriptorUtils.getFqName(fun1.getContainingDeclaration());
                FqNameUnsafe fqName2 = DescriptorUtils.getFqName(fun2.getContainingDeclaration());
                return fqName1.asString().compareTo(fqName2.asString());
            }
        });
        return superFunctions;
    }

    private boolean checkIfShouldBeExtension() {
        boolean someSupersExtension = false;
        boolean someSupersNotExtension = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            if (superFunction.getExtensionReceiverParameter() != null) {
                someSupersExtension = true;
                continue;
            }
            someSupersNotExtension = true;
        }
        if (someSupersExtension) {
            if (someSupersNotExtension) {
                this.reportError("Incompatible super methods: some are extension functions, some are not");
            } else {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private VarargCheckResult checkVarargInSuperFunctions(@NotNull ValueParameterDescriptor originalParam) {
        if (originalParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParam", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
        }
        boolean someSupersVararg = false;
        boolean someSupersNotVararg = false;
        for (FunctionDescriptor superFunction : this.superFunctions) {
            int index2;
            int originalIndex = originalParam.getIndex();
            int n = index2 = superFunction.getExtensionReceiverParameter() != null ? originalIndex - 1 : originalIndex;
            if (index2 != -1 && superFunction.getValueParameters().get(index2).getVarargElementType() != null) {
                someSupersVararg = true;
                continue;
            }
            someSupersNotVararg = true;
        }
        JetType originalVarargElementType = originalParam.getVarargElementType();
        JetType originalType = originalParam.getType();
        if (someSupersVararg && someSupersNotVararg) {
            this.reportError("Incompatible super methods: some have vararg parameter, some have not");
            VarargCheckResult varargCheckResult = new VarargCheckResult(originalType, originalVarargElementType != null);
            if (varargCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
            }
            return varargCheckResult;
        }
        if (someSupersVararg && originalVarargElementType == null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            VarargCheckResult varargCheckResult = new VarargCheckResult(TypeUtils.makeNotNullable(originalType), true);
            if (varargCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
            }
            return varargCheckResult;
        }
        if (someSupersNotVararg && originalVarargElementType != null) {
            assert (SignaturesPropagationData.isArrayType(originalType));
            VarargCheckResult varargCheckResult = new VarargCheckResult(TypeUtils.makeNullable(originalType), false);
            if (varargCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
            }
            return varargCheckResult;
        }
        VarargCheckResult varargCheckResult = new VarargCheckResult(originalType, originalVarargElementType != null);
        if (varargCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "checkVarargInSuperFunctions"));
        }
        return varargCheckResult;
    }

    @NotNull
    private JetType modifyTypeAccordingToSuperMethods(@NotNull JetType autoType, @NotNull List<TypeAndVariance> typesFromSuper, @NotNull TypeUsage howThisTypeIsUsed) {
        if (autoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeAccordingToSuperMethods"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeAccordingToSuperMethods"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeAccordingToSuperMethods"));
        }
        if (autoType.isError()) {
            JetType jetType = autoType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeAccordingToSuperMethods"));
            }
            return jetType;
        }
        if (JvmPackage.getPLATFORM_TYPES()) {
            JetType jetType = autoType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeAccordingToSuperMethods"));
            }
            return jetType;
        }
        boolean resultNullable = this.typeMustBeNullable(autoType, typesFromSuper, howThisTypeIsUsed);
        ClassifierDescriptor resultClassifier = this.modifyTypeClassifier(autoType, typesFromSuper);
        List<TypeProjection> resultArguments = this.getTypeArgsOfType(autoType, resultClassifier, typesFromSuper);
        JetScope resultScope = resultClassifier instanceof ClassDescriptor ? ((ClassDescriptor)resultClassifier).getMemberScope(resultArguments) : autoType.getMemberScope();
        JetTypeImpl type2 = new JetTypeImpl(autoType.getAnnotations(), resultClassifier.getTypeConstructor(), resultNullable, resultArguments, resultScope);
        PropagationHeuristics.checkArrayInReturnType(this, type2, typesFromSuper);
        JetTypeImpl jetTypeImpl = type2;
        if (jetTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeAccordingToSuperMethods"));
        }
        return jetTypeImpl;
    }

    @NotNull
    private List<TypeProjection> getTypeArgsOfType(@NotNull JetType autoType, @NotNull ClassifierDescriptor classifier2, @NotNull List<TypeAndVariance> typesFromSuper) {
        if (autoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypeArgsOfType"));
        }
        if (classifier2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypeArgsOfType"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypeArgsOfType"));
        }
        if (typesFromSuper.isEmpty()) {
            List<TypeProjection> list = autoType.getArguments();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypeArgsOfType"));
            }
            return list;
        }
        List<TypeProjection> autoArguments = autoType.getArguments();
        if (!(classifier2 instanceof ClassDescriptor)) {
            assert (autoArguments.isEmpty()) : "Unexpected type arguments when type constructor is not ClassDescriptor, type = " + autoType + ", classifier = " + classifier2 + ", classifier class = " + classifier2.getClass();
            List<TypeProjection> list = autoArguments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypeArgsOfType"));
            }
            return list;
        }
        List<List<TypeProjectionAndVariance>> typeArgumentsFromSuper = SignaturesPropagationData.calculateTypeArgumentsFromSuper((ClassDescriptor)classifier2, typesFromSuper);
        ArrayList<TypeProjection> resultArguments = Lists.newArrayList();
        for (TypeParameterDescriptor parameter : classifier2.getTypeConstructor().getParameters()) {
            TypeProjection argument = autoArguments.get(parameter.getIndex());
            JetType argumentType = argument.getType();
            List<TypeProjectionAndVariance> projectionsFromSuper = typeArgumentsFromSuper.get(parameter.getIndex());
            List<TypeAndVariance> argTypesFromSuper = SignaturesPropagationData.getTypes(projectionsFromSuper);
            JetType type2 = this.modifyTypeAccordingToSuperMethods(argumentType, argTypesFromSuper, TypeUsage.TYPE_ARGUMENT);
            Variance projectionKind = this.calculateArgumentProjectionKindFromSuper(argument, projectionsFromSuper);
            resultArguments.add(new TypeProjectionImpl(projectionKind, type2));
        }
        ArrayList<TypeProjection> arrayList = resultArguments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypeArgsOfType"));
        }
        return arrayList;
    }

    private Variance calculateArgumentProjectionKindFromSuper(@NotNull TypeProjection argument, @NotNull List<TypeProjectionAndVariance> projectionsFromSuper) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "calculateArgumentProjectionKindFromSuper"));
        }
        if (projectionsFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionsFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "calculateArgumentProjectionKindFromSuper"));
        }
        if (projectionsFromSuper.isEmpty()) {
            return argument.getProjectionKind();
        }
        LinkedHashSet<Variance> projectionKindsInSuper = Sets.newLinkedHashSet();
        for (TypeProjectionAndVariance projectionAndVariance : projectionsFromSuper) {
            projectionKindsInSuper.add(projectionAndVariance.typeProjection.getProjectionKind());
        }
        Variance defaultProjectionKind = argument.getProjectionKind();
        if (projectionKindsInSuper.size() == 0) {
            return defaultProjectionKind;
        }
        if (projectionKindsInSuper.size() == 1) {
            Variance projectionKindInSuper = (Variance)((Object)projectionKindsInSuper.iterator().next());
            if (defaultProjectionKind == Variance.INVARIANT || defaultProjectionKind == projectionKindInSuper) {
                return projectionKindInSuper;
            }
            this.reportError("Incompatible projection kinds in type arguments of super methods' return types: " + projectionsFromSuper + ", defined in current: " + argument);
            return defaultProjectionKind;
        }
        this.reportError("Incompatible projection kinds in type arguments of super methods' return types: " + projectionsFromSuper);
        return defaultProjectionKind;
    }

    @NotNull
    private static List<TypeAndVariance> getTypes(@NotNull List<TypeProjectionAndVariance> projections) {
        if (projections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projections", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypes"));
        }
        ArrayList<TypeAndVariance> types = Lists.newArrayList();
        for (TypeProjectionAndVariance projection : projections) {
            types.add(new TypeAndVariance(projection.typeProjection.getType(), SignaturesPropagationData.merge(projection.varianceOfPosition, projection.typeProjection.getProjectionKind())));
        }
        ArrayList<TypeAndVariance> arrayList = types;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "getTypes"));
        }
        return arrayList;
    }

    private static Variance merge(Variance positionOfOuter, Variance projectionKind) {
        if (positionOfOuter == Variance.INVARIANT) {
            return Variance.INVARIANT;
        }
        if (projectionKind == Variance.INVARIANT) {
            return positionOfOuter;
        }
        return positionOfOuter.superpose(projectionKind);
    }

    private static List<List<TypeProjectionAndVariance>> calculateTypeArgumentsFromSuper(@NotNull ClassDescriptor klass, @NotNull Collection<TypeAndVariance> typesFromSuper) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "calculateTypeArgumentsFromSuper"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "calculateTypeArgumentsFromSuper"));
        }
        Multimap<TypeConstructor, TypeProjection> substitution = SubstitutionUtils.buildDeepSubstitutionMultimap(TypeUtils.makeUnsubstitutedType(klass, ErrorUtils.createErrorScope("Do not access this scope", true)));
        ArrayList<List<TypeProjectionAndVariance>> parameterToArgumentsFromSuper = Lists.newArrayList();
        for (TypeParameterDescriptor ignored : klass.getTypeConstructor().getParameters()) {
            parameterToArgumentsFromSuper.add(new ArrayList());
        }
        for (TypeAndVariance typeFromSuper : typesFromSuper) {
            for (TypeParameterDescriptor parameter : typeFromSuper.type.getConstructor().getParameters()) {
                TypeProjection argument = typeFromSuper.type.getArguments().get(parameter.getIndex());
                for (TypeProjection projection : substitution.get(parameter.getTypeConstructor())) {
                    ClassifierDescriptor classifier2 = projection.getType().getConstructor().getDeclarationDescriptor();
                    if (!(classifier2 instanceof TypeParameterDescriptor) || classifier2.getContainingDeclaration() != klass) continue;
                    int parameterIndex = ((TypeParameterDescriptor)classifier2).getIndex();
                    Variance effectiveVariance = parameter.getVariance().superpose(typeFromSuper.varianceOfPosition);
                    ((List)parameterToArgumentsFromSuper.get(parameterIndex)).add(new TypeProjectionAndVariance(argument, effectiveVariance));
                }
            }
        }
        return parameterToArgumentsFromSuper;
    }

    private boolean typeMustBeNullable(@NotNull JetType autoType, @NotNull List<TypeAndVariance> typesFromSuper, @NotNull TypeUsage howThisTypeIsUsed) {
        if (autoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "typeMustBeNullable"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "typeMustBeNullable"));
        }
        if (howThisTypeIsUsed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "howThisTypeIsUsed", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "typeMustBeNullable"));
        }
        boolean someSupersNotCovariantNullable = false;
        boolean someSupersCovariantNullable = false;
        boolean someSupersNotNull = false;
        for (TypeAndVariance typeFromSuper : typesFromSuper) {
            if (!TypeUtils.isNullableType(typeFromSuper.type)) {
                someSupersNotNull = true;
                continue;
            }
            if (typeFromSuper.varianceOfPosition == Variance.OUT_VARIANCE) {
                someSupersCovariantNullable = true;
                continue;
            }
            someSupersNotCovariantNullable = true;
        }
        if (someSupersNotNull && someSupersNotCovariantNullable) {
            this.reportError("Incompatible types in superclasses: " + typesFromSuper);
            return TypeUtils.isNullableType(autoType);
        }
        if (someSupersNotNull) {
            return false;
        }
        if (someSupersNotCovariantNullable || someSupersCovariantNullable) {
            boolean annotatedAsNotNull;
            boolean bl = annotatedAsNotNull = howThisTypeIsUsed != TypeUsage.TYPE_ARGUMENT && !TypeUtils.isNullableType(autoType);
            if (annotatedAsNotNull && someSupersNotCovariantNullable) {
                DescriptorRenderer renderer = DescriptorRenderer.SHORT_NAMES_IN_TYPES;
                this.reportError("In superclass type is nullable: " + typesFromSuper + ", in subclass it is not: " + renderer.renderType(autoType));
                return true;
            }
            return !annotatedAsNotNull;
        }
        return TypeUtils.isNullableType(autoType);
    }

    @NotNull
    private ClassifierDescriptor modifyTypeClassifier(@NotNull JetType autoType, @NotNull List<TypeAndVariance> typesFromSuper) {
        ClassifierDescriptor fixed;
        if (autoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
        }
        if (typesFromSuper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesFromSuper", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
        }
        ClassifierDescriptor classifier2 = autoType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            assert (classifier2 != null) : "no declaration descriptor for type " + autoType + ", auto method descriptor: " + this.autoMethodDescriptor;
            if (classifier2 instanceof TypeParameterDescriptor && this.autoTypeParameterToModified.containsKey(classifier2)) {
                ClassifierDescriptor classifierDescriptor = this.autoTypeParameterToModified.get(classifier2);
                if (classifierDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
                }
                return classifierDescriptor;
            }
            ClassifierDescriptor classifierDescriptor = classifier2;
            if (classifierDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
            }
            return classifierDescriptor;
        }
        ClassDescriptor klass = (ClassDescriptor)classifier2;
        boolean someSupersMutable = false;
        boolean someSupersCovariantReadOnly = false;
        boolean someSupersNotCovariantReadOnly = false;
        for (TypeAndVariance typeFromSuper : typesFromSuper) {
            ClassifierDescriptor classifierFromSuper = typeFromSuper.type.getConstructor().getDeclarationDescriptor();
            if (!(classifierFromSuper instanceof ClassDescriptor)) continue;
            ClassDescriptor classFromSuper = (ClassDescriptor)classifierFromSuper;
            if (JavaToKotlinClassMap.INSTANCE.isMutableCollection(classFromSuper)) {
                someSupersMutable = true;
                continue;
            }
            if (!JavaToKotlinClassMap.INSTANCE.isReadOnlyCollection(classFromSuper)) continue;
            if (typeFromSuper.varianceOfPosition == Variance.OUT_VARIANCE) {
                someSupersCovariantReadOnly = true;
                continue;
            }
            someSupersNotCovariantReadOnly = true;
        }
        if (someSupersMutable && someSupersNotCovariantReadOnly) {
            this.reportError("Incompatible types in superclasses: " + typesFromSuper);
            ClassifierDescriptor classifierDescriptor = classifier2;
            if (classifierDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
            }
            return classifierDescriptor;
        }
        if (someSupersMutable) {
            if (JavaToKotlinClassMap.INSTANCE.isReadOnlyCollection(klass)) {
                ClassDescriptor classDescriptor = JavaToKotlinClassMap.INSTANCE.convertReadOnlyToMutable(klass);
                if (classDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
                }
                return classDescriptor;
            }
        } else if ((someSupersNotCovariantReadOnly || someSupersCovariantReadOnly) && JavaToKotlinClassMap.INSTANCE.isMutableCollection(klass)) {
            ClassDescriptor classDescriptor = JavaToKotlinClassMap.INSTANCE.convertMutableToReadOnly(klass);
            if (classDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
            }
            return classDescriptor;
        }
        ClassifierDescriptor classifierDescriptor = (fixed = PropagationHeuristics.tryToFixOverridingTWithRawType(this, typesFromSuper)) != null ? fixed : classifier2;
        if (classifierDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "modifyTypeClassifier"));
        }
        return classifierDescriptor;
    }

    private static boolean isArrayType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData", "isArrayType"));
        }
        return KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2);
    }

    private static class ValueParameters {
        private final JetType receiverType;
        private final List<ValueParameterDescriptor> descriptors;
        private final boolean hasStableParameterNames;

        public ValueParameters(@Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> descriptors, boolean hasStableParameterNames) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/SignaturesPropagationData$ValueParameters", "<init>"));
            }
            this.receiverType = receiverType;
            this.descriptors = descriptors;
            this.hasStableParameterNames = hasStableParameterNames;
        }
    }

    private static class TypeAndName {
        public final JetType type;
        public final Name name;

        public TypeAndName(JetType type2, Name name) {
            this.type = type2;
            this.name = name;
        }
    }

    static class TypeAndVariance {
        public final JetType type;
        public final Variance varianceOfPosition;

        public TypeAndVariance(JetType type2, Variance varianceOfPosition) {
            this.type = type2;
            this.varianceOfPosition = varianceOfPosition;
        }

        public String toString() {
            return this.type.toString();
        }
    }

    private static class TypeProjectionAndVariance {
        public final TypeProjection typeProjection;
        public final Variance varianceOfPosition;

        public TypeProjectionAndVariance(TypeProjection typeProjection, Variance varianceOfPosition) {
            this.typeProjection = typeProjection;
            this.varianceOfPosition = varianceOfPosition;
        }

        public String toString() {
            return this.typeProjection.toString();
        }
    }

    private static class VarargCheckResult {
        public final JetType parameterType;
        public final boolean isVararg;

        public VarargCheckResult(JetType parameterType, boolean isVararg) {
            this.parameterType = parameterType;
            this.isVararg = isVararg;
        }
    }
}

