/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    private static final Logger LOG = Logger.getInstance(PropertiesUtil.class);
    public static final Pattern LOCALE_PATTERN = Pattern.compile("(_[a-zA-Z]{2,8}(_[a-zA-Z]{2}|[0-9]{3})?(_[\\w\\-]+)?)\\.[^_]+$");
    public static final Set<Character> BASE_NAME_BORDER_CHAR = ContainerUtil.newHashSet((Object[])new Character[]{Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.')});
    public static final Locale DEFAULT_LOCALE = new Locale("", "", "");
    private static final SoftLazyValue<Set<String>> LOCALES_LANGUAGE_CODES = new SoftLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            HashSet locales = new HashSet((Collection)ContainerUtil.flatten((Iterable)ContainerUtil.map((Object[])Locale.getAvailableLocales(), (Function)new Function<Locale, List<String>>(){

                public List<String> fun(Locale locale) {
                    return ContainerUtil.newArrayList((Object[])new String[]{locale.getLanguage(), locale.getISO3Language()});
                }
            })));
            locales.addAll((Collection)ContainerUtil.newArrayList((Object[])Locale.getISOLanguages()));
            HashSet hashSet = locales;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil$1", "compute"));
            }
            return hashSet;
        }
    };

    @Deprecated
    public static boolean isPropertyComplete(Project project, ResourceBundle resourceBundle, String propertyName) {
        return PropertiesUtil.isPropertyComplete(resourceBundle, propertyName);
    }

    public static boolean isPropertyComplete(ResourceBundle resourceBundle, String propertyName) {
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            if (propertiesFile.findPropertyByKey(propertyName) != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static String getDefaultBaseName(Collection<PropertiesFile> files) {
        String commonPrefix = null;
        for (PropertiesFile file : files) {
            String baseName = file.getVirtualFile().getNameWithoutExtension();
            if (commonPrefix == null) {
                commonPrefix = baseName;
                continue;
            }
            if (!(commonPrefix = StringUtil.commonPrefix((String)commonPrefix, (String)baseName)).isEmpty()) continue;
            break;
        }
        assert (commonPrefix != null);
        if (!commonPrefix.isEmpty() && BASE_NAME_BORDER_CHAR.contains(Character.valueOf(commonPrefix.charAt(commonPrefix.length() - 1)))) {
            commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
        }
        String string = commonPrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultBaseName(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
        }
        String name = file.getName();
        if (!StringUtil.containsChar((String)name, (char)'_')) {
            String string = FileUtil.getNameWithoutExtension((String)name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
            }
            return string;
        }
        Matcher matcher = LOCALE_PATTERN.matcher(name);
        int matchIndex = 0;
        while (matcher.find(matchIndex)) {
            MatchResult matchResult = matcher.toMatchResult();
            String[] splitted = matchResult.group(1).split("_");
            if (splitted.length <= 1) continue;
            String langCode = splitted[1];
            if (!((Set)LOCALES_LANGUAGE_CODES.getValue()).contains(langCode)) {
                matchIndex = matchResult.start(1) + 1;
                continue;
            }
            String baseNameWithExtension = name.substring(0, matchResult.start(1)) + name.substring(matchResult.end(1));
            String string = FileUtil.getNameWithoutExtension((String)baseNameWithExtension);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
            }
            return string;
        }
        String baseNameWithExtension = name;
        String string = FileUtil.getNameWithoutExtension((String)baseNameWithExtension);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getDefaultBaseName"));
        }
        return string;
    }

    @NotNull
    public static Locale getLocale(@NotNull PropertiesFile propertiesFile) {
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "com/intellij/lang/properties/PropertiesUtil", "getLocale"));
        }
        String name = propertiesFile.getName();
        if (!StringUtil.containsChar((String)name, (char)'_')) {
            Locale locale = DEFAULT_LOCALE;
            if (locale == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getLocale"));
            }
            return locale;
        }
        String containingResourceBundleBaseName = propertiesFile.getResourceBundle().getBaseName();
        LOG.assertTrue(name.startsWith(containingResourceBundleBaseName));
        Locale locale = PropertiesUtil.getLocale(name.substring(containingResourceBundleBaseName.length()));
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getLocale"));
        }
        return locale;
    }

    public static Locale getLocale(String suffix) {
        String rawLocale;
        String[] splittedRawLocale;
        Matcher matcher = LOCALE_PATTERN.matcher(suffix);
        if (matcher.find() && (splittedRawLocale = (rawLocale = matcher.group(1)).split("_")).length > 1 && splittedRawLocale[1].length() >= 2) {
            String language = splittedRawLocale[1];
            String country = splittedRawLocale.length > 2 ? splittedRawLocale[2] : "";
            String variant = splittedRawLocale.length > 3 ? splittedRawLocale[3] : "";
            return new Locale(language, country, variant);
        }
        return DEFAULT_LOCALE;
    }

    @Nullable
    public static PropertiesFile getParent(PropertiesFile file, List<PropertiesFile> candidates) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String name = virtualFile.getNameWithoutExtension();
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return null;
        }
        List<String> partsList = Arrays.asList(parts);
        for (int i = parts.length - 1; i >= 1; --i) {
            String parentName = StringUtil.join(partsList.subList(0, i), (String)"_") + "." + virtualFile.getExtension();
            for (PropertiesFile candidate : candidates) {
                if (!parentName.equals(candidate.getName())) continue;
                return candidate;
            }
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static List<IProperty> findAllProperties(Project project, @NotNull ResourceBundle resourceBundle, String key) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        return smartList;
    }

    public static List<IProperty> findAllProperties(@NotNull ResourceBundle resourceBundle, String key) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceBundle", "com/intellij/lang/properties/PropertiesUtil", "findAllProperties"));
        }
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        return result;
    }

    public static boolean isUnescapedBackSlashAtTheEnd(String text) {
        boolean result = false;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            result = !result;
        }
        return result;
    }

    @Nullable
    public static String getPackageQualifiedName(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/lang/properties/PropertiesUtil", "getPackageQualifiedName"));
        }
        return ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex().getPackageNameByDirectory(directory.getVirtualFile());
    }

    @NotNull
    public static String getPresentableLocale(@NotNull Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/intellij/lang/properties/PropertiesUtil", "getPresentableLocale"));
        }
        ArrayList<String> names = new ArrayList<String>();
        if (!Comparing.strEqual((String)locale.getDisplayLanguage(), null)) {
            names.add(locale.getDisplayLanguage());
        }
        if (!Comparing.strEqual((String)locale.getDisplayCountry(), null)) {
            names.add(locale.getDisplayCountry());
        }
        if (!Comparing.strEqual((String)locale.getDisplayVariant(), null)) {
            names.add(locale.getDisplayVariant());
        }
        String string = names.isEmpty() ? "" : " (" + StringUtil.join(names, (String)"/") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesUtil", "getPresentableLocale"));
        }
        return string;
    }
}

