/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlPropertiesFileImpl
extends XmlPropertiesFile {
    private static final Key<CachedValue<PropertiesFile>> KEY = Key.create((String)"xml properties file");
    private final XmlFile myFile;
    private final SoftLazyValue<Info> myInfo = new SoftLazyValue<Info>(){

        @NotNull
        protected Info compute() {
            Info info = new Info();
            if (info == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl$1", "compute"));
            }
            return info;
        }
    };

    private XmlPropertiesFileImpl(XmlFile file) {
        this.myFile = file;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getContainingFile"));
        }
        return xmlFile;
    }

    @Override
    @NotNull
    public List<IProperty> getProperties() {
        ArrayList<IProperty> arrayList = new ArrayList<IProperty>(((Info)this.myInfo.getValue()).getPropertiesMap().values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getProperties"));
        }
        return arrayList;
    }

    @Override
    public IProperty findPropertyByKey(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "findPropertyByKey"));
        }
        Collection properties = ((Info)this.myInfo.getValue()).getPropertiesMap().get((Object)key);
        return properties.isEmpty() ? null : (IProperty)properties.iterator().next();
    }

    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "findPropertiesByKey"));
        }
        ArrayList<IProperty> arrayList = new ArrayList<IProperty>(((Info)this.myInfo.getValue()).getPropertiesMap().get((Object)key));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "findPropertiesByKey"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = PropertiesImplUtil.getResourceBundle(this);
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getResourceBundle"));
        }
        return resourceBundle;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = PropertiesUtil.getLocale(this);
        if (locale == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getLocale"));
        }
        return locale;
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addProperty"));
        }
        PsiElement psiElement = this.addProperty(property.getKey(), property.getValue()).getPsiElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addProperty"));
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull IProperty property, @Nullable IProperty anchor) throws IncorrectOperationException {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addPropertyAfter"));
        }
        PsiElement psiElement = this.addPropertyAfter(property.getKey(), property.getValue(), anchor).getPsiElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addPropertyAfter"));
        }
        return psiElement;
    }

    @Override
    public IProperty addPropertyAfter(String key, String value, IProperty anchor) {
        return this.addPropertyAfterAndCheckAlphaSorting(key, value, anchor, true, true);
    }

    @NotNull
    public IProperty addPropertyAfterAndCheckAlphaSorting(String key, String value, @Nullable IProperty anchor, boolean addToEnd, boolean checkAlphaSorting) {
        XmlTag anchorTag = anchor == null ? null : (XmlTag)anchor.getPsiElement();
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = this.createPropertyTag(key, value);
        XmlTag addedEntry = (XmlTag)(anchorTag == null ? this.myFile.getRootTag().addSubTag(entry, !addToEnd) : rootTag.addAfter((PsiElement)entry, (PsiElement)anchorTag));
        XmlProperty property = new XmlProperty(addedEntry, this);
        ((Info)this.myInfo.getValue()).getPropertiesMap().putValue((Object)key, (Object)property);
        if (checkAlphaSorting) {
            this.checkAlphaSorting(property);
        }
        XmlProperty xmlProperty = property;
        if (xmlProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addPropertyAfterAndCheckAlphaSorting"));
        }
        return xmlProperty;
    }

    @Override
    @NotNull
    public IProperty addProperty(String key, String value) {
        XmlTag entry = this.createPropertyTag(key, value);
        if (((Info)this.myInfo.getValue()).isSorted()) {
            IProperty inserted;
            XmlProperty dummyProperty = new XmlProperty(entry, this);
            int insertIndex = Collections.binarySearch(((Info)this.myInfo.getValue()).getPropertiesOrder(), dummyProperty, new Comparator<IProperty>(){

                @Override
                public int compare(IProperty p1, IProperty p2) {
                    String k1 = p1.getKey();
                    String k2 = p2.getKey();
                    return k1.compareTo(k2);
                }
            });
            if (insertIndex == -1) {
                inserted = this.addPropertyAfterAndCheckAlphaSorting(key, value, null, false, false);
                ((Info)this.myInfo.getValue()).getPropertiesOrder().add(0, inserted);
            } else {
                int position = insertIndex < 0 ? -insertIndex - 2 : insertIndex;
                IProperty insertPosition = ((Info)this.myInfo.getValue()).getPropertiesOrder().get(position);
                inserted = this.addPropertyAfterAndCheckAlphaSorting(key, value, insertPosition, false, false);
                ((Info)this.myInfo.getValue()).getPropertiesOrder().add(position + 1, inserted);
            }
            IProperty iProperty = inserted;
            if (iProperty == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addProperty"));
            }
            return iProperty;
        }
        IProperty iProperty = this.addPropertyAfterAndCheckAlphaSorting(key, value, null, true, false);
        if (iProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "addProperty"));
        }
        return iProperty;
    }

    private XmlTag createPropertyTag(String key, String value) {
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = rootTag.createChildTag("entry", "", value, false);
        entry.setAttribute("key", key);
        return entry;
    }

    public static PropertiesFile getPropertiesFile(final PsiFile file) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        if (file instanceof XmlFile) {
            return (PropertiesFile)manager.getCachedValue((UserDataHolder)file, KEY, (CachedValueProvider)new CachedValueProvider<PropertiesFile>(){

                public CachedValueProvider.Result<PropertiesFile> compute() {
                    XmlPropertiesFileImpl value = XmlPropertiesIndex.isPropertiesFile((XmlFile)file) ? new XmlPropertiesFileImpl((XmlFile)file) : null;
                    return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{file});
                }
            }, false);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/xml/XmlPropertiesFileImpl", "getNamesMap"));
        }
        return tHashMap;
    }

    @Override
    public String getName() {
        return this.getContainingFile().getName();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getContainingFile().getVirtualFile();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingFile().getParent();
    }

    @Override
    public Project getProject() {
        return this.getContainingFile().getProject();
    }

    @Override
    public String getText() {
        return this.getContainingFile().getText();
    }

    @Override
    public boolean isAlphaSorted() {
        return ((Info)this.myInfo.getValue()).isSorted();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlPropertiesFileImpl that = (XmlPropertiesFileImpl)o;
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    private void checkAlphaSorting(IProperty property) {
        if (((Info)this.myInfo.getValue()).isSorted()) {
            String prevKey;
            String key = property.getKey();
            XmlTag prev = XmlPropertiesFileImpl.getSibling((XmlTag)property.getPsiElement(), true);
            String string = prevKey = prev == null ? null : new XmlProperty(prev, this).getKey();
            if (prevKey != null && key != null && prevKey.compareTo(key) > 0) {
                ((Info)this.myInfo.getValue()).setSorted(false);
            } else {
                String nextKey;
                XmlTag next = XmlPropertiesFileImpl.getSibling((XmlTag)property.getPsiElement(), false);
                String string2 = nextKey = next == null ? null : new XmlProperty(next, this).getKey();
                if (nextKey != null && key != null && nextKey.compareTo(key) < 0) {
                    ((Info)this.myInfo.getValue()).setSorted(false);
                }
            }
        }
    }

    private static XmlTag getSibling(XmlTag entry, boolean prev) {
        XmlTag sibling = (XmlTag)(prev ? entry.getPrevSibling() : entry.getNextSibling());
        while (sibling != null && !"entry".equals(sibling.getName())) {
            sibling = (XmlTag)(prev ? sibling.getPrevSibling() : sibling.getNextSibling());
        }
        return sibling;
    }

    private class Info {
        private final MultiMap<String, IProperty> myPropertiesMap = MultiMap.create();
        private List<IProperty> myPropertiesOrder;
        private boolean mySorted;

        public Info() {
            XmlTag rootTag = XmlPropertiesFileImpl.this.myFile.getRootTag();
            ArrayList<IProperty> propertiesOrder = new ArrayList<IProperty>();
            if (rootTag != null) {
                XmlTag[] entries;
                for (XmlTag entry : entries = rootTag.findSubTags("entry")) {
                    XmlProperty property = new XmlProperty(entry, XmlPropertiesFileImpl.this);
                    propertiesOrder.add(property);
                    this.myPropertiesMap.putValue((Object)property.getKey(), (Object)property);
                }
            }
            this.mySorted = PropertiesImplUtil.isAlphaSorted(propertiesOrder);
            this.myPropertiesOrder = this.mySorted ? propertiesOrder : null;
        }

        public void setSorted(boolean sorted) {
            this.mySorted = sorted;
            this.myPropertiesOrder = null;
        }

        public MultiMap<String, IProperty> getPropertiesMap() {
            return this.myPropertiesMap;
        }

        public List<IProperty> getPropertiesOrder() {
            return this.myPropertiesOrder;
        }

        public boolean isSorted() {
            return this.mySorted;
        }
    }
}

