/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVPropertiesHandler
extends BasicDAVHandler {
    private static final Set PROP_ELEMENTS = new SVNHashSet();
    private DAVProperties myCurrentResource;
    private int myStatusCode;
    private String myEncoding;
    private Map myResources;
    private Map myCurrentProperties;

    public static StringBuffer generatePropertiesRequest(StringBuffer xmlBuffer, DAVElement[] properties) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag(null, "propfind", DAV_NAMESPACES_LIST, null, xmlBuffer);
        if (properties != null) {
            xmlBuffer.append("<prop>");
            for (int i = 0; i < properties.length; ++i) {
                SVNXMLUtil.openXMLTag(null, properties[i].getName(), 4, "xmlns", properties[i].getNamespace(), xmlBuffer);
            }
            SVNXMLUtil.closeXMLTag(null, "prop", xmlBuffer);
        } else {
            SVNXMLUtil.openXMLTag(null, "allprop", 4, null, xmlBuffer);
        }
        SVNXMLUtil.addXMLFooter(null, "propfind", xmlBuffer);
        return xmlBuffer;
    }

    public DAVPropertiesHandler() {
        this.init();
    }

    public Map getDAVProperties() {
        return this.myResources;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == DAVElement.RESPONSE) {
            if (this.myCurrentResource != null) {
                this.invalidXML();
            }
            this.myCurrentResource = new DAVProperties();
            this.myCurrentProperties = new SVNHashMap();
            this.myStatusCode = 0;
        } else if (element == DAVElement.PROPSTAT) {
            this.myStatusCode = 0;
        } else if (element == DAVElement.COLLECTION) {
            this.myCurrentResource.setCollection(true);
        } else {
            this.myEncoding = attrs.getValue("http://subversion.tigris.org/xmlns/dav/", "encoding");
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        DAVElement name = null;
        SVNPropertyValue value = null;
        if (this.myCurrentProperties == null) {
            this.invalidXML();
        }
        if (element == DAVElement.RESPONSE) {
            if (this.myCurrentResource.getURL() == null) {
                this.invalidXML();
            }
            this.myResources.put(this.myCurrentResource.getURL(), this.myCurrentResource);
            this.myCurrentResource = null;
            return;
        }
        if (element == DAVElement.PROPSTAT) {
            if (this.myStatusCode != 0) {
                for (Map.Entry entry : this.myCurrentProperties.entrySet()) {
                    DAVElement propName = (DAVElement)entry.getKey();
                    SVNPropertyValue propValue = (SVNPropertyValue)entry.getValue();
                    if (this.myStatusCode != 200) continue;
                    this.myCurrentResource.setProperty(propName, propValue);
                }
                this.myCurrentProperties.clear();
            } else {
                this.invalidXML();
            }
            return;
        }
        if (element == DAVElement.STATUS) {
            if (cdata == null) {
                this.invalidXML();
            }
            try {
                HTTPStatus status = HTTPStatus.createHTTPStatus(cdata.toString());
                if (status == null) {
                    this.invalidXML();
                }
                this.myStatusCode = status.getCode();
            }
            catch (ParseException e) {
                this.invalidXML();
            }
            return;
        }
        if (element == DAVElement.HREF) {
            if (parent == DAVElement.RESPONSE) {
                String path = cdata.toString();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                this.myCurrentResource.setURL(path);
                return;
            }
            name = parent;
            if (name == null) {
                return;
            }
            value = SVNPropertyValue.create(cdata.toString());
        } else if (cdata != null) {
            if (this.myCurrentProperties.containsKey(element)) {
                return;
            }
            name = element;
            String propertyName = DAVUtil.getPropertyNameByElement(name);
            value = this.createPropertyValue(name, propertyName, cdata, this.myEncoding);
            this.myEncoding = null;
        }
        if (name != null && value != null) {
            this.myCurrentProperties.put(name, value);
        }
    }

    public void setDAVProperties(Map result) {
        this.myResources = result;
    }

    static {
        PROP_ELEMENTS.add(DAVElement.HREF);
        PROP_ELEMENTS.add(DAVElement.STATUS);
        PROP_ELEMENTS.add(DAVElement.BASELINE);
        PROP_ELEMENTS.add(DAVElement.BASELINE_COLLECTION);
        PROP_ELEMENTS.add(DAVElement.COLLECTION);
        PROP_ELEMENTS.add(DAVElement.VERSION_NAME);
        PROP_ELEMENTS.add(DAVElement.GET_CONTENT_LENGTH);
        PROP_ELEMENTS.add(DAVElement.CREATION_DATE);
        PROP_ELEMENTS.add(DAVElement.CREATOR_DISPLAY_NAME);
        PROP_ELEMENTS.add(DAVElement.BASELINE_RELATIVE_PATH);
        PROP_ELEMENTS.add(DAVElement.MD5_CHECKSUM);
        PROP_ELEMENTS.add(DAVElement.REPOSITORY_UUID);
    }
}

