/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrThrowsClauseImpl
extends GroovyPsiElementImpl
implements GrThrowsClause {
    public GrThrowsClauseImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrThrowsClauseImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitThrowsClause(this);
    }

    public String toString() {
        return "Throw clause";
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiClassType[] types = this.getReferencedTypes();
        if (types.length == 0) {
            if (PsiJavaCodeReferenceElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrThrowsClauseImpl", "getReferenceElements"));
            }
            return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
        }
        PsiManagerEx manager = this.getManager();
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClassType type : types) {
            PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
            PsiClass resolved = resolveResult.getElement();
            if (resolved == null) continue;
            result.add(new LightClassReference((PsiManager)manager, type.getCanonicalText(), resolved, resolveResult.getSubstitutor()));
        }
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = result.toArray(new PsiJavaCodeReferenceElement[result.size()]);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrThrowsClauseImpl", "getReferenceElements"));
        }
        return psiJavaCodeReferenceElementArray;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        ArrayList<GrCodeReferenceElement> refs = new ArrayList<GrCodeReferenceElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrCodeReferenceElement)) continue;
            refs.add((GrCodeReferenceElement)cur);
        }
        if (refs.isEmpty()) {
            if (PsiClassType.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrThrowsClauseImpl", "getReferencedTypes"));
            }
            return PsiClassType.EMPTY_ARRAY;
        }
        PsiClassType[] result = new PsiClassType[refs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new GrClassReferenceType((GrReferenceElement)refs.get(i));
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrThrowsClauseImpl", "getReferencedTypes"));
        }
        return result;
    }

    public PsiReferenceList.Role getRole() {
        return PsiReferenceList.Role.THROWS_LIST;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/GrThrowsClauseImpl", "add"));
        }
        if (element instanceof GrCodeReferenceElement || element instanceof PsiJavaCodeReferenceElement) {
            if (this.findChildByClass(GrCodeReferenceElement.class) == null) {
                this.getNode().addLeaf(GroovyTokenTypes.kTHROWS, (CharSequence)"throws", null);
            } else {
                PsiElement lastChild = this.getLastChild();
                if (!(lastChild = PsiUtil.skipWhitespacesAndComments(lastChild, false)).getNode().getElementType().equals(GroovyTokenTypes.mCOMMA)) {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
                }
            }
            if (element instanceof PsiJavaCodeReferenceElement) {
                element = GroovyPsiElementFactory.getInstance(this.getProject()).createCodeReferenceElementFromText(element.getText());
            }
        }
        return super.add(element);
    }
}

