/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFieldBuilder
extends LightVariableBuilder<LightFieldBuilder>
implements PsiField {
    private PsiClass myContainingClass;
    private PsiExpression myInitializer;
    private PsiDocComment myDocComment;
    private boolean myIsDeprecated;

    public LightFieldBuilder(@NotNull String name, @NotNull String type2, @NotNull PsiElement navigationElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        super(name, JavaPsiFacade.getElementFactory(navigationElement.getProject()).createTypeFromText(type2, navigationElement), navigationElement);
        this.myContainingClass = null;
        this.myInitializer = null;
        this.myDocComment = null;
        this.myIsDeprecated = false;
    }

    public LightFieldBuilder(@NotNull String name, @NotNull PsiType type2, @NotNull PsiElement navigationElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        super(name, type2, navigationElement);
        this.myContainingClass = null;
        this.myInitializer = null;
        this.myDocComment = null;
        this.myIsDeprecated = false;
    }

    public LightFieldBuilder(PsiManager manager, @NotNull String name, @NotNull PsiType type2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightFieldBuilder", "<init>"));
        }
        super(manager, name, type2, JavaLanguage.INSTANCE);
        this.myContainingClass = null;
        this.myInitializer = null;
        this.myDocComment = null;
        this.myIsDeprecated = false;
    }

    public LightFieldBuilder setContainingClass(PsiClass psiClass) {
        this.myContainingClass = psiClass;
        return this;
    }

    @Override
    public void setInitializer(@Nullable PsiExpression initializer) throws IncorrectOperationException {
        this.myInitializer = initializer;
    }

    @Override
    public PsiExpression getInitializer() {
        return this.myInitializer;
    }

    @Override
    public PsiDocComment getDocComment() {
        return this.myDocComment;
    }

    public LightFieldBuilder setDocComment(PsiDocComment docComment) {
        this.myDocComment = docComment;
        return this;
    }

    @Override
    public boolean isDeprecated() {
        return this.myIsDeprecated;
    }

    public LightFieldBuilder setIsDeprecated(boolean isDeprecated) {
        this.myIsDeprecated = isDeprecated;
        return this;
    }

    @Override
    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        if (!(another instanceof PsiField)) {
            return false;
        }
        if (!((PsiField)another).getName().equals(this.getName())) {
            return false;
        }
        if (this.hasModifierProperty("static") != ((PsiField)another).hasModifierProperty("static")) {
            return false;
        }
        PsiClass containingClass = this.getContainingClass();
        PsiClass anotherClass = ((PsiField)another).getContainingClass();
        return containingClass == null && anotherClass == null || this.getManager().areElementsEquivalent(containingClass, anotherClass);
    }
}

