/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedNotationConverter<N, T>
implements NotationConverter<Object, T> {
    private final Class<N> typeToken;

    public TypedNotationConverter(Class<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken;
    }

    public TypedNotationConverter(TypeInfo<N> typeToken) {
        assert (typeToken != null) : "typeToken cannot be null";
        this.typeToken = typeToken.getTargetType();
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate(String.format("Instances of %s.", this.typeToken.getSimpleName()));
    }

    @Override
    public void convert(Object notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        if (this.typeToken.isInstance(notation)) {
            result.converted(this.parseType(this.typeToken.cast(notation)));
        }
    }

    protected abstract T parseType(N var1);
}

