/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsRegExp;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import org.jetbrains.annotations.NotNull;

class JsPrecedenceVisitor
extends JsVisitor {
    static final int PRECEDENCE_NEW = 15;
    private int answer = -1;

    private JsPrecedenceVisitor() {
    }

    public static int exec(JsExpression expression2) {
        JsPrecedenceVisitor visitor2 = new JsPrecedenceVisitor();
        visitor2.accept(expression2);
        if (visitor2.answer < 0) {
            throw new RuntimeException("Precedence must be >= 0!");
        }
        return visitor2.answer;
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitArrayAccess"));
        }
        this.answer = 16;
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitArray"));
        }
        this.answer = 17;
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitBinaryExpression"));
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitBoolean(@NotNull JsLiteral.JsBooleanLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitBoolean"));
        }
        this.answer = 17;
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitConditional"));
        }
        this.answer = 3;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitFunction"));
        }
        this.answer = 17;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitInvocation"));
        }
        this.answer = 16;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitNameRef"));
        }
        this.answer = nameRef.isLeaf() ? 17 : 16;
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitNew"));
        }
        this.answer = 15;
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitNull"));
        }
        this.answer = 17;
    }

    @Override
    public void visitInt(@NotNull JsNumberLiteral.JsIntLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitInt"));
        }
        this.answer = 17;
    }

    @Override
    public void visitDouble(@NotNull JsNumberLiteral.JsDoubleLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitDouble"));
        }
        this.answer = 17;
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitObjectLiteral"));
        }
        this.answer = 17;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitPostfixOperation"));
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitPrefixOperation"));
        }
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPropertyInitializer(@NotNull JsPropertyInitializer x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitPropertyInitializer"));
        }
        this.answer = 17;
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitRegExp"));
        }
        this.answer = 17;
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitString"));
        }
        this.answer = 17;
    }

    @Override
    public void visitThis(@NotNull JsLiteral.JsThisRef x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitThis"));
        }
        this.answer = 17;
    }

    @Override
    protected void visitElement(@NotNull JsNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/google/dart/compiler/backend/js/JsPrecedenceVisitor", "visitElement"));
        }
        throw new RuntimeException("Only expressions have precedence.");
    }
}

