/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsVisitorWithContextImpl
extends JsVisitorWithContext {
    private final Stack<JsContext<JsStatement>> statementContexts = new Stack();

    protected static void checkReplacement(JsNode origNode, JsNode newNode) {
        if (newNode == null) {
            throw new RuntimeException("Cannot replace with null");
        }
    }

    @Override
    protected <T extends JsNode> T doAccept(T node2) {
        return new NodeContext<T>().traverse(node2);
    }

    @Override
    protected JsExpression doAcceptLvalue(JsExpression expr) {
        return new LvalueContext().traverse(expr);
    }

    @Override
    protected <T extends JsStatement> JsStatement doAcceptStatement(T statement) {
        SmartList statements = new SmartList(statement);
        this.doAcceptStatementList((List<JsStatement>)statements);
        if (statements.size() == 1) {
            return (JsStatement)statements.get(0);
        }
        return new JsBlock((List<JsStatement>)statements);
    }

    @Override
    protected void doAcceptStatementList(List<JsStatement> statements) {
        ListContext<JsStatement> context2 = new ListContext<JsStatement>();
        this.statementContexts.push(context2);
        context2.traverse(statements);
        this.statementContexts.pop();
    }

    @Override
    protected <T extends JsNode> void doAcceptList(List<T> collection) {
        new ListContext<T>().traverse(collection);
    }

    @NotNull
    protected JsContext<JsStatement> getLastStatementLevelContext() {
        JsContext<JsStatement> jsContext = this.statementContexts.peek();
        if (jsContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsVisitorWithContextImpl", "getLastStatementLevelContext"));
        }
        return jsContext;
    }

    @Override
    protected <T extends JsNode> void doTraverse(T node2, JsContext ctx) {
        node2.traverse(this, ctx);
    }

    private class NodeContext<T extends JsNode>
    extends JsContext<T> {
        protected T node;

        private NodeContext() {
        }

        @Override
        public void removeMe() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R extends T> void replaceMe(R node2) {
            JsVisitorWithContextImpl.checkReplacement(this.node, node2);
            this.node = node2;
        }

        @Override
        @Nullable
        public T getCurrentNode() {
            return this.node;
        }

        protected T traverse(T node2) {
            this.node = node2;
            JsVisitorWithContextImpl.this.doTraverse(node2, this);
            return this.node;
        }
    }

    private class LvalueContext
    extends NodeContext<JsExpression> {
        private LvalueContext() {
        }
    }

    public class ListContext<T extends JsNode>
    extends JsContext<T> {
        private List<T> nodes;
        private int index;
        private final List<T> previous = new SmartList();
        private final List<T> next = new SmartList();
        private boolean removed = false;

        @Override
        public <R extends T> void addPrevious(R node2) {
            this.previous.add(node2);
        }

        @Override
        public <R extends T> void addNext(R node2) {
            this.next.add(node2);
        }

        @Override
        public void removeMe() {
            this.removed = true;
        }

        @Override
        public <R extends T> void replaceMe(R node2) {
            JsVisitorWithContextImpl.checkReplacement((JsNode)this.nodes.get(this.index), node2);
            this.nodes.set(this.index, node2);
            this.removed = false;
        }

        @Override
        @Nullable
        public T getCurrentNode() {
            if (!this.removed && this.index < this.nodes.size()) {
                return (T)((JsNode)this.nodes.get(this.index));
            }
            return null;
        }

        protected void traverse(List<T> nodes) {
            assert (this.previous.isEmpty()) : "addPrevious() was called before traverse()";
            assert (this.next.isEmpty()) : "addNext() was called before traverse()";
            this.nodes = nodes;
            this.index = 0;
            while (this.index < nodes.size()) {
                this.removed = false;
                this.previous.clear();
                this.next.clear();
                JsVisitorWithContextImpl.this.doTraverse(this.getCurrentNode(), this);
                if (!this.previous.isEmpty()) {
                    nodes.addAll(this.index, this.previous);
                    this.index += this.previous.size();
                }
                if (this.removed) {
                    nodes.remove(this.index);
                    --this.index;
                }
                if (!this.next.isEmpty()) {
                    nodes.addAll(this.index + 1, this.next);
                    this.index += this.next.size();
                }
                ++this.index;
            }
        }
    }
}

