/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.google.gwt.dev.js.rhino.IRFactory;
import com.google.gwt.dev.js.rhino.JavaScriptException;
import com.google.gwt.dev.js.rhino.Node;
import com.google.gwt.dev.js.rhino.TokenStream;
import java.io.IOException;
import java.util.Observable;
import org.jetbrains.kotlin.js.parser.ParserEvents;

public class Parser
extends Observable {
    private int lastExprEndLine;
    private IRFactory nf;
    private ErrorReporter er;
    private boolean ok;
    private int sourceTop;
    private int functionNumber;
    private final boolean insideFunction;

    public Parser(IRFactory nf, boolean insideFunction) {
        this.nf = nf;
        this.insideFunction = insideFunction;
    }

    private void mustMatchToken(TokenStream ts, int toMatch, String messageId) throws IOException, JavaScriptException {
        int tt = ts.getToken();
        if (tt != toMatch) {
            this.reportError(ts, messageId);
            ts.ungetToken(tt);
        }
    }

    private void reportError(TokenStream ts, String messageId) throws JavaScriptException {
        this.ok = false;
        ts.reportSyntaxError(messageId, null);
        throw new JavaScriptException((Object)messageId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object parse(TokenStream ts) throws IOException {
        this.ok = true;
        this.sourceTop = 0;
        this.functionNumber = 0;
        int baseLineno = ts.getLineno();
        Object tempBlock = this.nf.createLeaf(133);
        ((Node)tempBlock).setIsSyntheticBlock(true);
        while (true) {
            ts.flags |= 0x10;
            int tt = ts.getToken();
            ts.flags &= ~16;
            if (tt <= 0) break;
            if (tt == 110) {
                try {
                    this.nf.addChildToBack(tempBlock, this.function(ts, false));
                    continue;
                }
                catch (JavaScriptException e) {
                    this.ok = false;
                    break;
                }
            }
            ts.ungetToken(tt);
            this.nf.addChildToBack(tempBlock, this.statement(ts));
        }
        if (!this.ok) {
            return null;
        }
        Object pn = this.nf.createScript(tempBlock, ts.getSourceName(), baseLineno, ts.getLineno(), null);
        ((Node)pn).setIsSyntheticBlock(true);
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseFunctionBody(TokenStream ts) throws IOException {
        int oldflags = ts.flags;
        ts.flags &= 0xFFFFFFF3;
        ts.flags |= 2;
        Object pn = this.nf.createBlock(ts.getLineno());
        try {
            while (true) {
                int tt = ts.peekToken();
                if (tt > 0) {
                    if (tt != 93) {
                        if (tt == 110) {
                            ts.getToken();
                            this.nf.addChildToBack(pn, this.function(ts, false));
                            continue;
                        }
                        this.nf.addChildToBack(pn, this.statement(ts));
                        continue;
                    }
                }
                break;
            }
        }
        catch (JavaScriptException e) {
            this.ok = false;
        }
        finally {
            ts.flags = oldflags;
        }
        return pn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object function(TokenStream ts, boolean isExpr) throws IOException, JavaScriptException {
        Object body2;
        Object args;
        String name2;
        this.notifyObservers(new ParserEvents.OnFunctionParsingStart());
        int baseLineno = ts.getLineno();
        Object memberExprNode = null;
        if (ts.matchToken(44)) {
            name2 = ts.getString();
            if (!ts.matchToken(94)) {
                if (Context.getContext().hasFeature(2)) {
                    Object memberExprHead = this.nf.createName(name2);
                    name2 = null;
                    memberExprNode = this.memberExprTail(ts, false, memberExprHead);
                }
                this.mustMatchToken(ts, 94, "msg.no.paren.parms");
            }
        } else if (ts.matchToken(94)) {
            name2 = null;
        } else {
            name2 = null;
            if (Context.getContext().hasFeature(2)) {
                memberExprNode = this.memberExpr(ts, false);
            }
            this.mustMatchToken(ts, 94, "msg.no.paren.parms");
        }
        ++this.functionNumber;
        int savedSourceTop = this.sourceTop;
        int savedFunctionNumber = this.functionNumber;
        try {
            this.functionNumber = 0;
            args = this.nf.createLeaf(94);
            if (!ts.matchToken(95)) {
                do {
                    this.mustMatchToken(ts, 44, "msg.no.parm");
                    String s = ts.getString();
                    this.nf.addChildToBack(args, this.nf.createName(s));
                } while (ts.matchToken(96));
                this.mustMatchToken(ts, 95, "msg.no.paren.after.parms");
            }
            this.mustMatchToken(ts, 92, "msg.no.brace.body");
            body2 = this.parseFunctionBody(ts);
            this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
        }
        finally {
            this.sourceTop = savedSourceTop;
            this.functionNumber = savedFunctionNumber;
        }
        Object pn = this.nf.createFunction(name2, args, body2, ts.getSourceName(), baseLineno, ts.getLineno(), null, isExpr || memberExprNode != null);
        if (memberExprNode != null) {
            pn = this.nf.createBinary(97, 128, memberExprNode, pn);
        }
        if (!isExpr) {
            this.wellTerminated(ts, 110);
        }
        this.notifyObservers(new ParserEvents.OnFunctionParsingEnd(ts));
        return pn;
    }

    private Object statements(TokenStream ts) throws IOException {
        Object pn = this.nf.createBlock(ts.getLineno());
        while (true) {
            int tt = ts.peekToken();
            if (tt <= 0) break;
            if (tt == 93) break;
            this.nf.addChildToBack(pn, this.statement(ts));
        }
        return pn;
    }

    private Object condition(TokenStream ts) throws IOException, JavaScriptException {
        this.mustMatchToken(ts, 94, "msg.no.paren.cond");
        Object pn = this.expr(ts, false);
        this.mustMatchToken(ts, 95, "msg.no.paren.after.cond");
        return pn;
    }

    private boolean wellTerminated(TokenStream ts, int lastExprType) throws IOException, JavaScriptException {
        block5: {
            block7: {
                int version;
                block6: {
                    int tt = ts.peekTokenSameLine();
                    if (tt == -1) {
                        return false;
                    }
                    if (tt == 0) break block5;
                    if (tt == 1) break block5;
                    if (tt == 89) break block5;
                    if (tt == 93) break block5;
                    version = Context.getContext().getLanguageVersion();
                    if (tt == 110) break block6;
                    if (lastExprType != 110) break block7;
                }
                if (version < 120) {
                    return true;
                }
            }
            this.reportError(ts, "msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel(TokenStream ts) throws IOException, JavaScriptException {
        int lineno = ts.getLineno();
        String label = null;
        int tt = ts.peekTokenSameLine();
        if (tt == 44) {
            ts.getToken();
            label = ts.getString();
        }
        if (lineno == ts.getLineno()) {
            this.wellTerminated(ts, -1);
        }
        return label;
    }

    private Object statement(TokenStream ts) throws IOException {
        try {
            return this.statementHelper(ts);
        }
        catch (JavaScriptException e) {
            int t;
            int lineno = ts.getLineno();
            while ((t = ts.getToken()) != 89 && t != 1 && t != 0 && t != -1) {
            }
            return this.nf.createExprStatement(this.nf.createName("error"), lineno);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object statementHelper(TokenStream ts) throws IOException, JavaScriptException {
        pn = null;
        skipsemi = false;
        lastExprType = 0;
        tt = ts.getToken();
        block0 : switch (tt) {
            case 113: {
                skipsemi = true;
                lineno = ts.getLineno();
                cond = this.condition(ts);
                ifTrue = this.statement(ts);
                ifFalse = null;
                if (ts.matchToken(114)) {
                    ifFalse = this.statement(ts);
                }
                pn = this.nf.createIf(cond, ifTrue, ifFalse, lineno);
                break;
            }
            case 115: {
                skipsemi = true;
                pn = this.nf.createSwitch(ts.getLineno());
                cur_case = null;
                this.mustMatchToken(ts, 94, "msg.no.paren.switch");
                this.nf.addChildToBack(pn, this.expr(ts, false));
                this.mustMatchToken(ts, 95, "msg.no.paren.after.switch");
                this.mustMatchToken(ts, 92, "msg.no.brace.switch");
                while (true) {
                    tt = ts.getToken();
                    if (tt == 93) break block0;
                    if (tt == 0) break block0;
                    switch (tt) {
                        case 116: {
                            cur_case = this.nf.createUnary(116, this.expr(ts, false));
                            break;
                        }
                        case 117: {
                            cur_case = this.nf.createLeaf(117);
                            break;
                        }
                        default: {
                            this.reportError(ts, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(ts, 99, "msg.no.colon.case");
                    case_statements = this.nf.createLeaf(133);
                    ((Node)case_statements).setIsSyntheticBlock(true);
                    while (true) {
                        tt = ts.peekToken();
                        if (tt == 93) break;
                        if (tt == 116) break;
                        if (tt == 117) break;
                        if (tt == 0) break;
                        this.nf.addChildToBack(case_statements, this.statement(ts));
                    }
                    this.nf.addChildToBack(cur_case, case_statements);
                    this.nf.addChildToBack(pn, cur_case);
                }
            }
            case 118: {
                skipsemi = true;
                lineno = ts.getLineno();
                cond = this.condition(ts);
                body = this.statement(ts);
                pn = this.nf.createWhile(cond, body, lineno);
                break;
            }
            case 119: {
                lineno = ts.getLineno();
                body = this.statement(ts);
                this.mustMatchToken(ts, 118, "msg.no.while.do");
                cond = this.condition(ts);
                pn = this.nf.createDoWhile(body, cond, lineno);
                break;
            }
            case 120: {
                skipsemi = true;
                lineno = ts.getLineno();
                incr = null;
                this.mustMatchToken(ts, 94, "msg.no.paren.for");
                tt = ts.peekToken();
                if (tt == 89) {
                    init = this.nf.createLeaf(132);
                } else if (tt == 123) {
                    ts.getToken();
                    init = this.variables(ts, true);
                } else {
                    init = this.expr(ts, true);
                }
                tt = ts.peekToken();
                if (tt != 103) ** GOTO lbl-1000
                if (ts.getOp() == 63) {
                    ts.matchToken(103);
                    cond = this.expr(ts, false);
                } else lbl-1000:
                // 2 sources

                {
                    this.mustMatchToken(ts, 89, "msg.no.semi.for");
                    cond = ts.peekToken() == 89 ? this.nf.createLeaf(132) : this.expr(ts, false);
                    this.mustMatchToken(ts, 89, "msg.no.semi.for.cond");
                    incr = ts.peekToken() == 95 ? this.nf.createLeaf(132) : this.expr(ts, false);
                }
                this.mustMatchToken(ts, 95, "msg.no.paren.for.ctrl");
                body = this.statement(ts);
                if (incr == null) {
                    pn = this.nf.createForIn(init, cond, body, lineno);
                    break;
                }
                pn = this.nf.createFor(init, cond, incr, body, lineno);
                break;
            }
            case 75: {
                lineno = ts.getLineno();
                catchblocks = null;
                finallyblock = null;
                skipsemi = true;
                tryblock = this.statement(ts);
                catchblocks = this.nf.createLeaf(133);
                sawDefaultCatch = false;
                peek = ts.peekToken();
                if (peek == 125) {
                    while (true) {
                        if (ts.matchToken(125)) {
                            if (sawDefaultCatch) {
                                this.reportError(ts, "msg.catch.unreachable");
                            }
                            this.mustMatchToken(ts, 94, "msg.no.paren.catch");
                            this.mustMatchToken(ts, 44, "msg.bad.catchcond");
                            varName = ts.getString();
                            catchCond = null;
                            if (ts.matchToken(113)) {
                                catchCond = this.expr(ts, false);
                            } else {
                                sawDefaultCatch = true;
                            }
                            this.mustMatchToken(ts, 95, "msg.bad.catchcond");
                            this.mustMatchToken(ts, 92, "msg.no.brace.catchblock");
                            this.nf.addChildToBack(catchblocks, this.nf.createCatch(varName, catchCond, this.statements(ts), ts.getLineno()));
                            this.mustMatchToken(ts, 93, "msg.no.brace.after.body");
                            continue;
                        }
                        break;
                    }
                } else if (peek != 126) {
                    this.mustMatchToken(ts, 126, "msg.try.no.catchfinally");
                }
                if (ts.matchToken(126)) {
                    finallyblock = this.statement(ts);
                }
                pn = this.nf.createTryCatchFinally(tryblock, catchblocks, finallyblock, lineno);
                break;
            }
            case 62: {
                lineno = ts.getLineno();
                pn = this.nf.createThrow(this.expr(ts, false), lineno);
                if (lineno != ts.getLineno()) break;
                this.wellTerminated(ts, -1);
                break;
            }
            case 121: {
                lineno = ts.getLineno();
                label = this.matchLabel(ts);
                pn = this.nf.createBreak(label, lineno);
                break;
            }
            case 122: {
                lineno = ts.getLineno();
                label = this.matchLabel(ts);
                pn = this.nf.createContinue(label, lineno);
                break;
            }
            case 146: {
                lineno = ts.getLineno();
                pn = this.nf.createDebugger(lineno);
                break;
            }
            case 124: {
                this.reportError(ts, "msg.jsni.unsupported.with");
                skipsemi = true;
                lineno = ts.getLineno();
                this.mustMatchToken(ts, 94, "msg.no.paren.with");
                obj = this.expr(ts, false);
                this.mustMatchToken(ts, 95, "msg.no.paren.after.with");
                body = this.statement(ts);
                pn = this.nf.createWith(obj, body, lineno);
                break;
            }
            case 123: {
                lineno = ts.getLineno();
                pn = this.variables(ts, false);
                if (ts.getLineno() != lineno) break;
                this.wellTerminated(ts, -1);
                break;
            }
            case 5: {
                retExpr = null;
                lineno = 0;
                if (!this.insideFunction) {
                    if ((ts.flags & 2) == 0) {
                        this.reportError(ts, "msg.bad.return");
                    }
                }
                ts.flags |= 16;
                tt = ts.peekTokenSameLine();
                ts.flags &= ~16;
                if (tt == 0) ** GOTO lbl-1000
                if (tt == 1) ** GOTO lbl-1000
                if (tt == 89) ** GOTO lbl-1000
                if (tt != 93) {
                    lineno = ts.getLineno();
                    retExpr = this.expr(ts, false);
                    if (ts.getLineno() == lineno) {
                        this.wellTerminated(ts, -1);
                    }
                    ts.flags |= 4;
                } else lbl-1000:
                // 4 sources

                {
                    ts.flags |= 8;
                }
                pn = this.nf.createReturn(retExpr, lineno);
                break;
            }
            case 92: {
                skipsemi = true;
                pn = this.statements(ts);
                this.mustMatchToken(ts, 93, "msg.no.brace.block");
                break;
            }
            case -1: 
            case 1: 
            case 89: {
                pn = this.nf.createLeaf(132);
                skipsemi = true;
                break;
            }
            default: {
                lastExprType = tt;
                tokenno = ts.getTokenno();
                ts.ungetToken(tt);
                lineno = ts.getLineno();
                pn = this.expr(ts, false);
                if (ts.peekToken() == 99) {
                    if (lastExprType != 44 || ts.getTokenno() != tokenno) {
                        this.reportError(ts, "msg.bad.label");
                    }
                    ts.getToken();
                    name = ts.getString();
                    pn = this.nf.createLabel(name, lineno);
                    this.nf.addChildToBack(pn, this.statement(ts));
                    return pn;
                }
                if (lastExprType == 110) {
                    if (this.nf.getLeafType(pn) != 110) {
                        this.reportError(ts, "msg.syntax");
                    }
                }
                pn = this.nf.createExprStatement(pn, lineno);
                if (ts.getLineno() != lineno) {
                    if (lastExprType != 110 || ts.getLineno() != this.lastExprEndLine) break;
                }
                this.wellTerminated(ts, lastExprType);
                break;
            }
        }
        ts.matchToken(89);
        return pn;
    }

    private Object variables(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.nf.createVariables(ts.getLineno());
        do {
            this.mustMatchToken(ts, 44, "msg.bad.var");
            String s = ts.getString();
            Object name2 = this.nf.createName(s);
            if (ts.matchToken(97)) {
                if (ts.getOp() != 128) {
                    this.reportError(ts, "msg.bad.var.init");
                }
                Object init = this.assignExpr(ts, inForInit);
                this.nf.addChildToBack(name2, init);
            }
            this.nf.addChildToBack(pn, name2);
        } while (ts.matchToken(96));
        return pn;
    }

    private Object expr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.assignExpr(ts, inForInit);
        while (true) {
            if (!ts.matchToken(96)) break;
            pn = this.nf.createBinary(96, pn, this.assignExpr(ts, inForInit));
        }
        return pn;
    }

    private Object assignExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.condExpr(ts, inForInit);
        if (ts.matchToken(97)) {
            pn = this.nf.createBinary(97, ts.getOp(), pn, this.assignExpr(ts, inForInit));
        }
        return pn;
    }

    private Object condExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.orExpr(ts, inForInit);
        if (ts.matchToken(98)) {
            Object ifTrue = this.assignExpr(ts, false);
            this.mustMatchToken(ts, 99, "msg.no.colon.cond");
            Object ifFalse = this.assignExpr(ts, inForInit);
            return this.nf.createTernary(pn, ifTrue, ifFalse);
        }
        return pn;
    }

    private Object orExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.andExpr(ts, inForInit);
        if (ts.matchToken(100)) {
            pn = this.nf.createBinary(100, pn, this.orExpr(ts, inForInit));
        }
        return pn;
    }

    private Object andExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.bitOrExpr(ts, inForInit);
        if (ts.matchToken(101)) {
            pn = this.nf.createBinary(101, pn, this.andExpr(ts, inForInit));
        }
        return pn;
    }

    private Object bitOrExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.bitXorExpr(ts, inForInit);
        while (true) {
            if (!ts.matchToken(11)) break;
            pn = this.nf.createBinary(11, pn, this.bitXorExpr(ts, inForInit));
        }
        return pn;
    }

    private Object bitXorExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.bitAndExpr(ts, inForInit);
        while (true) {
            if (!ts.matchToken(12)) break;
            pn = this.nf.createBinary(12, pn, this.bitAndExpr(ts, inForInit));
        }
        return pn;
    }

    private Object bitAndExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.eqExpr(ts, inForInit);
        while (true) {
            if (!ts.matchToken(13)) break;
            pn = this.nf.createBinary(13, pn, this.eqExpr(ts, inForInit));
        }
        return pn;
    }

    private Object eqExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.relExpr(ts, inForInit);
        while (true) {
            if (!ts.matchToken(102)) break;
            pn = this.nf.createBinary(102, ts.getOp(), pn, this.relExpr(ts, inForInit));
        }
        return pn;
    }

    private Object relExpr(TokenStream ts, boolean inForInit) throws IOException, JavaScriptException {
        Object pn = this.shiftExpr(ts);
        while (true) {
            if (!ts.matchToken(103)) break;
            int op = ts.getOp();
            if (inForInit) {
                if (op == 63) {
                    ts.ungetToken(103);
                    break;
                }
            }
            pn = this.nf.createBinary(103, op, pn, this.shiftExpr(ts));
        }
        return pn;
    }

    private Object shiftExpr(TokenStream ts) throws IOException, JavaScriptException {
        Object pn = this.addExpr(ts);
        while (true) {
            if (!ts.matchToken(104)) break;
            pn = this.nf.createBinary(104, ts.getOp(), pn, this.addExpr(ts));
        }
        return pn;
    }

    private Object addExpr(TokenStream ts) throws IOException, JavaScriptException {
        int tt;
        Object pn = this.mulExpr(ts);
        while (true) {
            tt = ts.getToken();
            if (tt != 23) {
                if (tt != 24) break;
            }
            pn = this.nf.createBinary(tt, pn, this.mulExpr(ts));
        }
        ts.ungetToken(tt);
        return pn;
    }

    private Object mulExpr(TokenStream ts) throws IOException, JavaScriptException {
        Object pn = this.unaryExpr(ts);
        while (true) {
            int tt = ts.peekToken();
            if (tt != 25) {
                if (tt != 26) {
                    if (tt != 27) break;
                }
            }
            tt = ts.getToken();
            pn = this.nf.createBinary(tt, pn, this.unaryExpr(ts));
        }
        return pn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object unaryExpr(TokenStream ts) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        ts.flags &= ~16;
        switch (tt) {
            case 105: {
                return this.nf.createUnary(105, ts.getOp(), this.unaryExpr(ts));
            }
            case 23: 
            case 24: {
                return this.nf.createUnary(105, tt, this.unaryExpr(ts));
            }
            case 106: 
            case 107: {
                return this.nf.createUnary(tt, 130, this.memberExpr(ts, true));
            }
            case 31: {
                return this.nf.createUnary(31, this.unaryExpr(ts));
            }
            case -1: {
                return this.nf.createName("err");
            }
            default: {
                ts.ungetToken(tt);
                int lineno = ts.getLineno();
                Object pn = this.memberExpr(ts, true);
                int peeked = ts.peekToken();
                if (peeked != 106) {
                    if (peeked != 107) return pn;
                }
                if (ts.getLineno() != lineno) return pn;
                int pf = ts.getToken();
                return this.nf.createUnary(pf, 131, pn);
            }
        }
    }

    private Object argumentList(TokenStream ts, Object listNode) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        boolean matched = ts.matchToken(95);
        ts.flags &= ~16;
        if (!matched) {
            do {
                this.nf.addChildToBack(listNode, this.assignExpr(ts, false));
            } while (ts.matchToken(96));
            this.mustMatchToken(ts, 95, "msg.no.paren.arg");
        }
        return listNode;
    }

    private Object memberExpr(TokenStream ts, boolean allowCallSyntax) throws IOException, JavaScriptException {
        Object pn;
        ts.flags |= 0x10;
        int tt = ts.peekToken();
        ts.flags &= ~16;
        if (tt == 30) {
            ts.getToken();
            pn = this.nf.createLeaf(30);
            this.nf.addChildToBack(pn, this.memberExpr(ts, false));
            if (ts.matchToken(94)) {
                pn = this.argumentList(ts, pn);
            }
            tt = ts.peekToken();
            if (tt == 92) {
                this.nf.addChildToBack(pn, this.primaryExpr(ts));
            }
        } else {
            pn = this.primaryExpr(ts);
        }
        return this.memberExprTail(ts, allowCallSyntax, pn);
    }

    private Object memberExprTail(TokenStream ts, boolean allowCallSyntax, Object pn) throws IOException, JavaScriptException {
        block3: {
            int tt;
            this.lastExprEndLine = ts.getLineno();
            while (true) {
                tt = ts.getToken();
                if (tt <= 0) break block3;
                if (tt == 108) {
                    this.mustMatchToken(ts, 44, "msg.no.name.after.dot");
                    String s = ts.getString();
                    pn = this.nf.createBinary(108, pn, this.nf.createName(ts.getString()));
                    this.lastExprEndLine = ts.getLineno();
                    continue;
                }
                if (tt == 90) {
                    pn = this.nf.createBinary(90, pn, this.expr(ts, false));
                    this.mustMatchToken(ts, 91, "msg.no.bracket.index");
                    this.lastExprEndLine = ts.getLineno();
                    continue;
                }
                if (!allowCallSyntax) break;
                if (tt != 94) break;
                pn = this.nf.createUnary(43, pn);
                pn = this.argumentList(ts, pn);
                this.lastExprEndLine = ts.getLineno();
            }
            ts.ungetToken(tt);
        }
        return pn;
    }

    public Object primaryExpr(TokenStream ts) throws IOException, JavaScriptException {
        ts.flags |= 0x10;
        int tt = ts.getToken();
        ts.flags &= ~16;
        switch (tt) {
            case 110: {
                return this.function(ts, true);
            }
            case 90: {
                Object pn = this.nf.createLeaf(134);
                ts.flags |= 0x10;
                boolean matched = ts.matchToken(91);
                ts.flags &= ~16;
                if (!matched) {
                    do {
                        ts.flags |= 0x10;
                        tt = ts.peekToken();
                        ts.flags &= ~16;
                        if (tt == 91) break;
                        if (tt == 96) {
                            this.nf.addChildToBack(pn, this.nf.createLeaf(109, 74));
                        } else {
                            this.nf.addChildToBack(pn, this.assignExpr(ts, false));
                        }
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 91, "msg.no.bracket.arg");
                }
                return this.nf.createArrayLiteral(pn);
            }
            case 92: {
                Object pn = this.nf.createLeaf(135);
                if (!ts.matchToken(93)) {
                    block20: do {
                        Object property;
                        tt = ts.getToken();
                        switch (tt) {
                            case 44: 
                            case 46: {
                                property = this.nf.createString(ts.getString());
                                break;
                            }
                            case 148: {
                                int n = (int)ts.getNumber();
                                property = this.nf.createNumber(n);
                                break;
                            }
                            case 45: {
                                double d = ts.getNumber();
                                property = this.nf.createNumber(d);
                                break;
                            }
                            case 93: {
                                ts.ungetToken(tt);
                                break block20;
                            }
                            default: {
                                this.reportError(ts, "msg.bad.prop");
                                break block20;
                            }
                        }
                        this.mustMatchToken(ts, 99, "msg.no.colon.prop");
                        this.nf.addChildToBack(pn, property);
                        this.nf.addChildToBack(pn, this.assignExpr(ts, false));
                    } while (ts.matchToken(96));
                    this.mustMatchToken(ts, 93, "msg.no.brace.prop");
                }
                return this.nf.createObjectLiteral(pn);
            }
            case 94: {
                Object pn = this.expr(ts, false);
                this.mustMatchToken(ts, 95, "msg.no.paren");
                return pn;
            }
            case 44: {
                String name2 = ts.getString();
                return this.nf.createName(name2);
            }
            case 148: {
                int n = (int)ts.getNumber();
                return this.nf.createNumber(n);
            }
            case 45: {
                double d = ts.getNumber();
                return this.nf.createNumber(d);
            }
            case 46: {
                String s = ts.getString();
                return this.nf.createString(s);
            }
            case 56: {
                String flags = ts.regExpFlags;
                ts.regExpFlags = null;
                String re = ts.getString();
                return this.nf.createRegExp(re, flags);
            }
            case 109: {
                return this.nf.createLeaf(109, ts.getOp());
            }
            case -1: {
                break;
            }
            default: {
                this.reportError(ts, "msg.syntax");
            }
        }
        return null;
    }
}

