/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.framework.ui.ConfigureDialogWithModulesAndVersion;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class KotlinWithGradleConfigurator
implements KotlinProjectConfigurator {
    private static final String[] KOTLIN_VERSIONS = new String[]{"0.6.+"};
    protected static final String VERSION_TEMPLATE = "$VERSION$";
    protected static final String CLASSPATH = "classpath \"org.jetbrains.kotlin:kotlin-gradle-plugin:$kotlin_version\"";
    protected static final String SNAPSHOT_REPOSITORY = "maven {\nurl 'http://oss.sonatype.org/content/repositories/snapshots'\n}";
    protected static final String REPOSITORY = "mavenCentral()\n";
    protected static final String LIBRARY = "compile \"org.jetbrains.kotlin:kotlin-stdlib:$kotlin_version\"";
    protected static final String SOURCE_SET = "main.java.srcDirs += 'src/main/kotlin'\n";
    protected static final String VERSION = String.format("ext.kotlin_version = '%s'", "$VERSION$");

    @Override
    public boolean isConfigured(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "isConfigured"));
        }
        if (ProjectStructureUtil.isJavaKotlinModule(module)) {
            return true;
        }
        GroovyFile moduleGradleFile = KotlinWithGradleConfigurator.getBuildGradleFile(module.getProject(), KotlinWithGradleConfigurator.getDefaultPathToBuildGradleFile(module));
        if (moduleGradleFile != null && this.isFileConfigured(moduleGradleFile)) {
            return true;
        }
        GroovyFile projectGradleFile = KotlinWithGradleConfigurator.getBuildGradleFile(module.getProject(), KotlinWithGradleConfigurator.getDefaultPathToBuildGradleFile(module.getProject()));
        return projectGradleFile != null && this.isFileConfigured(projectGradleFile);
    }

    private boolean isFileConfigured(GroovyFile projectGradleFile) {
        String fileText = projectGradleFile.getText();
        return fileText.contains(this.getApplyPluginDirective()) && fileText.contains(LIBRARY);
    }

    @Override
    public void configure(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "configure"));
        }
        List<Module> nonConfiguredModules = ConfigureKotlinInProjectUtils.getNonConfiguredModules(project, this);
        ConfigureDialogWithModulesAndVersion dialog2 = new ConfigureDialogWithModulesAndVersion(project, nonConfiguredModules, KOTLIN_VERSIONS);
        dialog2.show();
        if (!dialog2.isOK()) {
            return;
        }
        for (Module module : dialog2.getModulesToConfigure()) {
            String gradleFilePath = KotlinWithGradleConfigurator.getDefaultPathToBuildGradleFile(module);
            GroovyFile file = KotlinWithGradleConfigurator.getBuildGradleFile(project, gradleFilePath);
            if (file != null && KotlinWithGradleConfigurator.canConfigureFile(file)) {
                this.changeGradleFile(file, dialog2.getKotlinVersion());
                OpenFileAction.openFile((String)gradleFilePath, (Project)project);
                continue;
            }
            KotlinWithGradleConfigurator.showErrorMessage(project, "Cannot find build.gradle file for module " + module.getName());
        }
    }

    private void addElements(@NotNull GroovyFile file, @NotNull String version) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addElements"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addElements"));
        }
        GrClosableBlock buildScriptBlock = KotlinWithGradleConfigurator.getBuildScriptBlock((GrStatementOwner)file);
        KotlinWithGradleConfigurator.addFirstExpressionInBlockIfNeeded(VERSION.replace(VERSION_TEMPLATE, version), buildScriptBlock);
        GrClosableBlock buildScriptRepositoriesBlock = KotlinWithGradleConfigurator.getBuildScriptRepositoriesBlock((GrStatementOwner)file);
        if (KotlinWithGradleConfigurator.isSnapshot(version)) {
            KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(SNAPSHOT_REPOSITORY, buildScriptRepositoriesBlock);
        } else if (!buildScriptRepositoriesBlock.getText().contains(REPOSITORY)) {
            KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(REPOSITORY, buildScriptRepositoriesBlock);
        }
        GrClosableBlock buildScriptDependenciesBlock = KotlinWithGradleConfigurator.getBuildScriptDependenciesBlock((GrStatementOwner)file);
        KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(CLASSPATH, buildScriptDependenciesBlock);
        if (!file.getText().contains(this.getApplyPluginDirective())) {
            GrExpression apply = GroovyPsiElementFactory.getInstance((Project)file.getProject()).createExpressionFromText((CharSequence)this.getApplyPluginDirective());
            GrApplicationStatement applyStatement = KotlinWithGradleConfigurator.getApplyStatement(file);
            if (applyStatement != null) {
                file.addAfter((PsiElement)apply, (PsiElement)applyStatement);
            } else {
                file.addAfter((PsiElement)apply, buildScriptBlock.getParent());
            }
        }
        GrClosableBlock repositoriesBlock = KotlinWithGradleConfigurator.getRepositoriesBlock((GrStatementOwner)file);
        if (KotlinWithGradleConfigurator.isSnapshot(version)) {
            KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(SNAPSHOT_REPOSITORY, repositoriesBlock);
        } else if (!repositoriesBlock.getText().contains(REPOSITORY)) {
            KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(REPOSITORY, repositoriesBlock);
        }
        GrClosableBlock dependenciesBlock = KotlinWithGradleConfigurator.getDependenciesBlock((GrStatementOwner)file);
        KotlinWithGradleConfigurator.addLastExpressionInBlockIfNeeded(LIBRARY, dependenciesBlock);
        this.addSourceSetsBlock(file);
    }

    protected abstract String getApplyPluginDirective();

    protected abstract void addSourceSetsBlock(@NotNull GroovyFile var1);

    protected static boolean canConfigureFile(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "canConfigureFile"));
        }
        return WritingAccessProvider.isPotentiallyWritable((VirtualFile)file.getVirtualFile(), null);
    }

    @Nullable
    protected static GroovyFile getBuildGradleFile(Project project, String path) {
        VirtualFile file = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof GroovyFile)) {
            return null;
        }
        return (GroovyFile)psiFile;
    }

    @NotNull
    protected static String getDefaultPathToBuildGradleFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDefaultPathToBuildGradleFile"));
        }
        String string = project.getBasePath() + "/" + "build.gradle";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDefaultPathToBuildGradleFile"));
        }
        return string;
    }

    @NotNull
    protected static String getDefaultPathToBuildGradleFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDefaultPathToBuildGradleFile"));
        }
        String string = new File(module.getModuleFilePath()).getParent() + "/" + "build.gradle";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDefaultPathToBuildGradleFile"));
        }
        return string;
    }

    protected static boolean isSnapshot(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "isSnapshot"));
        }
        return version.contains("SNAPSHOT");
    }

    protected void changeGradleFile(final @NotNull GroovyFile groovyFile, final @NotNull String version) {
        if (groovyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyFile", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "changeGradleFile"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "changeGradleFile"));
        }
        new WriteCommandAction(groovyFile.getProject(), new PsiFile[0]){

            protected void run(Result result2) {
                KotlinWithGradleConfigurator.this.addElements(groovyFile, version);
                CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)groovyFile);
            }
        }.execute();
        VirtualFile virtualFile = groovyFile.getVirtualFile();
        if (virtualFile != null) {
            ConfigureKotlinInProjectUtils.showInfoNotification(virtualFile.getPath() + " was modified");
        }
    }

    @NotNull
    protected static GrClosableBlock getDependenciesBlock(@NotNull GrStatementOwner file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDependenciesBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(file, "dependencies");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getDependenciesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getSourceSetsBlock(@NotNull GrStatementOwner parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getSourceSetsBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(parent, "sourceSets");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getSourceSetsBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getBuildScriptBlock(@NotNull GrStatementOwner file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(file, "buildscript");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getBuildScriptDependenciesBlock(@NotNull GrStatementOwner file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptDependenciesBlock"));
        }
        GrClosableBlock buildScript = KotlinWithGradleConfigurator.getBuildScriptBlock(file);
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate((GrStatementOwner)buildScript, "dependencies");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptDependenciesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getBuildScriptRepositoriesBlock(@NotNull GrStatementOwner file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptRepositoriesBlock"));
        }
        GrClosableBlock buildScript = KotlinWithGradleConfigurator.getBuildScriptBlock(file);
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate((GrStatementOwner)buildScript, "repositories");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBuildScriptRepositoriesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getRepositoriesBlock(@NotNull GrStatementOwner file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getRepositoriesBlock"));
        }
        GrClosableBlock grClosableBlock = KotlinWithGradleConfigurator.getBlockOrCreate(file, "repositories");
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getRepositoriesBlock"));
        }
        return grClosableBlock;
    }

    @NotNull
    protected static GrClosableBlock getBlockOrCreate(@NotNull GrStatementOwner parent, @NotNull String name2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockOrCreate"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockOrCreate"));
        }
        GrClosableBlock block = KotlinWithGradleConfigurator.getBlockByName((PsiElement)parent, name2);
        if (block == null) {
            GroovyPsiElementFactory factory2 = GroovyPsiElementFactory.getInstance((Project)parent.getProject());
            GrExpression newBlock = factory2.createExpressionFromText((CharSequence)(name2 + "{\n}\n"));
            GrStatement[] statements = parent.getStatements();
            if (statements.length > 0) {
                parent.addAfter((PsiElement)newBlock, (PsiElement)statements[statements.length - 1]);
            } else {
                parent.addAfter((PsiElement)newBlock, parent.getFirstChild());
            }
            block = KotlinWithGradleConfigurator.getBlockByName((PsiElement)parent, name2);
            assert (block != null) : "Block should be non-null because it is created";
        }
        GrClosableBlock grClosableBlock = block;
        if (grClosableBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockOrCreate"));
        }
        return grClosableBlock;
    }

    protected static void addLastExpressionInBlockIfNeeded(@NotNull String text, @NotNull GrClosableBlock block) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addLastExpressionInBlockIfNeeded"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addLastExpressionInBlockIfNeeded"));
        }
        KotlinWithGradleConfigurator.addExpressionInBlockIfNeeded(text, block, false);
    }

    protected static void addFirstExpressionInBlockIfNeeded(@NotNull String text, @NotNull GrClosableBlock block) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addFirstExpressionInBlockIfNeeded"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addFirstExpressionInBlockIfNeeded"));
        }
        KotlinWithGradleConfigurator.addExpressionInBlockIfNeeded(text, block, true);
    }

    @Nullable
    private static GrClosableBlock getBlockByName(@NotNull PsiElement parent, @NotNull String name2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockByName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getBlockByName"));
        }
        GrMethodCallExpression[] allExpressions = (GrMethodCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, GrMethodCallExpression.class);
        if (allExpressions != null) {
            for (GrMethodCallExpression expression2 : allExpressions) {
                String expressionText2;
                GrExpression invokedExpression = expression2.getInvokedExpression();
                if (invokedExpression == null || expression2.getClosureArguments().length == 0 || !(expressionText2 = invokedExpression.getText()).equals(name2)) continue;
                return expression2.getClosureArguments()[0];
            }
        }
        return null;
    }

    private static void addExpressionInBlockIfNeeded(@NotNull String text, @NotNull GrClosableBlock block, boolean isFirst) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addExpressionInBlockIfNeeded"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "addExpressionInBlockIfNeeded"));
        }
        if (block.getText().contains(text)) {
            return;
        }
        GrExpression newStatement = GroovyPsiElementFactory.getInstance((Project)block.getProject()).createExpressionFromText((CharSequence)text);
        CodeStyleManager.getInstance((Project)block.getProject()).reformat((PsiElement)newStatement);
        GrStatement[] statements = block.getStatements();
        if (!isFirst && statements.length > 0) {
            GrStatement lastStatement = statements[statements.length - 1];
            if (lastStatement != null) {
                block.addAfter((PsiElement)newStatement, (PsiElement)lastStatement);
            }
        } else {
            PsiElement firstChild = block.getFirstChild();
            if (firstChild != null) {
                block.addAfter((PsiElement)newStatement, firstChild);
            }
        }
    }

    @Nullable
    private static GrApplicationStatement getApplyStatement(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "getApplyStatement"));
        }
        GrApplicationStatement[] applyStatement = (GrApplicationStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)file, GrApplicationStatement.class);
        if (applyStatement == null) {
            return null;
        }
        for (GrApplicationStatement callExpression : applyStatement) {
            GrExpression invokedExpression = callExpression.getInvokedExpression();
            if (invokedExpression == null || !invokedExpression.getText().equals("apply")) continue;
            return callExpression;
        }
        return null;
    }

    protected static void showErrorMessage(@NotNull Project project, @Nullable String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/KotlinWithGradleConfigurator", "showErrorMessage"));
        }
        Messages.showErrorDialog((Project)project, (String)("<html>Couldn't configure kotlin-gradle plugin automatically.<br/>" + (message != null ? message : "") + "See manual installation instructions <a href=\"http://confluence.jetbrains.com/display/Kotlin/Kotlin+Build+Tools#KotlinBuildTools-Gradle\">here</a></html>"), (String)"Configure Kotlin-Gradle Plugin");
    }
}

