/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;

public class ConfigureKotlinNotification
extends Notification {
    private static final String TITLE = "Configure Kotlin";
    @NotNull
    private final String notificationText;

    public ConfigureKotlinNotification(final @NotNull Project project, @NotNull String notificationText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification", "<init>"));
        }
        if (notificationText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationText", "org/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification", "<init>"));
        }
        super("Configure Kotlin in Project", TITLE, notificationText, NotificationType.WARNING, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$1", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    KotlinProjectConfigurator configurator = ConfigureKotlinInProjectUtils.getConfiguratorByName(event.getDescription());
                    if (configurator == null) {
                        throw new AssertionError((Object)("Missed action: " + event.getDescription()));
                    }
                    configurator.configure(project);
                    notification.expire();
                }
            }
        });
        this.notificationText = notificationText;
    }

    @NotNull
    public static String getNotificationString(Project project) {
        Collection<Module> modules = ConfigureKotlinInProjectUtils.getNonConfiguredModules(project);
        final boolean isOnlyOneModule = modules.size() == 1;
        String modulesString = isOnlyOneModule ? String.format("'%s' module", ((Module)KotlinPackage.first(modules)).getName()) : "modules";
        String links = StringUtil.join(ConfigureKotlinInProjectUtils.getAbleToRunConfigurators(project), (Function)new Function<KotlinProjectConfigurator, String>(){

            public String fun(KotlinProjectConfigurator configurator) {
                return ConfigureKotlinNotification.getLink(configurator, isOnlyOneModule);
            }
        }, (String)"<br/>");
        String string = String.format("Configure %s in '%s' project<br/> %s", modulesString, project.getName(), links);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification", "getNotificationString"));
        }
        return string;
    }

    @NotNull
    private static String getLink(@NotNull KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
        if (configurator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurator", "org/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification", "getLink"));
        }
        String string = StringUtil.join((String[])new String[]{"<a href=\"", configurator.getName(), "\">as Kotlin (", configurator.getPresentableText(), isOnlyOneModule ? ") module" : ") modules", "</a>"});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification", "getLink"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigureKotlinNotification)) {
            return false;
        }
        ConfigureKotlinNotification that = (ConfigureKotlinNotification)((Object)o);
        return this.notificationText.equals(that.notificationText);
    }

    public int hashCode() {
        return this.notificationText.hashCode();
    }
}

