/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.codeInsight;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.codeInsight.OverrideImplementMethodsHandler;
import org.jetbrains.kotlin.resolve.OverrideResolver;

public class ImplementMethodsHandler
extends OverrideImplementMethodsHandler
implements IntentionAction {
    @Override
    protected Set<CallableMemberDescriptor> collectMethodsToGenerate(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/core/codeInsight/ImplementMethodsHandler", "collectMethodsToGenerate"));
        }
        return OverrideResolver.getMissingImplementations(descriptor2);
    }

    @Override
    protected String getChooserTitle() {
        return "Implement Members";
    }

    @Override
    protected String getNoMethodsFoundHint() {
        return "No methods to implement have been found";
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("implement.members", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/codeInsight/ImplementMethodsHandler", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("implement.members", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/core/codeInsight/ImplementMethodsHandler", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/core/codeInsight/ImplementMethodsHandler", "isAvailable"));
        }
        return this.isValidFor(editor, file);
    }
}

