/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionCodeFragment;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.SourcePackage;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u001e\b)a2j\u001c;mS:\u001cv.\u001e:dKB{7/\u001b;j_:\u0004&o\u001c<jI\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\tI\u0016\u0014WoZ4fe*12k\\;sG\u0016\u0004vn]5uS>t\u0007K]8wS\u0012,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0007K:<\u0017N\\3\u000b\rqJg.\u001b;?\u0015U\u0019w.\u001c9vi\u0016\u001cv.\u001e:dKB{7/\u001b;j_:T!\u0002Z3tGJL\u0007\u000f^8s\u0015=1\u0015.\u001a7e\t\u0016\u001c8M]5qi>\u0014(BA;j\u0015\u0011!(/Z3\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\bG>tG/\u001a=u\u0015M!UMY;hO\u0016\u00148i\u001c8uKb$\u0018*\u001c9m\u0015\u0011IW\u000e\u001d7\u000b\u000f9,\u0017M]3ti*9!i\\8mK\u0006t'BD*pkJ\u001cW\rU8tSRLwN\u001c\u0006\u0018\u0019>\u001c\u0017\r\u001c,be&\f'\r\\3EKN\u001c'/\u001b9u_JTaBT8eK\u0012+7o\u0019:jaR|'OC\bgS:$7\t\\1tg\nKH+\u001f9f\u0015\u0011!\u0018\u0010]3\u000b\u001bI+g-\u001a:f]\u000e,G+\u001f9f\u0015\r\u0019XO\u001c\u0006\u0004U\u0012L'B\u0003)tS\u0016cW-\\3oi*\u0019\u0001o]5\u000b+\u001d,G\u000fT1tiN{WO]2f!>\u001c\u0018\u000e^5p]:\u0010!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u000f)!\u0001B\u0002\t\t\u0015\u0011Aq\u0001E\u0003\u000b\t!A\u0001#\u0003\u0006\u0007\u0011%\u0001b\u0001\u0007\u0001\u000b\t!A\u0001C\u0004\u0006\u0005\u0011-\u0001rB\u0003\u0004\t\u0019Ai\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001\"C\u0003\u0003\t\u001dA\u0001\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0003\t\u0011A)\"B\u0002\u0005\u0012!QA\u0002A\u0003\u0002\u0011\u0007)1\u0001b\u0005\t\u00181\u0001Qa\u0001\u0003\u0005\u00111a\u0001!\u0002\u0002\u0005\t!aQA\u0001\u0003\u0007\u0011\u001b)!\u0001b\u0004\t\u0012\u0015\u0011A\u0011\u0003\u0005\u000b\u000b\r!a\u0001#\u0007\r\u0001\u0015\u0011AA\u0002E\r\u000b\r!a\u0001C\u0007\r\u0001\u0015\u0011AA\u0002\u0005\u000e\u000b\t!1\u0001C\b\u0006\u0005\u0011y\u0001rD\u0003\u0004\t?Ai\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001\u0012E\u0003\u0004\tCA\u0001\u0003\u0004\u0001\u0006\u0005\u0011\u0005\u0002\u0002E\u0003\u0003\t?Ai\u0002B\u0002\r\u0006e\u0011Q!\u0001\u0005\u0006[C\"\u0011\u0001g\u0003\u001e\u000e\u0011\u0001\u0001BB\u0007\u0003\u000b\u0005Ai\u0001U\u0002\u0001;\u001b!\u0001\u0001\u0003\u0005\u000e\u0005\u0015\t\u0001\u0002\u0003)\u0004\u0002u5A\u0001\u0001E\n\u001b\t)\u0011\u0001C\u0005Q\u0007\u0005ij\u0001\u0002\u0001\t\u00175\u0011Q!\u0001\u0005\u000b!\u000e\r\u0011eA\u0003\u0002\u0011+a\t!U\u0002\f\t\u0017I\u0011\u0001C\u0006\u000e\u0003!]Q\"\u0001\u0005\r\u001b\u0005AI\"D\u0001\u0005\u00025\u0006D!\u0001M\u0006;\u001b!\u0001\u0001\u0003\u0004\u000e\u0005\u0015\t\u0001\"\u0004)\u0004\u0001u5A\u0001\u0001\u0005\t\u001b\t)\u0011\u0001\u0003\u0005Q\u0007\u0003ij\u0001\u0002\u0001\t\u00145\u0011Q!\u0001\u0005\n!\u000e\tQT\u0002\u0003\u0001\u0011-i!!B\u0001\t\u0015A\u001b\u0019!I\u0002\u0006\u0003!UA\u0012A)\u0004\u0017\u0011-\u0011\"\u0001\u0005\f\u001b\u0005AY\"D\u0001\t\u00195\t\u0001\u0012D\u0007\u0002\t\u0003i\u000b\u0007\u0002\u0006\u0019\fu5A\u0001\u0001\u0005\u0007\u001b\t)\u0011\u0001\u0003\bQ\u0007\u0001ij\u0001\u0002\u0001\t\u00115\u0011Q!\u0001\u0005\t!\u000e\u0005QT\u0002\u0003\u0001\u0011'i!!B\u0001\t\u0013A\u001b\u0011!(\u0004\u0005\u0001!YQBA\u0003\u0002\u0011)\u000161A\u0011\u0004\u000b\u0005A)\u0002$\u0001R\u0007-!Y!C\u0001\t\u00175\t\u0001RD\u0007\u0002\u00111i\u0011\u0001#\u0007\u000e\u0003\u0011\u0005Qf\n\u0003\u000217ij\u0001\u0002\u0001\t\u00115\u0011Q!\u0001\u0005\t!\u000e\u0001QT\u0002\u0003\u0001\u00119i!!B\u0001\t!A\u001b\t!(\u0004\u0005\u0001!MQBA\u0003\u0002\u0011%\u00016!A\u0011\u0004\u000b\u0005A\u0011\u0003$\u0001R\u0007%!Y\"C\u0001\t$5\t\u0001\u0002D\u0007\u0002\u0011Ii\u0011\u0001#\u0007.<\u0011\t\u0001$EO\u0007\t\u0001Aa\"\u0004\u0002\u0006\u0003!\u0001\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u00012C\u0007\u0003\u000b\u0005A\u0011\u0002UB\u0001C\r)\u0011\u0001#\u0006\r\u0002E\u001bq\u0001B\t\n\u0003!YQ\"\u0001\u0005\u0013\u001b\u0005AI\"N\u0006\u0006\u0015\u0011\u0019\u000f\u0001G\u0003\"\u0005\u0015\t\u0001RA)\u0004\u0007\u0011)\u0011\"\u0001\u0003\u0001"})
public final class KotlinSourcePositionProvider
extends SourcePositionProvider {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSourcePositionProvider.class);
    }

    @Nullable
    protected SourcePosition computeSourcePosition(@JetValueParameter(name="descriptor") @NotNull NodeDescriptor descriptor2, @JetValueParameter(name="project") @NotNull Project project, @JetValueParameter(name="context") @NotNull DebuggerContextImpl context2, @JetValueParameter(name="nearest") boolean nearest) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (context2.getFrameProxy() == null) {
            return null;
        }
        if (descriptor2 instanceof FieldDescriptor) {
            return this.computeSourcePosition((FieldDescriptor)descriptor2, project, context2, nearest);
        }
        if (descriptor2 instanceof LocalVariableDescriptor) {
            return this.computeSourcePosition((LocalVariableDescriptor)descriptor2, project, context2, nearest);
        }
        return null;
    }

    private final SourcePosition computeSourcePosition(@JetValueParameter(name="descriptor") LocalVariableDescriptor descriptor2, @JetValueParameter(name="project") Project project, @JetValueParameter(name="context") DebuggerContextImpl context2, @JetValueParameter(name="nearest") boolean nearest) {
        PsiElement psiElement = PositionUtil.getContextElement((StackFrameContext)((StackFrameContext)context2));
        if (psiElement == null) {
            return null;
        }
        PsiElement place = psiElement;
        JetElement jetElement = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)place, JetElement.class);
        if (jetElement == null) {
            return null;
        }
        JetElement contextElement = jetElement;
        JetPsiFactory jetPsiFactory = new JetPsiFactory(project);
        String string = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.getName()");
        JetExpressionCodeFragment codeFragment = jetPsiFactory.createExpressionCodeFragment(string, (PsiElement)contextElement);
        JetExpression expression2 = codeFragment.getContentElement();
        if (expression2 instanceof JetSimpleNameExpression) {
            SourceElement sourceElement;
            VariableDescriptor declarationDescriptor;
            BindingContext bindingContext2 = ResolvePackage.analyze(expression2, BodyResolveMode.PARTIAL);
            VariableDescriptor variableDescriptor = declarationDescriptor = BindingContextUtils.extractVariableDescriptorIfAny(bindingContext2, expression2, false);
            SourceElement sourceElement2 = sourceElement = variableDescriptor != null ? variableDescriptor.getSource() : null;
            if (sourceElement instanceof KotlinSourceElement) {
                PsiElement psiElement2 = SourcePackage.getPsi(sourceElement);
                if (psiElement2 == null) {
                    return null;
                }
                PsiElement element = psiElement2;
                if (nearest) {
                    return DebuggerContextUtil.findNearest((DebuggerContextImpl)context2, (PsiElement)element, (PsiFile)element.getContainingFile());
                }
                return SourcePosition.createFromOffset((PsiFile)element.getContainingFile(), (int)element.getTextOffset());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final SourcePosition computeSourcePosition(@JetValueParameter(name="descriptor") FieldDescriptor descriptor2, @JetValueParameter(name="project") Project project, @JetValueParameter(name="context") DebuggerContextImpl context2, @JetValueParameter(name="nearest") boolean nearest) {
        Object v4;
        JetClassOrObject myClass;
        block6: {
            void $receiver;
            ReferenceType type2;
            String fieldName = descriptor2.getField().name();
            if (Intrinsics.areEqual((Object)fieldName, (Object)AsmUtil.CAPTURED_THIS_FIELD) || Intrinsics.areEqual((Object)fieldName, (Object)AsmUtil.CAPTURED_RECEIVER_FIELD)) {
                return null;
            }
            ReferenceType referenceType = type2 = descriptor2.getField().declaringType();
            Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"type");
            PsiElement psiElement = this.findClassByType(project, referenceType, context2);
            Object object = psiElement != null ? psiElement.getNavigationElement() : null;
            if (!(object instanceof JetClassOrObject)) {
                object = null;
            }
            JetClassOrObject jetClassOrObject = (JetClassOrObject)object;
            if (jetClassOrObject == null) {
                return null;
            }
            myClass = jetClassOrObject;
            Iterable iterable = myClass.getDeclarations();
            for (Object element : $receiver) {
                JetDeclaration it = (JetDeclaration)element;
                if (!Intrinsics.areEqual((Object)fieldName, (Object)it.getName())) continue;
                v4 = element;
                break block6;
            }
            v4 = null;
        }
        JetDeclaration jetDeclaration = v4;
        if (jetDeclaration == null) {
            return null;
        }
        JetDeclaration field = jetDeclaration;
        if (nearest) {
            return DebuggerContextUtil.findNearest((DebuggerContextImpl)context2, (PsiElement)field, (PsiFile)myClass.getContainingFile());
        }
        return SourcePosition.createFromOffset((PsiFile)field.getContainingFile(), (int)field.getTextOffset());
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElement findClassByType(@JetValueParameter(name="project") Project project, @JetValueParameter(name="type") ReferenceType type2, @JetValueParameter(name="context") DebuggerContextImpl context2) {
        PsiElement element;
        DebuggerSession session = context2.getDebuggerSession();
        GlobalSearchScope scope2 = session != null ? session.getSearchScope() : GlobalSearchScope.allScope((Project)project);
        String className = JvmClassName.byInternalName(type2.name()).getFqNameForClassNameWithoutDollars().asString();
        PsiClass myClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope2);
        if (myClass != null) {
            return (PsiElement)myClass;
        }
        SourcePosition position = this.getLastSourcePosition(type2, context2);
        if (position != null && (element = position.getElementAt()) != null) {
            void $receiver;
            PsiElement psiElement = element;
            return PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetClassOrObject.class, (boolean)true);
        }
        return null;
    }

    private final SourcePosition getLastSourcePosition(@JetValueParameter(name="type") ReferenceType type2, @JetValueParameter(name="context") DebuggerContextImpl context2) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        if (debugProcess != null) {
            try {
                List<Location> locations = type2.allLineLocations();
                if (!locations.isEmpty()) {
                    Location lastLocation = locations.get(locations.size() - 1);
                    return debugProcess.getPositionManager().getSourcePosition(lastLocation);
                }
            }
            catch (AbsentInformationException ignored) {
            }
            catch (ClassNotPreparedException ignored) {
                // empty catch block
            }
        }
        return null;
    }
}

