/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.textBuilder;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.decompiler.navigation.JsMetaFileUtils;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.KotlinJavaScriptDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolverForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.TextBuilderPackage$DecompiledTextFactory$eaf906d8;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.TextBuilderPackage$DeserializerForDecompiler$0c2fb4ed;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.HeaderPackage;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererBuilder;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.dataClassUtils.DataClassUtilsPackage;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.JetScope$$TImpl;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.error.MissingDependencyErrorClass;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class TextBuilderPackage$DecompiledTextFactory$eaf906d8 {
    @NotNull
    static final String FILE_ABI_VERSION_MARKER = "FILE_ABI";
    @NotNull
    static final String CURRENT_ABI_VERSION_MARKER = "CURRENT_ABI";
    @NotNull
    static final String INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT = "// This class file was compiled with different version of Kotlin compiler and can't be decompiled.";
    @NotNull
    static final String INCOMPATIBLE_ABI_VERSION_COMMENT = "// This class file was compiled with different version of Kotlin compiler and can't be decompiled.\n//\n// Current compiler ABI version is CURRENT_ABI\n// File ABI version is FILE_ABI";
    @NotNull
    static final String DECOMPILED_CODE_COMMENT = "/* compiled code */";
    @NotNull
    static final String DECOMPILED_COMMENT_FOR_PARAMETER = "/* = compiled code */";
    @NotNull
    static final String FLEXIBLE_TYPE_COMMENT = "/* platform type */";
    @NotNull
    static final DescriptorRenderer descriptorRendererForDecompiler;
    @NotNull
    static final DescriptorRenderer descriptorRendererForKotlinJavascriptDecompiler;
    static final DescriptorRenderer descriptorRendererForKeys;

    @NotNull
    public static final String getFILE_ABI_VERSION_MARKER() {
        return FILE_ABI_VERSION_MARKER;
    }

    @NotNull
    public static final String getCURRENT_ABI_VERSION_MARKER() {
        return CURRENT_ABI_VERSION_MARKER;
    }

    @NotNull
    public static final String getINCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT() {
        return INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT;
    }

    @NotNull
    public static final String getINCOMPATIBLE_ABI_VERSION_COMMENT() {
        return INCOMPATIBLE_ABI_VERSION_COMMENT;
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@JetValueParameter(name="classFile") @NotNull VirtualFile classFile, @JetValueParameter(name="resolver") @NotNull ResolverForDecompiler resolver) {
        DecompiledText decompiledText2;
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        KotlinJvmBinaryClass kotlinClass = KotlinBinaryClassCache.getKotlinBinaryClass(classFile);
        boolean value2 = kotlinClass != null;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value2) {
            String message = "Decompiled data factory shouldn't be called on an unsupported file: " + classFile;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass = kotlinClass;
        if (kotlinJvmBinaryClass == null) {
            Intrinsics.throwNpe();
        }
        ClassId classId = kotlinJvmBinaryClass.getClassId();
        KotlinClassHeader classHeader = kotlinClass.getClassHeader();
        FqName packageFqName = classId.getPackageFqName();
        if (!classHeader.getIsCompatibleAbiVersion()) {
            decompiledText2 = new DecompiledText(KotlinPackage.replace$default((String)KotlinPackage.replace$default((String)INCOMPATIBLE_ABI_VERSION_COMMENT, (String)CURRENT_ABI_VERSION_MARKER, (String)String.valueOf(JvmAbi.VERSION), (boolean)false, (int)4), (String)FILE_ABI_VERSION_MARKER, (String)String.valueOf(classHeader.getVersion()), (boolean)false, (int)4), KotlinPackage.mapOf());
        } else if (HeaderPackage.isCompatiblePackageFacadeKind(classHeader)) {
            FqName fqName2 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
            FqName fqName3 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"packageFqName");
            decompiledText2 = TextBuilderPackage$DecompiledTextFactory$eaf906d8.buildDecompiledText$default(fqName2, new ArrayList<DeclarationDescriptor>(resolver.resolveDeclarationsInPackage(fqName3)), null, 4);
        } else if (HeaderPackage.isCompatibleClassKind(classHeader)) {
            FqName fqName4 = packageFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"packageFqName");
            ClassId classId2 = classId;
            Intrinsics.checkExpressionValueIsNotNull((Object)classId2, (String)"classId");
            decompiledText2 = TextBuilderPackage$DecompiledTextFactory$eaf906d8.buildDecompiledText$default(fqName4, KotlinPackage.filterNotNull((Iterable)KotlinPackage.listOf((Object)resolver.resolveTopLevelClass(classId2))), null, 4);
        } else {
            throw (Throwable)new UnsupportedOperationException("Unknown header kind: " + (Object)((Object)classHeader.getKind()) + " " + classHeader.getIsCompatibleAbiVersion());
        }
        return decompiledText2;
    }

    @NotNull
    public static /* synthetic */ DecompiledText buildDecompiledText$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n) {
        if ((n & 2) != 0) {
            resolverForDecompiler = TextBuilderPackage$DeserializerForDecompiler$0c2fb4ed.DeserializerForDecompiler(virtualFile);
        }
        return TextBuilderPackage$DecompiledTextFactory$eaf906d8.buildDecompiledText(virtualFile, resolverForDecompiler);
    }

    @NotNull
    public static final DecompiledText buildDecompiledTextFromJsMetadata(@JetValueParameter(name="classFile") @NotNull VirtualFile classFile, @JetValueParameter(name="resolver") @NotNull ResolverForDecompiler resolver) {
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        FqName packageFqName = JsMetaFileUtils.INSTANCE$.getPackageFqName(classFile);
        boolean isPackageHeader = JsMetaFileUtils.INSTANCE$.isPackageHeader(classFile);
        if (isPackageHeader) {
            List list = new ArrayList<DeclarationDescriptor>(resolver.resolveDeclarationsInPackage(packageFqName));
            DescriptorRenderer descriptorRenderer = descriptorRendererForKotlinJavascriptDecompiler;
            Intrinsics.checkExpressionValueIsNotNull((Object)descriptorRenderer, (String)"descriptorRendererForKotlinJavascriptDecompiler");
            return TextBuilderPackage$DecompiledTextFactory$eaf906d8.buildDecompiledText(packageFqName, list, descriptorRenderer);
        }
        ClassId classId = JsMetaFileUtils.INSTANCE$.getClassId(classFile);
        List list = KotlinPackage.filterNotNull((Iterable)KotlinPackage.listOf((Object)resolver.resolveTopLevelClass(classId)));
        DescriptorRenderer descriptorRenderer = descriptorRendererForKotlinJavascriptDecompiler;
        Intrinsics.checkExpressionValueIsNotNull((Object)descriptorRenderer, (String)"descriptorRendererForKotlinJavascriptDecompiler");
        return TextBuilderPackage$DecompiledTextFactory$eaf906d8.buildDecompiledText(packageFqName, list, descriptorRenderer);
    }

    @NotNull
    public static /* synthetic */ DecompiledText buildDecompiledTextFromJsMetadata$default(VirtualFile virtualFile, ResolverForDecompiler resolverForDecompiler, int n) {
        if ((n & 2) != 0) {
            resolverForDecompiler = new KotlinJavaScriptDeserializerForDecompiler(virtualFile);
        }
        return TextBuilderPackage$DecompiledTextFactory$eaf906d8.buildDecompiledTextFromJsMetadata(virtualFile, resolverForDecompiler);
    }

    @NotNull
    public static final String getDECOMPILED_CODE_COMMENT() {
        return DECOMPILED_CODE_COMMENT;
    }

    @NotNull
    public static final String getDECOMPILED_COMMENT_FOR_PARAMETER() {
        return DECOMPILED_COMMENT_FOR_PARAMETER;
    }

    @NotNull
    public static final String getFLEXIBLE_TYPE_COMMENT() {
        return FLEXIBLE_TYPE_COMMENT;
    }

    @NotNull
    public static final DescriptorRenderer getDescriptorRendererForDecompiler() {
        return descriptorRendererForDecompiler;
    }

    @NotNull
    public static final DescriptorRenderer getDescriptorRendererForKotlinJavascriptDecompiler() {
        return descriptorRendererForKotlinJavascriptDecompiler;
    }

    public static final DescriptorRenderer getDescriptorRendererForKeys() {
        return descriptorRendererForKeys;
    }

    @NotNull
    public static final String descriptorToKey(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        String string = descriptorRendererForKeys.render(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptorRendererForKeys.render(descriptor)");
        return string;
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@JetValueParameter(name="packageFqName") @NotNull FqName packageFqName, @JetValueParameter(name="descriptors") @NotNull List<? extends DeclarationDescriptor> descriptors, @JetValueParameter(name="descriptorRenderer") @NotNull DescriptorRenderer descriptorRenderer) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull(descriptors, (String)"descriptors");
        Intrinsics.checkParameterIsNotNull((Object)descriptorRenderer, (String)"descriptorRenderer");
        StringBuilder builder = new StringBuilder();
        HashMap renderedDescriptorsToRange = new HashMap();
        Function0<Unit> appendDecompiledTextAndPackageName$ = new Function0<Unit>(builder, packageFqName){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ FqName $packageFqName;

            public final void invoke() {
                this.$builder.append("// IntelliJ API Decompiler stub source generated from a class file\n" + "// Implementation of methods is not available");
                this.$builder.append("\n\n");
                if (!this.$packageFqName.isRoot()) {
                    this.$builder.append("package ").append(this.$packageFqName).append("\n\n");
                }
            }
            {
                this.$builder = stringBuilder;
                this.$packageFqName = fqName2;
                super(0);
            }
        };
        Function3<DeclarationDescriptor, Integer, Integer, Unit> saveDescriptorToRange$ = new Function3<DeclarationDescriptor, Integer, Integer, Unit>(renderedDescriptorsToRange){
            final /* synthetic */ HashMap $renderedDescriptorsToRange;

            public final void invoke(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor2, @JetValueParameter(name="startOffset") int startOffset, @JetValueParameter(name="endOffset") int endOffset) {
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                KotlinPackage.set((Map)this.$renderedDescriptorsToRange, (Object)TextBuilderPackage$DecompiledTextFactory$eaf906d8.descriptorToKey(descriptor2), (Object)new TextRange(startOffset, endOffset));
            }
            {
                this.$renderedDescriptorsToRange = hashMap;
                super(3);
            }
        };
        Function2<DeclarationDescriptor, String, Unit> appendDescriptor$ = new Function2<DeclarationDescriptor, String, Unit>(builder, descriptorRenderer, saveDescriptorToRange$){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ DescriptorRenderer $descriptorRenderer;
            final /* synthetic */ buildDecompiledText.3 $saveDescriptorToRange;

            public final void invoke(@JetValueParameter(name="descriptor") @NotNull DeclarationDescriptor descriptor2, @JetValueParameter(name="indent") @NotNull String indent) {
                ConstructorDescriptor primaryConstructor2;
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkParameterIsNotNull((Object)indent, (String)"indent");
                if (descriptor2 instanceof MissingDependencyErrorClass) {
                    throw (Throwable)new IllegalStateException(((MissingDependencyErrorClass)((Object)descriptor2)).getClass().getSimpleName() + " cannot be rendered. FqName: " + ((MissingDependencyErrorClass)((Object)descriptor2)).getFullFqName());
                }
                int startOffset = this.$builder.length();
                String header = DescriptorUtils.isEnumEntry(descriptor2) ? descriptor2.getName().asString() : KotlinPackage.replace$default((String)this.$descriptorRenderer.render(descriptor2), (String)"= ...", (String)TextBuilderPackage$DecompiledTextFactory$eaf906d8.getDECOMPILED_COMMENT_FOR_PARAMETER(), (boolean)false, (int)4);
                this.$builder.append(header);
                int endOffset = this.$builder.length();
                if (descriptor2 instanceof CallableDescriptor && TypesPackage.isFlexible(((CallableDescriptor)descriptor2).getReturnType())) {
                    this.$builder.append(" ").append(TextBuilderPackage$DecompiledTextFactory$eaf906d8.getFLEXIBLE_TYPE_COMMENT());
                }
                if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PropertyDescriptor) {
                    DeclarationDescriptor declarationDescriptor = descriptor2;
                    if (declarationDescriptor == null) {
                        throw new TypeCastException("org.jetbrains.kotlin.descriptors.DeclarationDescriptor cannot be cast to org.jetbrains.kotlin.descriptors.MemberDescriptor");
                    }
                    if (Intrinsics.areEqual((Object)((Object)((MemberDescriptor)declarationDescriptor).getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true) {
                        if (descriptor2 instanceof FunctionDescriptor) {
                            this.$builder.append(" { ").append(TextBuilderPackage$DecompiledTextFactory$eaf906d8.getDECOMPILED_CODE_COMMENT()).append(" }");
                        } else {
                            this.$builder.append(" ").append(TextBuilderPackage$DecompiledTextFactory$eaf906d8.getDECOMPILED_CODE_COMMENT());
                        }
                        endOffset = this.$builder.length();
                    }
                } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor2)) {
                    Object firstPassed;
                    this.$builder.append(" {\n");
                    Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                    booleanRef.element = false;
                    String subindent = indent + "    ";
                    List allDescriptors2 = KotlinPackage.plus((Iterable)DescriptorUtilPackage.getSecondaryConstructors((ClassDescriptor)descriptor2), (Iterable)JetScope$$TImpl.getDescriptors$default(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), null, null, 3));
                    ClassDescriptor companionObject = ((ClassDescriptor)descriptor2).getCompanionObjectDescriptor();
                    boolean companionNeeded = companionObject != null;
                    Function0<Unit> newlineExceptFirst$ = new Function0<Unit>(this, (Ref.BooleanRef)firstPassed){
                        final /* synthetic */ buildDecompiledText.4 this$0;
                        final /* synthetic */ Ref.BooleanRef $firstPassed;

                        public final void invoke() {
                            if (this.$firstPassed.element) {
                                this.this$0.$builder.append("\n");
                            } else {
                                this.$firstPassed.element = true;
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$firstPassed = booleanRef;
                            super(0);
                        }
                    };
                    for (DeclarationDescriptor member : allDescriptors2) {
                        if (Intrinsics.areEqual((Object)member.getContainingDeclaration(), (Object)descriptor2) ^ true || Intrinsics.areEqual((Object)member, (Object)companionObject)) continue;
                        if (companionNeeded && !DescriptorUtils.isEnumEntry(member)) {
                            companionNeeded = false;
                            newlineExceptFirst$.invoke();
                            this.$builder.append(subindent);
                            DeclarationDescriptor declarationDescriptor = companionObject;
                            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"companionObject");
                            this.invoke(declarationDescriptor, subindent);
                        }
                        if (member instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)member).getKind()), (Object)((Object)CallableMemberDescriptor.Kind.DECLARATION)) ^ true) {
                            Name name2 = ((CallableMemberDescriptor)member).getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"member.getName()");
                            if (!DataClassUtilsPackage.isComponentLike(name2)) continue;
                        }
                        newlineExceptFirst$.invoke();
                        this.$builder.append(subindent);
                        this.invoke(member, subindent);
                    }
                    this.$builder.append(indent).append("}");
                    endOffset = this.$builder.length();
                    firstPassed = null;
                }
                this.$builder.append("\n");
                this.$saveDescriptorToRange.invoke(descriptor2, startOffset, endOffset);
                if (descriptor2 instanceof ClassDescriptor && (primaryConstructor2 = ((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor()) != null) {
                    this.$saveDescriptorToRange.invoke(primaryConstructor2, startOffset, endOffset);
                }
            }
            {
                this.$builder = stringBuilder;
                this.$descriptorRenderer = descriptorRenderer;
                this.$saveDescriptorToRange = var3_3;
                super(2);
            }
        };
        appendDecompiledTextAndPackageName$.invoke();
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            appendDescriptor$.invoke(declarationDescriptor, "");
            builder.append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return new DecompiledText(string, renderedDescriptorsToRange);
    }

    @NotNull
    public static /* synthetic */ DecompiledText buildDecompiledText$default(FqName fqName2, List list, DescriptorRenderer descriptorRenderer, int n) {
        if ((n & 4) != 0) {
            DescriptorRenderer descriptorRenderer2 = descriptorRendererForDecompiler;
            Intrinsics.checkExpressionValueIsNotNull((Object)descriptorRenderer2, (String)"descriptorRendererForDecompiler");
            descriptorRenderer = descriptorRenderer2;
        }
        return TextBuilderPackage$DecompiledTextFactory$eaf906d8.buildDecompiledText(fqName2, list, descriptorRenderer);
    }

    static {
        FILE_ABI_VERSION_MARKER = FILE_ABI_VERSION_MARKER;
        CURRENT_ABI_VERSION_MARKER = CURRENT_ABI_VERSION_MARKER;
        INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT = INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT;
        INCOMPATIBLE_ABI_VERSION_COMMENT = INCOMPATIBLE_ABI_VERSION_GENERAL_COMMENT + "\n" + "//\n" + ("// Current compiler ABI version is " + CURRENT_ABI_VERSION_MARKER + "\n") + ("// File ABI version is " + FILE_ABI_VERSION_MARKER);
        DECOMPILED_CODE_COMMENT = DECOMPILED_CODE_COMMENT;
        DECOMPILED_COMMENT_FOR_PARAMETER = DECOMPILED_COMMENT_FOR_PARAMETER;
        FLEXIBLE_TYPE_COMMENT = FLEXIBLE_TYPE_COMMENT;
        descriptorRendererForDecompiler = new DescriptorRendererBuilder().setWithDefinedIn(false).setClassWithPrimaryConstructor(true).setTypeNormalizer((Function1<JetType, JetType>)((Function1)descriptorRendererForDecompiler.1.INSTANCE$)).setSecondaryConstructorsAsPrimary(false).build();
        descriptorRendererForKotlinJavascriptDecompiler = new DescriptorRendererBuilder().setWithDefinedIn(false).setClassWithPrimaryConstructor(true).setSecondaryConstructorsAsPrimary(false).build();
        descriptorRendererForKeys = DescriptorRenderer.COMPACT_WITH_MODIFIERS;
    }
}

