/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.idea.editor.JetLtGtTypingUtils;
import org.jetbrains.kotlin.psi.JetFile;

public class KotlinBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean deleteGt;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset() - 1;
        this.deleteGt = c == '<' && file instanceof JetFile && JetLtGtTypingUtils.shouldAutoCloseAngleBracket(offset, editor);
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (editor.getDocument().getTextLength() <= offset) {
            return false;
        }
        char c1 = chars.charAt(offset);
        if (c == '<' && this.deleteGt) {
            if (c1 == '>') {
                JetLtGtTypingUtils.handleJetLTDeletion(editor, offset);
            }
            return true;
        }
        return false;
    }
}

