/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.SimpleColoredComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtil;

public class KotlinFindFunctionUsagesDialog
extends FindMethodUsagesDialog {
    public KotlinFindFunctionUsagesDialog(PsiMethod method, Project project, KotlinFunctionFindUsagesOptions findUsagesOptions2, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super((PsiElement)method, project, (FindUsagesOptions)findUsagesOptions2, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler);
    }

    protected KotlinFunctionFindUsagesOptions getFindUsagesOptions() {
        return (KotlinFunctionFindUsagesOptions)this.myFindUsagesOptions;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredComponent", "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindFunctionUsagesDialog", "configureLabelComponent"));
        }
        coloredComponent.append(JetRefactoringUtil.formatJavaOrLightMethod((PsiMethod)this.myPsiElement));
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = super.createFindWhatPanel();
        if (findWhatPanel != null) {
            Utils.renameCheckbox(findWhatPanel, FindBundle.message((String)"find.what.implementing.methods.checkbox", (Object[])new Object[0]), JetBundle.message("find.what.implementing.methods.checkbox", new Object[0]));
            Utils.renameCheckbox(findWhatPanel, FindBundle.message((String)"find.what.overriding.methods.checkbox", (Object[])new Object[0]), JetBundle.message("find.what.overriding.methods.checkbox", new Object[0]));
        }
        return findWhatPanel;
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        if (!Utils.renameCheckbox(optionsPanel, FindBundle.message((String)"find.options.include.overloaded.methods.checkbox", (Object[])new Object[0]), JetBundle.message("find.options.include.overloaded.methods.checkbox", new Object[0]))) {
            this.addCheckboxToPanel(JetBundle.message("find.options.include.overloaded.methods.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
    }
}

