/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

public class DeprecatedAnnotationVisitor
extends AfterAnalysisHighlightingVisitor {
    private static final TokenSet PROPERTY_SET_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{JetTokens.EQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ, JetTokens.PLUSPLUS, JetTokens.MINUSMINUS});
    private static final FqName JAVA_DEPRECATED = new FqName(Deprecated.class.getName());

    protected DeprecatedAnnotationVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitSuperExpression(@NotNull JetSuperExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "visitSuperExpression"));
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull JetReferenceExpression expression2) {
        JetCallExpression parent;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "visitReferenceExpression"));
        }
        super.visitReferenceExpression(expression2);
        if (expression2.getParent() instanceof JetThisExpression) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, this.bindingContext);
        if (resolvedCall != null && resolvedCall instanceof VariableAsFunctionResolvedCall && (parent = (JetCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetCallExpression.class)) != null) {
            this.reportAnnotationIfNeeded((PsiElement)parent, resolvedCall.getResultingDescriptor(), true);
        }
        if (expression2.getNode().getElementType() == JetNodeTypes.OPERATION_REFERENCE) {
            this.checkDeprecatedForOperations(expression2);
        } else {
            this.checkDeprecatedForReferenceExpression(expression2);
        }
    }

    private void checkDeprecatedForReferenceExpression(@NotNull JetReferenceExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkDeprecatedForReferenceExpression"));
        }
        DeclarationDescriptor target = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (target != null) {
            if (target instanceof ConstructorDescriptor) {
                this.checkConstructorDescriptor(expression2, target);
            } else if (target instanceof ClassDescriptor) {
                this.checkClassDescriptor(expression2, (ClassDescriptor)target);
            } else if (target instanceof PropertyDescriptor) {
                this.checkPropertyDescriptor(expression2, (PropertyDescriptor)target);
            } else if (target instanceof FunctionDescriptor) {
                this.checkFunctionDescriptor(expression2, target);
            }
        }
    }

    private void checkFunctionDescriptor(JetExpression expression2, DeclarationDescriptor target) {
        this.reportAnnotationIfNeeded((PsiElement)expression2, target, expression2 instanceof JetArrayAccessExpression);
    }

    private void checkConstructorDescriptor(@NotNull JetExpression expression2, @NotNull DeclarationDescriptor target) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkConstructorDescriptor"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkConstructorDescriptor"));
        }
        DeclarationDescriptor containingDeclaration = target.getContainingDeclaration();
        if (containingDeclaration != null && !this.reportAnnotationIfNeeded((PsiElement)expression2, containingDeclaration)) {
            this.reportAnnotationIfNeeded((PsiElement)expression2, target);
        }
    }

    private void checkClassDescriptor(@NotNull JetExpression expression2, @NotNull ClassDescriptor target) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkClassDescriptor"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkClassDescriptor"));
        }
        this.reportAnnotationIfNeeded((PsiElement)expression2, target);
    }

    private void checkPropertyDescriptor(@NotNull JetExpression expression2, @NotNull PropertyDescriptor propertyDescriptor) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertyDescriptor"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertyDescriptor"));
        }
        if (this.reportAnnotationIfNeeded((PsiElement)expression2, propertyDescriptor, propertyDescriptor.isVar())) {
            return;
        }
        if (!propertyDescriptor.isVar()) {
            this.checkPropertyGetter(propertyDescriptor, expression2);
        } else {
            IElementType operation = null;
            JetBinaryExpression binaryExpression = (JetBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetBinaryExpression.class);
            if (binaryExpression != null) {
                JetExpression left = binaryExpression.getLeft();
                if (left == expression2) {
                    operation = binaryExpression.getOperationToken();
                } else {
                    JetReferenceExpression[] jetReferenceExpressions = (JetReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, JetReferenceExpression.class);
                    if (jetReferenceExpressions != null) {
                        for (JetReferenceExpression expr : jetReferenceExpressions) {
                            if (expr != expression2) continue;
                            operation = binaryExpression.getOperationToken();
                            break;
                        }
                    }
                }
            } else {
                JetUnaryExpression unaryExpression = (JetUnaryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, JetUnaryExpression.class);
                if (unaryExpression != null) {
                    operation = unaryExpression.getOperationReference().getReferencedNameElementType();
                }
            }
            if (operation != null && PROPERTY_SET_OPERATIONS.contains(operation)) {
                this.checkPropertySetter(propertyDescriptor, expression2);
            } else {
                this.checkPropertyGetter(propertyDescriptor, expression2);
            }
        }
    }

    private void checkPropertySetter(@NotNull PropertyDescriptor descriptor2, @NotNull JetExpression expression2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertySetter"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertySetter"));
        }
        PropertySetterDescriptor setter = descriptor2.getSetter();
        if (setter != null) {
            this.checkPropertyAccessor(setter, expression2, true);
        }
    }

    private void checkPropertyGetter(@NotNull PropertyDescriptor descriptor2, @NotNull JetExpression expression2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertyGetter"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertyGetter"));
        }
        PropertyGetterDescriptor getter = descriptor2.getGetter();
        if (getter != null) {
            this.checkPropertyAccessor(getter, expression2, descriptor2.isVar());
        }
    }

    private void checkPropertyAccessor(@NotNull PropertyAccessorDescriptor accessor, @NotNull JetExpression expression2, boolean isCrossingDisallowed) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertyAccessor"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkPropertyAccessor"));
        }
        this.reportAnnotationIfNeeded((PsiElement)expression2, accessor, isCrossingDisallowed);
    }

    private void checkDeprecatedForOperations(@NotNull JetReferenceExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "checkDeprecatedForOperations"));
        }
        DeclarationDescriptor target = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (target != null) {
            this.reportAnnotationIfNeeded((PsiElement)expression2, target, true);
        }
    }

    private boolean reportAnnotationIfNeeded(@NotNull PsiElement element, @NotNull DeclarationDescriptor descriptor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "reportAnnotationIfNeeded"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "reportAnnotationIfNeeded"));
        }
        return this.reportAnnotationIfNeeded(element, descriptor2, false);
    }

    private boolean reportAnnotationIfNeeded(@NotNull PsiElement element, @NotNull DeclarationDescriptor descriptor2, boolean isCrossingDisallowed) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "reportAnnotationIfNeeded"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "reportAnnotationIfNeeded"));
        }
        AnnotationDescriptor deprecated2 = DeprecatedAnnotationVisitor.getDeprecated(descriptor2);
        if (deprecated2 != null) {
            if (isCrossingDisallowed) {
                this.holder.createWarningAnnotation(element, DeprecatedAnnotationVisitor.composeTooltipString(descriptor2, deprecated2)).setTextAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES);
            } else {
                this.holder.createWarningAnnotation(element, DeprecatedAnnotationVisitor.composeTooltipString(descriptor2, deprecated2)).setTextAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static AnnotationDescriptor getDeprecated(DeclarationDescriptor descriptor2) {
        AnnotationDescriptor kotlinDeprecated = descriptor2.getAnnotations().findAnnotation(KotlinBuiltIns.FQ_NAMES.deprecated);
        return kotlinDeprecated != null ? kotlinDeprecated : descriptor2.getAnnotations().findAnnotation(JAVA_DEPRECATED);
    }

    private static String composeTooltipString(@NotNull DeclarationDescriptor declarationDescriptor, @NotNull AnnotationDescriptor descriptor2) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "composeTooltipString"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "composeTooltipString"));
        }
        String fact = "'" + DeprecatedAnnotationVisitor.getDescriptorString(declarationDescriptor) + "' is deprecated.";
        String message = AnnotationsPackage.deprecatedAnnotationMessage(descriptor2);
        return message == null ? fact : fact + " " + message;
    }

    private static String getDescriptorString(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/DeprecatedAnnotationVisitor", "getDescriptorString"));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            return DescriptorUtils.getFqName(descriptor2).asString();
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            assert (containingDeclaration != null);
            return "constructor for " + containingDeclaration.getName();
        }
        if (descriptor2 instanceof PropertyGetterDescriptor) {
            return "getter for " + ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty().getName();
        }
        if (descriptor2 instanceof PropertySetterDescriptor) {
            return "setter for " + ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty().getName();
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            if (((PropertyDescriptor)descriptor2).isVar()) {
                return "var " + descriptor2.getName();
            }
            return "val " + descriptor2.getName();
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            return "fun " + descriptor2.getName() + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderFunctionParameters((FunctionDescriptor)descriptor2);
        }
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.render(descriptor2);
    }
}

