/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ktSignature;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.ktSignature.EditSignatureBalloon;
import org.jetbrains.kotlin.idea.ktSignature.KotlinSignatureUtil;

public class EditSignatureAction
extends AnAction {
    private final PsiModifierListOwner elementInEditor;

    public EditSignatureAction(@NotNull PsiModifierListOwner elementInEditor) {
        if (elementInEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInEditor", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureAction", "<init>"));
        }
        super(KotlinSignatureUtil.isAnnotationEditable((PsiElement)elementInEditor) ? "Edit" : "View");
        this.elementInEditor = elementInEditor;
    }

    public void actionPerformed(AnActionEvent e) {
        this.actionPerformed(e.getDataContext(), null);
    }

    public void actionPerformed(@NotNull DataContext dataContext, @Nullable Point point) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureAction", "actionPerformed"));
        }
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        assert (editor != null);
        EditSignatureAction.invokeEditSignature((PsiElement)this.elementInEditor, editor, point);
    }

    static void invokeEditSignature(@NotNull PsiElement elementInEditor, @NotNull Editor editor, @Nullable Point point) {
        if (elementInEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInEditor", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureAction", "invokeEditSignature"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/ktSignature/EditSignatureAction", "invokeEditSignature"));
        }
        PsiAnnotation annotation2 = KotlinSignatureUtil.findKotlinSignatureAnnotation(elementInEditor);
        assert (annotation2 != null);
        if (annotation2.getContainingFile() == elementInEditor.getContainingFile()) {
            for (PsiNameValuePair pair2 : annotation2.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue value2;
                if (pair2.getName() != null && !"value".equals(pair2.getName()) || (value2 = pair2.getValue()) == null) continue;
                VirtualFile virtualFile = value2.getContainingFile().getVirtualFile();
                assert (virtualFile != null);
                PsiElement firstChild = value2.getFirstChild();
                if (firstChild != null && firstChild.getNode().getElementType() == JavaTokenType.STRING_LITERAL) {
                    new OpenFileDescriptor(value2.getProject(), virtualFile, value2.getTextOffset() + 1).navigate(true);
                    continue;
                }
                NavigationUtil.activateFileWithPsiElement((PsiElement)value2);
            }
        } else {
            PsiMember annotationOwner = KotlinSignatureUtil.getAnalyzableAnnotationOwner(elementInEditor);
            boolean editable = KotlinSignatureUtil.isAnnotationEditable(elementInEditor);
            EditSignatureBalloon balloon = new EditSignatureBalloon((PsiModifierListOwner)annotationOwner, KotlinSignatureUtil.getKotlinSignature(annotation2), editable, annotation2.getQualifiedName());
            balloon.show(point, editor, elementInEditor);
        }
    }
}

