/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.types.JetType;

public class ChangeTypeFix
extends JetIntentionAction<JetTypeReference> {
    private final JetType type;
    private final String renderedType;

    public ChangeTypeFix(@NotNull JetTypeReference element, JetType type2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix", "<init>"));
        }
        super(element);
        this.type = type2;
        this.renderedType = IdeDescriptorRenderers.SOURCE_CODE.renderType(type2);
    }

    @NotNull
    public String getText() {
        String currentTypeText = ((JetTypeReference)this.element).getText();
        String string = JetBundle.message("change.type", currentTypeText, QuickFixUtil.renderTypeWithFqNameOnClash(this.type, currentTypeText));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix", "invoke"));
        }
        JetTypeReference newTypeRef = (JetTypeReference)((JetTypeReference)this.element).replace((PsiElement)PsiPackage.JetPsiFactory((PsiElement)file).createType(this.renderedType));
        ShortenReferences.DEFAULT.process(newTypeRef);
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForExpectedParameterTypeMismatch() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix$1", "createAction"));
                }
                DiagnosticWithParameters1 diagnosticWithParameters = (DiagnosticWithParameters1)Errors.EXPECTED_PARAMETER_TYPE_MISMATCH.cast(diagnostic);
                JetTypeReference typeReference = ((JetParameter)diagnosticWithParameters.getPsiElement()).getTypeReference();
                assert (typeReference != null) : "EXPECTED_PARAMETER_TYPE_MISMATCH reported on parameter without explicitly declared type";
                return new ChangeTypeFix(typeReference, (JetType)diagnosticWithParameters.getA());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix", "createFactoryForExpectedParameterTypeMismatch"));
        }
        return jetSingleIntentionActionFactory;
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactoryForExpectedReturnTypeMismatch() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix$2", "createAction"));
                }
                DiagnosticWithParameters1 diagnosticWithParameters = (DiagnosticWithParameters1)Errors.EXPECTED_RETURN_TYPE_MISMATCH.cast(diagnostic);
                return new ChangeTypeFix((JetTypeReference)diagnosticWithParameters.getPsiElement(), (JetType)diagnosticWithParameters.getA());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeTypeFix", "createFactoryForExpectedReturnTypeMismatch"));
        }
        return jetSingleIntentionActionFactory;
    }
}

