/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.JetKeywordToken;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.types.Variance;

public class RemoveModifierFix
extends JetIntentionAction<JetModifierListOwner> {
    private final JetModifierKeywordToken modifier;
    private final boolean isRedundant;

    public RemoveModifierFix(@NotNull JetModifierListOwner element, @NotNull JetModifierKeywordToken modifier, boolean isRedundant) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "<init>"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "<init>"));
        }
        super(element);
        this.modifier = modifier;
        this.isRedundant = isRedundant;
    }

    private static String makeText(@Nullable JetModifierListOwner element, JetKeywordToken modifier, boolean isRedundant) {
        if (isRedundant) {
            return JetBundle.message("remove.redundant.modifier", modifier.getValue());
        }
        if (element != null && (modifier == JetTokens.ABSTRACT_KEYWORD || modifier == JetTokens.OPEN_KEYWORD)) {
            return JetBundle.message("make.element.not.modifier", AddModifierFix.getElementName(element), modifier.getValue());
        }
        return JetBundle.message("remove.modifier", modifier.getValue());
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("remove.modifier.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    private static <T extends JetModifierListOwner> T removeModifier(T element, JetModifierKeywordToken modifier) {
        JetModifierList modifierList = element.getModifierList();
        assert (modifierList != null);
        RemoveModifierFix.removeModifierFromList(modifierList, modifier);
        if (modifierList.getFirstChild() == null) {
            PsiElement whiteSpace = modifierList.getNextSibling();
            assert (element instanceof ASTDelegatePsiElement);
            ((ASTDelegatePsiElement)element).deleteChildInternal(modifierList.getNode());
            QuickFixUtil.removePossiblyWhiteSpace((ASTDelegatePsiElement)element, whiteSpace);
        }
        T t = element;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "removeModifier"));
        }
        return t;
    }

    @NotNull
    private static JetModifierList removeModifierFromList(@NotNull JetModifierList modifierList, JetModifierKeywordToken modifier) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "removeModifierFromList"));
        }
        assert (modifierList.hasModifier(modifier));
        ASTNode modifierNode = modifierList.getModifierNode(modifier);
        PsiElement whiteSpace = modifierNode.getPsi().getNextSibling();
        boolean wsRemoved = QuickFixUtil.removePossiblyWhiteSpace((ASTDelegatePsiElement)modifierList, whiteSpace);
        modifierList.deleteChildInternal(modifierNode);
        if (!wsRemoved) {
            QuickFixUtil.removePossiblyWhiteSpace((ASTDelegatePsiElement)modifierList, modifierList.getLastChild());
        }
        JetModifierList jetModifierList = modifierList;
        if (jetModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "removeModifierFromList"));
        }
        return jetModifierList;
    }

    @NotNull
    public String getText() {
        String string = RemoveModifierFix.makeText((JetModifierListOwner)this.element, this.modifier, this.isRedundant);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "getText"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix", "invoke"));
        }
        this.invoke();
    }

    public void invoke() throws IncorrectOperationException {
        JetModifierListOwner newElement = (JetModifierListOwner)((JetModifierListOwner)this.element).copy();
        ((JetModifierListOwner)this.element).replace(RemoveModifierFix.removeModifier(newElement, this.modifier));
    }

    public static JetSingleIntentionActionFactory createRemoveModifierFromListOwnerFactory(JetModifierKeywordToken modifier) {
        return RemoveModifierFix.createRemoveModifierFromListOwnerFactory(modifier, false);
    }

    public static JetSingleIntentionActionFactory createRemoveModifierFromListOwnerFactory(final JetModifierKeywordToken modifier, final boolean isRedundant) {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public JetIntentionAction<JetModifierListOwner> createAction(Diagnostic diagnostic) {
                JetModifierListOwner modifierListOwner = QuickFixUtil.getParentElementOfType(diagnostic, JetModifierListOwner.class);
                if (modifierListOwner == null) {
                    return null;
                }
                return new RemoveModifierFix(modifierListOwner, modifier, isRedundant);
            }
        };
    }

    public static JetSingleIntentionActionFactory createRemoveModifierFactory() {
        return RemoveModifierFix.createRemoveModifierFactory(false);
    }

    public static JetSingleIntentionActionFactory createRemoveModifierFactory(final boolean isRedundant) {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public JetIntentionAction<JetModifierListOwner> createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/RemoveModifierFix$2", "createAction"));
                }
                JetModifierListOwner modifierListOwner = QuickFixUtil.getParentElementOfType(diagnostic, JetModifierListOwner.class);
                if (modifierListOwner == null) {
                    return null;
                }
                PsiElement psiElement = diagnostic.getPsiElement();
                IElementType elementType = psiElement.getNode().getElementType();
                if (!(elementType instanceof JetModifierKeywordToken)) {
                    return null;
                }
                JetModifierKeywordToken modifier = (JetModifierKeywordToken)elementType;
                return new RemoveModifierFix(modifierListOwner, modifier, isRedundant);
            }
        };
    }

    public static JetSingleIntentionActionFactory createRemoveProjectionFactory(final boolean isRedundant) {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public JetIntentionAction<JetModifierListOwner> createAction(Diagnostic diagnostic) {
                JetTypeProjection projection = QuickFixUtil.getParentElementOfType(diagnostic, JetTypeProjection.class);
                if (projection == null) {
                    return null;
                }
                ASTNode projectionAstNode = projection.getProjectionNode();
                if (projectionAstNode == null) {
                    return null;
                }
                IElementType elementType = projectionAstNode.getElementType();
                if (!(elementType instanceof JetModifierKeywordToken)) {
                    return null;
                }
                JetModifierKeywordToken variance = (JetModifierKeywordToken)elementType;
                return new RemoveModifierFix(projection, variance, isRedundant);
            }
        };
    }

    public static JetSingleIntentionActionFactory createRemoveVarianceFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public JetIntentionAction<JetModifierListOwner> createAction(Diagnostic diagnostic) {
                JetModifierKeywordToken modifier;
                JetModifierListOwner modifierListOwner = QuickFixUtil.getParentElementOfType(diagnostic, JetModifierListOwner.class);
                if (modifierListOwner == null) {
                    return null;
                }
                PsiElement psiElement = diagnostic.getPsiElement();
                if (!(psiElement instanceof JetTypeParameter)) {
                    return null;
                }
                JetTypeParameter parameter = (JetTypeParameter)psiElement;
                Variance variance = parameter.getVariance();
                switch (variance) {
                    case IN_VARIANCE: {
                        modifier = JetTokens.IN_KEYWORD;
                        break;
                    }
                    case OUT_VARIANCE: {
                        modifier = JetTokens.OUT_KEYWORD;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new RemoveModifierFix(modifierListOwner, modifier, false);
            }
        };
    }
}

