/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

public class ReplaceInfixCallFix
extends JetIntentionAction<JetBinaryExpression> {
    public ReplaceInfixCallFix(@NotNull JetBinaryExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ReplaceInfixCallFix", "<init>"));
        }
        super(element);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("replace.with.safe.call", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ReplaceInfixCallFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ReplaceInfixCallFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ReplaceInfixCallFix", "invoke"));
        }
        JetExpression left = ((JetBinaryExpression)this.element).getLeft();
        JetExpression right = ((JetBinaryExpression)this.element).getRight();
        assert (left != null && right != null) : "Preconditions checked by factory";
        String newText = left.getText() + "?." + ((JetBinaryExpression)this.element).getOperationReference().getText() + "(" + right.getText() + ")";
        JetQualifiedExpression newElement = (JetQualifiedExpression)PsiPackage.JetPsiFactory((PsiElement)file).createExpression(newText);
        ((JetBinaryExpression)this.element).replace((PsiElement)newElement);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    public static JetSingleIntentionActionFactory createFactory() {
        return new JetSingleIntentionActionFactory(){

            @Override
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetBinaryExpression expression2 = QuickFixUtil.getParentElementOfType(diagnostic, JetBinaryExpression.class);
                if (expression2 == null) {
                    return null;
                }
                if (expression2.getLeft() == null) {
                    return null;
                }
                if (expression2.getRight() == null) {
                    return null;
                }
                return new ReplaceInfixCallFix(expression2);
            }
        };
    }
}

