/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;

public abstract class ReplaceOperationInBinaryExpressionFix<T extends JetExpression>
extends JetIntentionAction<T> {
    private final String operation;

    public ReplaceOperationInBinaryExpressionFix(@NotNull T element, String operation) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ReplaceOperationInBinaryExpressionFix", "<init>"));
        }
        super(element);
        this.operation = operation;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("replace.operation.in.binary.expression", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ReplaceOperationInBinaryExpressionFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ReplaceOperationInBinaryExpressionFix", "invoke"));
        }
        if (this.element instanceof JetBinaryExpressionWithTypeRHS) {
            JetExpression left = ((JetBinaryExpressionWithTypeRHS)this.element).getLeft();
            JetTypeReference right = ((JetBinaryExpressionWithTypeRHS)this.element).getRight();
            if (right != null) {
                JetExpression expression2 = PsiPackage.JetPsiFactory((PsiElement)file).createExpression(left.getText() + this.operation + right.getText());
                ((JetExpression)this.element).replace((PsiElement)expression2);
            }
        }
    }
}

