/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.StringTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetCallableParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;

public class JetFunctionParameterTableModel
extends JetCallableParameterTableModel {
    public JetFunctionParameterTableModel(JetMethodDescriptor methodDescriptor, PsiElement context2) {
        super(methodDescriptor, context2, new ColumnInfo[]{new ParameterTableModelBase.NameColumn(context2.getProject()), new ParameterTableModelBase.TypeColumn(context2.getProject(), (FileType)JetFileType.INSTANCE), new ParameterTableModelBase.DefaultValueColumn(context2.getProject(), (FileType)JetFileType.INSTANCE), new ReceiverColumn(context2.getProject(), methodDescriptor)});
    }

    @Override
    @Nullable
    public JetParameterInfo getReceiver() {
        return ((ReceiverColumn)this.getColumnInfos()[this.getColumnCount() - 1]).receiver;
    }

    public void setReceiver(@Nullable JetParameterInfo receiver) {
        ((ReceiverColumn)this.getColumnInfos()[this.getColumnCount() - 1]).receiver = receiver;
    }

    public static boolean isReceiverColumn(ColumnInfo column) {
        return column instanceof ReceiverColumn;
    }

    protected static class ReceiverColumn<TableItem extends ParameterTableModelItemBase<JetParameterInfo>>
    extends ParameterTableModelBase.ColumnInfoBase<JetParameterInfo, TableItem, Boolean> {
        private final Project project;
        @Nullable
        private JetParameterInfo receiver;

        public ReceiverColumn(Project project, @Nullable JetMethodDescriptor methodDescriptor) {
            super("Receiver:");
            this.project = project;
            this.receiver = methodDescriptor != null ? methodDescriptor.getReceiver() : null;
        }

        public Boolean valueOf(TableItem item) {
            return ((ParameterTableModelItemBase)item).parameter == this.receiver;
        }

        public void setValue(TableItem item, Boolean value2) {
            if (value2 == null) {
                return;
            }
            this.receiver = value2 != false ? (JetParameterInfo)((ParameterTableModelItemBase)item).parameter : null;
        }

        public boolean isCellEditable(TableItem pParameterTableModelItemBase) {
            return true;
        }

        public TableCellRenderer doCreateRenderer(TableItem item) {
            return new BooleanTableCellRenderer();
        }

        public TableCellEditor doCreateEditor(TableItem o) {
            return new StringTableCellEditor(this.project);
        }
    }
}

