/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.usages;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.codeInsight.shorten.ShortenPackage;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtil;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetUsageInfo;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitutor;

public class JetFunctionDefinitionUsage<T extends PsiElement>
extends JetUsageInfo<T> {
    @NotNull
    private final FunctionDescriptor originalFunctionDescriptor;
    private FunctionDescriptor currentFunctionDescriptor;
    @NotNull
    private final JetFunctionDefinitionUsage<? extends PsiElement> baseFunction;
    private final boolean hasExpectedType;
    @Nullable
    private final JetType samCallType;
    @Nullable
    private TypeSubstitutor typeSubstitutor;

    public JetFunctionDefinitionUsage(@NotNull T function2, @NotNull FunctionDescriptor originalFunctionDescriptor, @Nullable JetFunctionDefinitionUsage<PsiElement> baseFunction, @Nullable JetType samCallType) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionDefinitionUsage", "<init>"));
        }
        if (originalFunctionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFunctionDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionDefinitionUsage", "<init>"));
        }
        super(function2);
        this.originalFunctionDescriptor = originalFunctionDescriptor;
        this.baseFunction = baseFunction != null ? baseFunction : this;
        this.hasExpectedType = JetFunctionDefinitionUsage.checkIfHasExpectedType(originalFunctionDescriptor, this.isInherited());
        this.samCallType = samCallType;
    }

    private static boolean checkIfHasExpectedType(@NotNull FunctionDescriptor functionDescriptor, boolean isInherited) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionDefinitionUsage", "checkIfHasExpectedType"));
        }
        if (!(functionDescriptor instanceof AnonymousFunctionDescriptor) || !isInherited) {
            return false;
        }
        JetFunctionLiteral functionLiteral = (JetFunctionLiteral)DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor);
        assert (functionLiteral != null) : "No declaration found for " + functionDescriptor;
        PsiElement parent = functionLiteral.getParent();
        if (!(parent instanceof JetFunctionLiteralExpression)) {
            return false;
        }
        JetFunctionLiteralExpression expression2 = (JetFunctionLiteralExpression)parent;
        return ResolvePackage.analyze(expression2, BodyResolveMode.PARTIAL).get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2) != null;
    }

    @NotNull
    public JetFunctionDefinitionUsage getBaseFunction() {
        JetFunctionDefinitionUsage<? extends PsiElement> jetFunctionDefinitionUsage = this.baseFunction;
        if (jetFunctionDefinitionUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionDefinitionUsage", "getBaseFunction"));
        }
        return jetFunctionDefinitionUsage;
    }

    @NotNull
    public PsiElement getDeclaration() {
        Object t = this.getElement();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionDefinitionUsage", "getDeclaration"));
        }
        return t;
    }

    @Nullable
    public TypeSubstitutor getOrCreateTypeSubstitutor() {
        if (!this.isInherited()) {
            return null;
        }
        if (this.typeSubstitutor == null) {
            if (this.samCallType == null) {
                this.typeSubstitutor = ChangeSignaturePackage.getFunctionSubstitutor(this.baseFunction, this);
            } else {
                DeclarationDescriptor classDescriptor;
                FunctionDescriptor currentBaseDescriptor = this.baseFunction.getCurrentFunctionDescriptor();
                DeclarationDescriptor declarationDescriptor = classDescriptor = currentBaseDescriptor != null ? currentBaseDescriptor.getContainingDeclaration() : null;
                if (!(classDescriptor instanceof ClassDescriptor)) {
                    return null;
                }
                this.typeSubstitutor = ChangeSignaturePackage.getTypeSubstitutor(((ClassDescriptor)classDescriptor).getDefaultType(), this.samCallType);
            }
        }
        return this.typeSubstitutor;
    }

    public final boolean isInherited() {
        return this.baseFunction != this;
    }

    public boolean hasExpectedType() {
        return this.hasExpectedType;
    }

    @NotNull
    public final FunctionDescriptor getOriginalFunctionDescriptor() {
        FunctionDescriptor functionDescriptor = this.originalFunctionDescriptor;
        if (functionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionDefinitionUsage", "getOriginalFunctionDescriptor"));
        }
        return functionDescriptor;
    }

    @Nullable
    public final FunctionDescriptor getCurrentFunctionDescriptor() {
        if (this.currentFunctionDescriptor == null) {
            PsiElement element = this.getDeclaration();
            if (element instanceof JetFunction) {
                this.currentFunctionDescriptor = (FunctionDescriptor)ResolvePackage.resolveToDescriptor((JetFunction)element);
            } else if (element instanceof JetClass) {
                this.currentFunctionDescriptor = ((ClassDescriptor)ResolvePackage.resolveToDescriptor((JetClass)element)).getUnsubstitutedPrimaryConstructor();
            } else if (element instanceof PsiMethod) {
                this.currentFunctionDescriptor = ResolvePackage.getJavaMethodDescriptor((PsiMethod)element);
            }
        }
        return this.currentFunctionDescriptor;
    }

    @Override
    public boolean processUsage(JetChangeInfo changeInfo, PsiElement element) {
        String receiverTypeText;
        JetTypeReference receiverTypeRef;
        JetTypeReference newReceiverTypeRef;
        JetParameterList parameterList2;
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(element.getProject());
        if (element instanceof JetFunction) {
            boolean returnTypeIsNeeded;
            PsiElement identifier;
            JetFunction function2 = (JetFunction)element;
            parameterList2 = function2.getValueParameterList();
            if (changeInfo.isNameChanged() && (identifier = function2.getNameIdentifier()) != null) {
                identifier.replace(psiFactory.createIdentifier(changeInfo.getNewName()));
            }
            boolean bl = returnTypeIsNeeded = (changeInfo.isRefactoringTarget(this.originalFunctionDescriptor) || !(function2 instanceof JetFunctionLiteral) || function2.getTypeReference() != null) && !(function2 instanceof JetSecondaryConstructor);
            if (changeInfo.isReturnTypeChanged() && returnTypeIsNeeded) {
                function2.setTypeReference(null);
                String returnTypeText = changeInfo.renderReturnType(this);
                if (!KotlinBuiltIns.getInstance().getUnitType().toString().equals(returnTypeText)) {
                    ShortenPackage.addToShorteningWaitSet(function2.setTypeReference(PsiPackage.JetPsiFactory(function2).createType(returnTypeText)), ShortenReferences.Options.DEFAULT);
                }
            }
        } else {
            parameterList2 = ((JetClass)element).getPrimaryConstructorParameterList();
        }
        if (changeInfo.isParameterSetOrOrderChanged()) {
            this.processParameterListWithStructuralChanges(changeInfo, element, parameterList2, psiFactory);
        } else if (parameterList2 != null) {
            int paramIndex = 0;
            for (JetParameter parameter : parameterList2.getParameters()) {
                JetParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex];
                this.changeParameter(paramIndex, parameter, parameterInfo);
                ++paramIndex;
            }
            ShortenPackage.addToShorteningWaitSet(parameterList2, ShortenReferences.Options.DEFAULT);
        }
        if (element instanceof JetFunction && changeInfo.isReceiverTypeChanged() && (newReceiverTypeRef = TypeRefHelpersPackage.setReceiverTypeReference((JetFunction)element, receiverTypeRef = (receiverTypeText = changeInfo.renderReceiverType(this)) != null ? psiFactory.createType(receiverTypeText) : null)) != null) {
            ShortenPackage.addToShorteningWaitSet(newReceiverTypeRef, ShortenReferences.Options.DEFAULT);
        }
        if (changeInfo.isVisibilityChanged() && !JetPsiUtil.isLocal((JetDeclaration)element)) {
            JetFunctionDefinitionUsage.changeVisibility(changeInfo, element);
        }
        return true;
    }

    private void processParameterListWithStructuralChanges(JetChangeInfo changeInfo, PsiElement element, JetParameterList parameterList2, JetPsiFactory psiFactory) {
        int parametersCount = changeInfo.getNonReceiverParametersCount();
        boolean isLambda = element instanceof JetFunctionLiteral;
        boolean canReplaceEntireList = false;
        JetParameterList newParameterList = null;
        if (isLambda) {
            if (parametersCount == 0 && ((JetFunctionLiteral)element).getTypeReference() == null) {
                if (parameterList2 != null) {
                    parameterList2.delete();
                    PsiElement arrow = ((JetFunctionLiteral)element).getArrow();
                    if (arrow != null) {
                        arrow.delete();
                    }
                    parameterList2 = null;
                }
            } else {
                newParameterList = psiFactory.createFunctionLiteralParameterList(changeInfo.getNewParametersSignature(this));
                canReplaceEntireList = true;
            }
        } else {
            newParameterList = psiFactory.createParameterList(changeInfo.getNewParametersSignature(this));
        }
        if (newParameterList == null) {
            return;
        }
        if (parameterList2 != null) {
            newParameterList = canReplaceEntireList ? (JetParameterList)parameterList2.replace((PsiElement)newParameterList) : JetFunctionDefinitionUsage.replaceParameterListAndKeepDelimiters(parameterList2, newParameterList);
        } else if (element instanceof JetClass) {
            JetTypeParameterList anchor2 = ((JetClass)element).getTypeParameterList();
            if (anchor2 == null) {
                anchor2 = ((JetClass)element).getNameIdentifier();
            }
            if (anchor2 != null) {
                JetPrimaryConstructor constructor2 = (JetPrimaryConstructor)element.addAfter((PsiElement)psiFactory.createPrimaryConstructor(), (PsiElement)anchor2);
                JetParameterList oldParameterList = constructor2.getValueParameterList();
                assert (oldParameterList != null) : "primary constructor from factory has parameter list";
                newParameterList = (JetParameterList)oldParameterList.replace((PsiElement)newParameterList);
            }
        } else if (isLambda) {
            JetFunctionLiteral functionLiteral = (JetFunctionLiteral)element;
            PsiElement anchor3 = functionLiteral.getLBrace();
            newParameterList = (JetParameterList)element.addAfter((PsiElement)newParameterList, anchor3);
            if (functionLiteral.getArrow() == null) {
                Pair<PsiElement, PsiElement> whitespaceAndArrow = psiFactory.createWhitespaceAndArrow();
                element.addRangeAfter((PsiElement)whitespaceAndArrow.getFirst(), (PsiElement)whitespaceAndArrow.getSecond(), (PsiElement)newParameterList);
            }
        }
        if (newParameterList != null) {
            ShortenPackage.addToShorteningWaitSet(newParameterList, ShortenReferences.Options.DEFAULT);
        }
    }

    private static JetParameterList replaceParameterListAndKeepDelimiters(JetParameterList parameterList2, JetParameterList newParameterList) {
        List<JetParameter> oldParameters = parameterList2.getParameters();
        List<JetParameter> newParameters = newParameterList.getParameters();
        int oldCount = oldParameters.size();
        int newCount = newParameters.size();
        int commonCount = Math.min(oldCount, newCount);
        for (int i = 0; i < commonCount; ++i) {
            oldParameters.set(i, (JetParameter)oldParameters.get(i).replace(newParameters.get(i)));
        }
        if (commonCount == 0) {
            return (JetParameterList)parameterList2.replace((PsiElement)newParameterList);
        }
        if (oldCount > commonCount) {
            parameterList2.deleteChildRange(oldParameters.get(commonCount - 1).getNextSibling(), (PsiElement)KotlinPackage.last(oldParameters));
        } else if (newCount > commonCount) {
            parameterList2.addRangeAfter(newParameters.get(commonCount - 1).getNextSibling(), newParameterList.getLastChild().getPrevSibling(), PsiTreeUtil.skipSiblingsBackward((PsiElement)parameterList2.getLastChild(), (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}));
        }
        return parameterList2;
    }

    private static void changeVisibility(JetChangeInfo changeInfo, PsiElement element) {
        JetModifierKeywordToken newVisibilityToken = JetRefactoringUtil.getVisibilityToken(changeInfo.getNewVisibility());
        if (element instanceof JetFunction) {
            ((JetFunction)element).addModifier(newVisibilityToken);
        } else {
            JetPrimaryConstructor constructor2 = ((JetClass)element).getPrimaryConstructor();
            assert (constructor2 != null) : "Primary constructor should be created before changing visibility";
            constructor2.addModifier(newVisibilityToken);
        }
    }

    private void changeParameter(int parameterIndex, JetParameter parameter, JetParameterInfo parameterInfo) {
        PsiElement identifier;
        ASTNode valOrVarAstNode = parameter.getValOrVarNode();
        PsiElement valOrVarNode = valOrVarAstNode != null ? valOrVarAstNode.getPsi() : null;
        JetValVar valOrVar = parameterInfo.getValOrVar();
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory(this.getProject());
        if (valOrVarNode != null) {
            if (valOrVar == JetValVar.None) {
                valOrVarNode.delete();
            } else {
                valOrVarNode.replace(psiFactory.createValOrVarNode(valOrVar.toString()).getPsi());
            }
        } else if (valOrVar != JetValVar.None) {
            PsiElement firstChild = parameter.getFirstChild();
            parameter.addBefore(psiFactory.createValOrVarNode(valOrVar.toString()).getPsi(), firstChild);
            parameter.addBefore(psiFactory.createWhiteSpace(), firstChild);
        }
        if (parameterInfo.getIsTypeChanged() && parameter.getTypeReference() != null) {
            String renderedType = parameterInfo.renderType(parameterIndex, this);
            parameter.setTypeReference(psiFactory.createType(renderedType));
        }
        if ((identifier = parameter.getNameIdentifier()) != null) {
            String newName = parameterInfo.getInheritedName(this);
            identifier.replace(psiFactory.createIdentifier(newName));
        }
    }
}

