/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.search.AnnotatedElementsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolvePackage;
import org.jetbrains.kotlin.idea.stubindex.JetAnnotationsIndex;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public class KotlinAnnotatedElementsSearcher
extends AnnotatedElementsSearcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.AnnotatedMembersSearcher");

    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, final @NotNull Processor<PsiModifierListOwner> consumer2) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAnnotatedElementsSearcher", "execute"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinAnnotatedElementsSearcher", "execute"));
        }
        PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated members search";
        final String annotationFQN = annClass.getQualifiedName();
        assert (annotationFQN != null);
        SearchScope useScope = p.getScope();
        for (final PsiElement psiElement : KotlinAnnotatedElementsSearcher.getJetAnnotationCandidates(annClass, useScope)) {
            if (KotlinAnnotatedElementsSearcher.notJetAnnotationEntry(psiElement)) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    JetDeclaration parentOfType = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JetDeclaration.class);
                    if (parentOfType == null) {
                        return;
                    }
                    JetAnnotationEntry annotationEntry = (JetAnnotationEntry)psiElement;
                    BindingContext context2 = ResolvePackage.analyzeFully(annotationEntry);
                    AnnotationDescriptor annotationDescriptor = context2.get(BindingContext.ANNOTATION, annotationEntry);
                    if (annotationDescriptor == null) {
                        return;
                    }
                    ClassifierDescriptor descriptor2 = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
                    if (descriptor2 == null) {
                        return;
                    }
                    if (!DescriptorUtils.getFqName(descriptor2).asString().equals(annotationFQN)) {
                        return;
                    }
                    if (parentOfType instanceof JetClass) {
                        PsiClass lightClass = LightClassUtil.getPsiClass((JetClass)parentOfType);
                        consumer2.process((Object)lightClass);
                    } else if (parentOfType instanceof JetNamedFunction || parentOfType instanceof JetSecondaryConstructor) {
                        PsiMethod wrappedMethod = LightClassUtil.getLightClassMethod((JetFunction)parentOfType);
                        consumer2.process((Object)wrappedMethod);
                    }
                }
            });
        }
        return true;
    }

    private static Collection<? extends PsiElement> getJetAnnotationCandidates(final PsiClass annClass, final SearchScope useScope) {
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<? extends PsiElement>>(){

            public Collection<? extends PsiElement> compute() {
                if (useScope instanceof GlobalSearchScope) {
                    Collection<JetAnnotationEntry> annotationEntries = JetAnnotationsIndex.getInstance().get(annClass.getName(), annClass.getProject(), (GlobalSearchScope)useScope);
                    if (annClass.getName().equals("Test")) {
                        annotationEntries.addAll(JetAnnotationsIndex.getInstance().get(annClass.getName().toLowerCase(), annClass.getProject(), (GlobalSearchScope)useScope));
                    }
                    return annotationEntries;
                }
                return new ArrayList();
            }
        });
    }

    private static boolean notJetAnnotationEntry(PsiElement found) {
        if (found instanceof JetAnnotationEntry) {
            return false;
        }
        VirtualFile faultyContainer = PsiUtilCore.getVirtualFile((PsiElement)found);
        LOG.error("Non annotation in annotations list: " + faultyContainer + "; element:" + found);
        if (faultyContainer != null && faultyContainer.isValid()) {
            FileBasedIndex.getInstance().requestReindex(faultyContainer);
        }
        return true;
    }
}

